/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.api;

import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.push.api.IPushSettings;
import tigase.xmpp.jid.BareJID;

public interface IPushRepository<DS extends DataSource>
extends DataSourceAware<DS> {
    public IPushSettings registerDevice(BareJID var1, BareJID var2, String var3, String var4) throws RepositoryException;

    public IPushSettings unregisterDevice(BareJID var1, BareJID var2, String var3, String var4) throws RepositoryException, ComponentException;

    public IPushSettings getNodeSettings(BareJID var1, String var2) throws RepositoryException;

    public Stream<IPushSettings> getNodeSettings(BareJID var1, String var2, String var3) throws RepositoryException;

    public Stream<IPushSettings> getNodeSettings(String var1, String var2) throws RepositoryException;

    default public IPushSettings getNodeSettings(BareJID serviceJid, String node, ElseHandler elseHandler) throws RepositoryException, ComponentException {
        IPushSettings iPushSettings = this.getNodeSettings(serviceJid, node);
        if (iPushSettings == null) {
            elseHandler.orElse(serviceJid, node);
        }
        return iPushSettings;
    }

    public static interface ElseHandler {
        public void orElse(BareJID var1, String var2) throws ComponentException;
    }
}

