/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.pages.SimpleConfigPage;
import tigase.http.modules.setup.questions.Question;
import tigase.http.modules.setup.questions.SingleAnswerQuestion;

public class ConnectorsPage
extends Page
implements SimpleConfigPage {
    private final Config config;
    private List<SingleAnswerQuestion> questionsWithLabels = new ArrayList<SingleAnswerQuestion>();

    public ConnectorsPage(Config config) {
        super("Connectivity", "connectors.html", Stream.empty());
        this.config = config;
        this.addConnectorsQuestions();
    }

    @Override
    protected void addQuestion(Question question) {
        super.addQuestion(question);
        if (question instanceof SingleAnswerQuestion) {
            this.questionsWithLabels.add((SingleAnswerQuestion)question);
        }
    }

    public List<SingleAnswerQuestion> getQuestionsWithLabels() {
        return this.questionsWithLabels;
    }

    private void addConnectorsQuestions() {
        SingleAnswerQuestion question = new ConnectorsQuestion("c2s", "Desktop / Mobile", this.config);
        this.addQuestion(question);
        question = new ConnectorsQuestion("bosh", "Web (HTTP)", this.config);
        this.addQuestion(question);
        question = new ConnectorsQuestion("ws2s", "Web (WebSocket)", this.config);
        this.addQuestion(question);
        question = new ConnectorsQuestion("s2s", "Federation", this.config);
        this.addQuestion(question);
        question = new SingleAnswerQuestion("ext", "External", () -> this.config.optionalComponents.contains("ext") && this.config.optionalComponents.contains("ext-man") ? "ext" : null, val -> {
            if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                this.config.optionalComponents.add("ext");
                this.config.optionalComponents.add("ext-man");
            } else {
                this.config.optionalComponents.remove("ext");
                this.config.optionalComponents.remove("ext-man");
            }
        });
        this.addQuestion(question);
        question = new SingleAnswerQuestion("http", "REST API/Admin UI", () -> this.config.optionalComponents.contains("http") ? "http" : null, val -> {
            if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                this.config.optionalComponents.add("http");
            } else {
                this.config.optionalComponents.remove("http");
            }
        });
        this.addQuestion(question);
    }

    public static class ConnectorsQuestion
    extends SingleAnswerQuestion {
        public ConnectorsQuestion(String id, String label, Config config) {
            super(id, label, () -> config.optionalComponents.contains(id) ? id : null, (String val) -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.optionalComponents.add(id);
                } else {
                    config.optionalComponents.remove(id);
                }
            });
        }
    }
}

