/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.http.modules.Module;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.CommandIfc;

public class CommandManager {
    private static final Logger log = Logger.getLogger(CommandManager.class.getCanonicalName());
    private Module module;
    private Map<String, CommandIfc> scriptCommands = new ConcurrentHashMap<String, CommandIfc>();

    public CommandManager(Module module) {
        this.module = module;
    }

    public Collection<CommandIfc> getCommands() {
        return this.scriptCommands.values();
    }

    public void registerCmd(CommandIfc cmd) {
        this.scriptCommands.put(cmd.getCommandId(), cmd);
    }

    public void unregisterCmd(CommandIfc cmd) {
        this.scriptCommands.remove(cmd.getCommandId());
    }

    public boolean execute(Packet pc) {
        Iq iqc = (Iq)pc;
        Command.Action action = Command.getAction((Packet)iqc);
        if (action == Command.Action.cancel) {
            Packet result = iqc.commandResult(Command.DataType.result);
            Command.addTextField((Packet)result, (String)"Note", (String)"Command canceled.");
            this.module.addOutPacket(result);
            return true;
        }
        String strCommand = iqc.getStrCommand();
        CommandIfc com = this.scriptCommands.get(strCommand);
        if (com != null) {
            Bindings bindings = com.getBindings();
            if (bindings != null) {
                this.module.initBindings(bindings);
            }
            ArrayDeque results = new ArrayDeque();
            com.runCommand(iqc, bindings, results);
            for (Packet res : results) {
                this.module.addOutPacket(res);
            }
            return true;
        }
        return false;
    }
}

