/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:ietf:params:xml:ns:xmpp-bind", parent=SessionManager.class, active=true)
public class BindResource
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc {
    public static final String DEF_RESOURCE_PREFIX_PROP_KEY = "def-resource-prefix";
    private static final String[] COMPRESS_PATH = new String[]{"compress"};
    private static final String EL_NAME = "bind";
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_BIND_PATH};
    private static final Logger log = Logger.getLogger(BindResource.class.getName());
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-bind";
    protected static final String ID = "urn:ietf:params:xml:ns:xmpp-bind";
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-bind"};
    private static final Element[] FEATURES = new Element[]{new Element("bind", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-bind"})};
    private static final String RESOURCE_PREFIX_DEF = "tigase-";
    private static int resGenerator = 0;
    private String resourceDefPrefix = "tigase-";
    @ConfigField(desc="Automatic resource assignment prefix", alias="def-resource-prefix")
    private String resourcePrefix = null;

    public BindResource() {
        this.setResourcePrefix(RESOURCE_PREFIX_DEF);
    }

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-bind";
    }

    public void setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        this.resourceDefPrefix = Math.abs(DNSResolverFactory.getInstance().getDefaultHost().hashCode()) + "-" + (this.resourcePrefix != null ? this.resourcePrefix : this.resourceDefPrefix);
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        block16: {
            if (session == null || session.isServerSession() || !session.isAuthorized() || C2SDeliveryErrorProcessor.isDeliveryError(packet)) {
                return false;
            }
            try {
                if (!session.getConnectionId().equals((Object)packet.getPacketFrom())) break block16;
                if (session.isResourceSet() || packet.isXMLNSStaticStr(Iq.IQ_BIND_PATH, "urn:ietf:params:xml:ns:xmpp-bind") || packet.isXMLNSStaticStr(COMPRESS_PATH, "http://jabber.org/protocol/compress")) {
                    JID from_jid = session.getJID();
                    if (from_jid != null) {
                        if (packet.getElemName() == "presence" && StanzaType.getSubsTypes().contains((Object)packet.getType()) && (packet.getStanzaFrom() == null || !from_jid.getBareJID().equals((Object)packet.getStanzaFrom().getBareJID()) || packet.getStanzaFrom().getResource() != null)) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Setting correct from attribute: {0}", from_jid);
                            }
                            packet.initVars(JID.jidInstance((BareJID)from_jid.getBareJID()), packet.getStanzaTo());
                        } else if (packet.getStanzaFrom() == null || (packet.getElemName() == "presence" && !StanzaType.getSubsTypes().contains((Object)packet.getType()) || packet.getElemName() != "presence") && !from_jid.equals((Object)packet.getStanzaFrom())) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "Setting correct from attribute: {0}", from_jid);
                            }
                            packet.initVars(from_jid, packet.getStanzaTo());
                        } else if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Skipping setting correct from attribute: {0}, is already correct.", packet.getStanzaFrom());
                        }
                    } else {
                        log.log(Level.WARNING, "Session is authenticated but session.getJid() is empty: {0}", packet.toStringSecure());
                    }
                    break block16;
                }
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must bind the resource first: http://www.xmpp.org/rfcs/rfc3920.html#bind", true));
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Session details: JID={0}, connectionId={1}, sessionId={2}", new Object[]{session.getjid(), session.getConnectionId(), session.getSessionId()});
                }
                return true;
            }
            catch (PacketErrorTypeException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Ignoring packet with an error to non-existen user session: {0}", packet.toStringSecure());
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Packet preprocessing exception: ", e);
                return false;
            }
        }
        return false;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            return;
        }
        Element request = packet.getElement();
        StanzaType type = packet.getType();
        try {
            switch (type) {
                case set: {
                    String resource = request.getChildCDataStaticStr(Iq.IQ_BIND_RESOURCE_PATH);
                    try {
                        if (resource == null || resource.trim().isEmpty()) {
                            resource = this.resourceDefPrefix + ++resGenerator;
                            session.setResource(resource);
                        } else {
                            try {
                                session.setResource(resource);
                            }
                            catch (TigaseStringprepException ex) {
                                log.log(Level.INFO, "Incrrect resource provided by the user: {0}, generating a different one by the server.", resource);
                                resource = this.resourceDefPrefix + ++resGenerator;
                                session.setResource(resource);
                            }
                        }
                    }
                    catch (TigaseStringprepException ex) {
                        log.log(Level.WARNING, "stringprep problem with the server generated resource: {0}", resource);
                    }
                    packet.initVars(session.getJID(), packet.getStanzaTo());
                    results.offer(packet.okResult(new Element("jid", session.getJID().toString()), 1));
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bind type is incorrect", false));
                    break;
                }
            }
        }
        catch (NotAuthorizedException e) {
            results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session != null && !session.isResourceSet() && session.isAuthorized()) {
            return FEATURES;
        }
        return null;
    }
}

