/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.component.ScheduledTask;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.BasicComponent;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.PacketFilterIfc;
import tigase.server.PacketWriterWithTimeout;
import tigase.server.Priority;
import tigase.server.QueueType;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.filters.PacketCounter;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.util.Algorithms;
import tigase.util.common.TimerTask;
import tigase.util.routing.PatternComparator;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.util.workqueue.PriorityQueueAbstract;
import tigase.util.workqueue.PriorityQueueRelaxed;
import tigase.xmpp.jid.JID;

public abstract class AbstractMessageReceiver
extends BasicComponent
implements StatisticsContainer,
MessageReceiver,
PacketWriterWithTimeout {
    public static final String INCOMING_FILTERS_PROP_KEY = "incoming-filters";
    public static final String INCOMING_FILTERS_PROP_VAL = "tigase.server.filters.PacketCounter";
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = new Long(Runtime.getRuntime().maxMemory() / 400000L).intValue();
    public static final String OUTGOING_FILTERS_PROP_KEY = "outgoing-filters";
    public static final String OUTGOING_FILTERS_PROP_VAL = "tigase.server.filters.PacketCounter";
    public static final String PACKET_DELIVERY_RETRY_COUNT_PROP_KEY = "packet-delivery-retry-count";
    public static final String SCHEDULER_THREADS_PROP_KEY = "scheduler-threads";
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private static final Logger log = Logger.getLogger("tigase.debug.AbstractMessageReceiver");
    @ConfigField(desc="Incoming filters", alias="incoming-filters")
    private final CopyOnWriteArrayList<PacketFilterIfc> incoming_filters = new CopyOnWriteArrayList();
    @ConfigField(desc="Outgoing filters", alias="outgoing-filters")
    private final CopyOnWriteArrayList<PacketFilterIfc> outgoing_filters = new CopyOnWriteArrayList();
    private final Priority[] pr_cache = Priority.values();
    private final List<PriorityQueueAbstract<Packet>> out_queues = new ArrayList<PriorityQueueAbstract<Packet>>(this.pr_cache.length);
    private final List<PriorityQueueAbstract<Packet>> in_queues = new ArrayList<PriorityQueueAbstract<Packet>>(this.pr_cache.length);
    private final long[] processPacketTimings = new long[100];
    private final Set<Pattern> regexRoutings = new ConcurrentSkipListSet<Pattern>(new PatternComparator());
    private final ThreadFactory threadFactory = new ThreadFactory(){
        private final ThreadFactory internal = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread th = this.internal.newThread(r);
            th.setName("scheduler_" + th.getName() + "-" + AbstractMessageReceiver.this.getName());
            return th;
        }
    };
    private final ConcurrentHashMap<String, PacketReceiverTaskIfc> waitingTasks = new ConcurrentHashMap(16, 0.75f, 4);
    protected int maxInQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    protected int maxOutQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    @ConfigField(desc="Maximum size of internal queues", alias="max-queue-size")
    protected int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private int in_queues_size = this.processingInThreads();
    private long last_hour_packets = 0L;
    private long last_minute_packets = 0L;
    private long last_second_packets = 0L;
    private int out_queues_size = this.processingOutThreads();
    private QueueListener out_thread = null;
    @ConfigField(desc="Packet delivery retry count", alias="packet-delivery-retry-count")
    private int packetDeliveryRetryCount = 15;
    private long packetId = 0L;
    private long packets_per_hour = 0L;
    private long packets_per_minute = 0L;
    private long packets_per_second = 0L;
    private MessageReceiver parent = null;
    private int pptIdx = 0;
    @ConfigField(desc="Priority queue class", alias="priority-queue-implementation")
    private Class<? extends PriorityQueueAbstract> priorityQueueClass = PriorityQueueRelaxed.class;
    @ConfigField(desc="Number of threads processing incoming packages", alias="processing-in-threads")
    private int processingInThreads = this.processingInThreads();
    @ConfigField(desc="Number of threads processing outgoing packages", alias="processing-out-threads")
    private int processingOutThreads = this.processingOutThreads();
    private ScheduledExecutorService receiverScheduler = null;
    private Timer receiverTasks = null;
    private String resourceForPacketWithTimeout = null;
    @Inject(nullAllowed=true)
    private Set<ScheduledTask> scheduledTasks;
    @ConfigField(desc="Number of threads for scheduler", alias="scheduler-threads")
    private int schedulerThreads_size = 1;
    private long statReceivedPacketsEr = 0L;
    private long statReceivedPacketsOk = 0L;
    private long statSentPacketsEr = 0L;
    private long statSentPacketsOk = 0L;
    private Queue<Runnable> tasksAwaitingReceiver = new LinkedList<Runnable>();
    private ArrayDeque<QueueListener> threadsQueueIn = null;
    private ArrayDeque<QueueListener> threadsQueueOut = null;
    private static final DecimalFormat df = new DecimalFormat("#0.00");

    private static String calculateOutliers(ArrayDeque<QueueListener> array) {
        if (array == null || array.size() == 0) {
            return "";
        }
        long[] allNumbers = new long[array.size()];
        int idx = 0;
        long sum = 0L;
        for (QueueListener queueListener : array) {
            sum += queueListener.packetCounter;
            allNumbers[idx++] = queueListener.packetCounter;
        }
        double mean = sum / (long)allNumbers.length;
        double tmp_sum_variance = 0.0;
        for (long allNumber : allNumbers) {
            tmp_sum_variance += Math.pow((double)allNumber - mean, 2.0);
        }
        double deviation = Math.sqrt(tmp_sum_variance / (double)allNumbers.length);
        ArrayList<String> outliers = new ArrayList<String>();
        for (QueueListener queueListener : array) {
            if (!(Math.abs((double)queueListener.packetCounter - mean) > 2.0 * deviation)) continue;
            outliers.add(queueListener.getName() + ":" + queueListener.packetCounter + ":x" + df.format((double)queueListener.packetCounter / mean));
        }
        return "mean: " + df.format(mean) + ", deviation: " + df.format(deviation) + (!outliers.isEmpty() ? ", outliers: " + ((Object)outliers).toString() : "");
    }

    public AbstractMessageReceiver() {
        PacketCounter filter = new PacketCounter();
        this.setIncomingFilters(Arrays.asList(filter));
        filter = new PacketCounter();
        this.setOutogingFilters(Arrays.asList(filter));
    }

    @Override
    public boolean addPacket(Packet packet) {
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}] queueIdx={1}, {2}", new Object[]{this.getName(), queueIdx, packet.toStringSecure()});
        }
        try {
            this.in_queues.get(queueIdx).put(packet, packet.getPriority().ordinal());
            ++this.statReceivedPacketsOk;
        }
        catch (InterruptedException e) {
            ++this.statReceivedPacketsEr;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet dropped for unknown reason: {0}", packet);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean addPacketNB(Packet packet) {
        boolean result;
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}] queueIdx={1}, {2}", new Object[]{this.getName(), queueIdx, packet.toStringSecure()});
        }
        if (result = this.in_queues.get(queueIdx).offer(packet, packet.getPriority().ordinal())) {
            ++this.statReceivedPacketsOk;
        } else {
            ++this.statReceivedPacketsEr;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet dropped due to queue overflow: {0}", packet);
            }
        }
        return result;
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        boolean result = true;
        Packet p = packets.peek();
        while (p != null && (result = this.addPacket(p))) {
            packets.poll();
            p = packets.peek();
        }
        return result;
    }

    public void addRegexRouting(String address) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} - attempt to add regex routing: {1}", new Object[]{this.getName(), address});
        }
        this.regexRoutings.add(Pattern.compile(address, 2));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "{0} - success adding regex routing: {1}", new Object[]{this.getName(), address});
        }
    }

    public void addTimerTask(TimerTask task, long delay) {
        if (task.isCancelled()) {
            return;
        }
        if (this.receiverScheduler == null) {
            this.tasksAwaitingReceiver.offer(() -> this.addTimerTask(task, delay));
            return;
        }
        ScheduledFuture<?> future = this.receiverScheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
        task.setScheduledFuture(future);
    }

    public void addTimerTask(TimerTask task, long initialDelay, long period) {
        if (task.isCancelled()) {
            return;
        }
        if (this.receiverScheduler == null) {
            this.tasksAwaitingReceiver.offer(() -> this.addTimerTask(task, initialDelay, period));
            return;
        }
        ScheduledFuture<?> future = this.receiverScheduler.scheduleAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
        task.setScheduledFuture(future);
    }

    public void addTimerTaskWithTimeout(final TimerTask task, long delay, long timeout) {
        if (task.isCancelled()) {
            return;
        }
        if (this.receiverScheduler == null) {
            this.tasksAwaitingReceiver.offer(() -> this.addTimerTaskWithTimeout(task, delay, timeout));
            return;
        }
        this.receiverScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Cancelling tigase task (timeout): " + task);
                }
                if (task != null) {
                    task.cancel(true);
                }
            }
        }, timeout, TimeUnit.MILLISECONDS);
        this.addTimerTask(task, delay);
    }

    public void addTimerTaskWithTimeout(final TimerTask task, long delay, long period, long timeout) {
        if (task.isCancelled()) {
            return;
        }
        if (this.receiverScheduler == null) {
            this.tasksAwaitingReceiver.offer(() -> this.addTimerTaskWithTimeout(task, delay, period, timeout));
            return;
        }
        this.receiverScheduler.schedule(new TimerTask(){

            @Override
            public void run() {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Cancelling tigase task (timeout): " + task);
                }
                if (task != null) {
                    task.cancel(true);
                }
            }
        }, timeout, TimeUnit.MILLISECONDS);
        this.addTimerTask(task, delay, period);
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    @Override
    public synchronized void everyHour() {
        this.packets_per_hour = this.statReceivedPacketsOk - this.last_hour_packets;
        this.last_hour_packets = this.statReceivedPacketsOk;
        super.everyHour();
    }

    @Override
    public synchronized void everyMinute() {
        this.packets_per_minute = this.statReceivedPacketsOk - this.last_minute_packets;
        this.last_minute_packets = this.statReceivedPacketsOk;
        this.receiverTasks.purge();
        super.everyMinute();
    }

    @Override
    public synchronized void everySecond() {
        this.packets_per_second = this.statReceivedPacketsOk - this.last_second_packets;
        this.last_second_packets = this.statReceivedPacketsOk;
        super.everySecond();
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getPacketTo() != null && !this.getComponentId().equals((Object)packet.getPacketTo())) {
            return packet.getPacketTo().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().getBareJID().hashCode();
        }
        return 1;
    }

    public String newPacketId(String prefix) {
        StringBuilder sb = new StringBuilder(32);
        if (prefix != null) {
            sb.append(prefix).append("-");
        }
        sb.append(this.getName()).append(++this.packetId);
        return sb.toString();
    }

    public int processingInThreads() {
        return 1;
    }

    public int processingOutThreads() {
        return 1;
    }

    public void processOutPacket(Packet packet) {
        if (this.parent != null) {
            this.parent.addPacket(packet);
        } else {
            this.addPacketNB(packet);
        }
    }

    public abstract void processPacket(Packet var1);

    @Override
    public final void processPacket(Packet packet, Queue<Packet> results) {
        this.addPacketNB(packet);
    }

    @Override
    public void release() {
        this.stop();
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public int schedulerThreads() {
        return 2;
    }

    @Override
    public void start() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.INFO, "{0}: starting queue management threads ...", this.getName());
        }
        this.startThreads();
        if (this.scheduledTasks != null) {
            for (ScheduledTask task : this.scheduledTasks) {
                task.initialize();
            }
        }
    }

    public void stop() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.INFO, "{0}: stopping queue management threads ...", this.getName());
        }
        this.stopThreads();
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Last second packets", this.packets_per_second, Level.FINE);
        list.add(this.getName(), "Last minute packets", this.packets_per_minute, Level.FINE);
        list.add(this.getName(), "Last hour packets", this.packets_per_hour, Level.FINE);
        list.add(this.getName(), "Processing threads", this.processingInThreads(), Level.FINER);
        list.add(this.getName(), StatisticType.MSG_RECEIVED_OK.getDescription(), this.statReceivedPacketsOk, Level.FINE);
        list.add(this.getName(), StatisticType.MSG_SENT_OK.getDescription(), this.statSentPacketsOk, Level.FINE);
        if (list.checkLevel(Level.FINEST)) {
            int i;
            int[] in_priority_sizes = this.in_queues.get(0).size();
            for (int i2 = 1; i2 < this.in_queues.size(); ++i2) {
                int[] tmp_pr_sizes = this.in_queues.get(i2).size();
                for (int j = 0; j < tmp_pr_sizes.length; ++j) {
                    int n = j;
                    in_priority_sizes[n] = in_priority_sizes[n] + tmp_pr_sizes[j];
                }
            }
            Object out_priority_sizes = this.out_queues.get(0).size();
            for (i = 1; i < this.out_queues.size(); ++i) {
                int[] tmp_pr_sizes = this.out_queues.get(i).size();
                for (int j = 0; j < tmp_pr_sizes.length; ++j) {
                    Object object = out_priority_sizes;
                    int n = j;
                    object[n] = object[n] + tmp_pr_sizes[j];
                }
            }
            for (i = 0; i < in_priority_sizes.length; ++i) {
                Priority queue = Priority.values()[i];
                list.add(this.getName(), "In queue wait: " + queue.name(), in_priority_sizes[queue.ordinal()], Level.FINEST);
            }
            for (i = 0; i < ((Object)out_priority_sizes).length; ++i) {
                Priority queue = Priority.values()[i];
                list.add(this.getName(), "Out queue wait: " + queue.name(), (int)out_priority_sizes[queue.ordinal()], Level.FINEST);
            }
        }
        int in_queue_size = 0;
        for (PriorityQueueAbstract<Packet> total_size : this.in_queues) {
            in_queue_size += total_size.totalSize();
        }
        int out_queue_size = 0;
        for (PriorityQueueAbstract<Packet> total_size : this.out_queues) {
            out_queue_size += total_size.totalSize();
        }
        list.add(this.getName(), "Total In queues wait", in_queue_size, Level.INFO);
        list.add(this.getName(), "Total Out queues wait", out_queue_size, Level.INFO);
        list.add(this.getName(), "Total queues wait", in_queue_size + out_queue_size, Level.INFO);
        list.add(this.getName(), StatisticType.MAX_QUEUE_SIZE.getDescription(), this.maxInQueueSize * this.processingInThreads(), Level.FINEST);
        list.add(this.getName(), StatisticType.IN_QUEUE_OVERFLOW.getDescription(), this.statReceivedPacketsEr, Level.INFO);
        list.add(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW.getDescription(), this.statSentPacketsEr, Level.INFO);
        list.add(this.getName(), "Total queues overflow", this.statReceivedPacketsEr + this.statSentPacketsEr, Level.INFO);
        long res = 0L;
        for (long ppt : this.processPacketTimings) {
            res += ppt;
        }
        long prcessingTime = res / (long)this.processPacketTimings.length;
        list.add(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", prcessingTime, Level.FINE);
        for (PacketFilterIfc packetFilter : this.incoming_filters) {
            packetFilter.getStatistics(list);
        }
        for (PacketFilterIfc packetFilter : this.outgoing_filters) {
            packetFilter.getStatistics(list);
        }
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Processed packets thread IN", this.threadsQueueIn.toString(), Level.FINEST);
            list.add(this.getName(), "Processed packets thread OUT", this.threadsQueueOut.toString(), Level.FINEST);
            list.add(this.getName(), "Processed packets thread (outliers) IN", AbstractMessageReceiver.calculateOutliers(this.threadsQueueIn), Level.FINEST);
            list.add(this.getName(), "Processed packets thread (outliers) OUT", AbstractMessageReceiver.calculateOutliers(this.threadsQueueOut), Level.FINEST);
        }
        super.getStatistics(list);
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} matching: {1} against {2}", new Object[]{this.getName(), address, pat.toString()});
            }
            if (!pat.matcher(address).matches()) continue;
            return true;
        }
        return false;
    }

    public void setIncomingFilters(List<PacketFilterIfc> filters) {
        for (PacketFilterIfc filter : filters) {
            filter.init(this.getName(), QueueType.IN_QUEUE);
        }
        this.incoming_filters.clear();
        this.incoming_filters.addAll(filters);
    }

    public void setOutogingFilters(List<PacketFilterIfc> filters) {
        for (PacketFilterIfc filter : filters) {
            filter.init(this.getName(), QueueType.OUT_QUEUE);
        }
        this.outgoing_filters.clear();
        this.outgoing_filters.addAll(filters);
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        boolean recreate;
        super.beanConfigurationChanged(changedFields);
        boolean bl = recreate = this.maxInQueueSize != this.maxQueueSize / this.processingInThreads * 2 || this.maxOutQueueSize != this.maxQueueSize / this.processingOutThreads * 2;
        if (this.in_queues.isEmpty() || !this.priorityQueueClass.equals(this.in_queues.get(0).getClass())) {
            recreate = true;
            this.in_queues.clear();
            this.out_queues.clear();
        }
        if (this.processingInThreads != this.in_queues_size || this.processingOutThreads == this.out_queues_size) {
            recreate = true;
            this.in_queues_size = this.processingInThreads;
            this.out_queues_size = this.processingOutThreads;
            this.in_queues.clear();
            this.out_queues.clear();
        }
        if (recreate) {
            this.recreateProcessingQueues(this.maxQueueSize);
        }
    }

    @Override
    public void setCompId(JID jid) {
        super.setCompId(jid);
        this.resourceForPacketWithTimeout = jid != null ? Algorithms.sha256((String)jid.getDomain()) : null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.in_queues_size = this.processingInThreads();
        this.out_queues_size = this.processingOutThreads();
        this.schedulerThreads_size = this.schedulerThreads();
        this.setIncomingFilters(new ArrayList<PacketFilterIfc>(this.incoming_filters));
        this.setOutogingFilters(new ArrayList<PacketFilterIfc>(this.outgoing_filters));
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    public void setSchedulerThreads_size(int size) {
        log.log(Level.FINE, "Setting scheduler size to: {0}", new Object[]{size});
        if (this.schedulerThreads_size != size) {
            this.schedulerThreads_size = size;
            ScheduledExecutorService scheduler = this.receiverScheduler;
            this.receiverScheduler = Executors.newScheduledThreadPool(size, this.threadFactory);
            scheduler.shutdown();
        }
    }

    public boolean addOutPacketWithTimeout(Packet packet, ReceiverTimeoutHandler handler, long delay, TimeUnit unit) {
        new PacketReceiverTask(handler, delay, unit, packet);
        return this.addOutPacket(packet);
    }

    @Override
    public boolean addOutPacketWithTimeout(Packet packet, Duration timeout, PacketWriterWithTimeout.Handler handler) {
        new SimplePacketReceiverTask(handler, timeout, packet);
        return this.addOutPacket(packet);
    }

    protected boolean addOutPacket(Packet packet) {
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.out_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}]  queueIdx={1}, {2}", new Object[]{this.getName(), queueIdx, packet.toStringSecure()});
        }
        try {
            this.out_queues.get(queueIdx).put(packet, packet.getPriority().ordinal());
            ++this.statSentPacketsOk;
        }
        catch (InterruptedException e) {
            ++this.statSentPacketsEr;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet dropped for unknown reason: {0}", packet);
            }
            return false;
        }
        return true;
    }

    protected boolean addOutPacketNB(Packet packet) {
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.out_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "[{0}]  queueIdx={1}, {2}", new Object[]{this.getName(), queueIdx, packet.toStringSecure()});
        }
        boolean result = false;
        result = this.out_queues.get(queueIdx).offer(packet, packet.getPriority().ordinal());
        if (result) {
            ++this.statSentPacketsOk;
        } else {
            ++this.statSentPacketsEr;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet dropped due to queue overflow: {0}", packet);
            }
        }
        return result;
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    protected void addTimerTask(TimerTask task, long delay, TimeUnit unit) {
        if (task.isCancelled()) {
            return;
        }
        if (this.receiverScheduler == null) {
            this.tasksAwaitingReceiver.offer(() -> this.addTimerTask(task, delay, unit));
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "adding timer, task: {0}, delay: {1}, TimeUnit: {2}, receiverScheduler: {3}", new Object[]{task, delay, unit, this.receiverScheduler});
        }
        ScheduledFuture<?> future = this.receiverScheduler.schedule(task, delay, unit);
        task.setScheduledFuture(future);
    }

    protected Integer getMaxQueueSize(int def) {
        return def;
    }

    private void recreateProcessingQueues(int maxQueueSize) {
        PriorityQueueAbstract queue;
        int i;
        this.maxInQueueSize = maxQueueSize / this.processingInThreads * 2;
        this.maxOutQueueSize = maxQueueSize / this.processingOutThreads * 2;
        log.log(Level.FINEST, "{0} maxQueueSize: {1}, maxInQueueSize: {2}, maxOutQueueSize: {3}", new Object[]{this.getName(), maxQueueSize, this.maxInQueueSize, this.maxOutQueueSize});
        log.log(Level.FINEST, "{0} maxQueueSize: {1}, maxInQueueSize: {2}, maxOutQueueSize: {3}", new Object[]{this.getName(), maxQueueSize, this.maxInQueueSize, this.maxOutQueueSize});
        if (this.maxInQueueSize <= 15 || maxQueueSize <= 15) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"You configured component of class " + this.getClass().getCanonicalName() + " with packet queues total size set to " + maxQueueSize, "Component uses " + Math.max(this.processingInThreads, this.processingOutThreads) + " queues which would give a limit of " + Math.min(this.maxInQueueSize, this.maxOutQueueSize) + " packets per queue.", "This value is too low for Tigase XMPP Server to run properly. Please adjust the configuration of the server.", "max-queue-size should be set to at least " + Math.max(this.processingInThreads, this.processingOutThreads) / 2 * 16});
        }
        if (this.in_queues.size() == 0) {
            for (i = 0; i < this.in_queues_size; ++i) {
                queue = PriorityQueueAbstract.getPriorityQueue(this.pr_cache.length, this.maxInQueueSize, this.priorityQueueClass);
                this.in_queues.add(queue);
            }
        } else {
            for (i = 0; i < this.in_queues.size(); ++i) {
                this.in_queues.get(i).setMaxSize(this.maxInQueueSize);
            }
        }
        if (this.out_queues.size() == 0) {
            for (i = 0; i < this.out_queues_size; ++i) {
                queue = PriorityQueueAbstract.getPriorityQueue(this.pr_cache.length, this.maxOutQueueSize, this.priorityQueueClass);
                this.out_queues.add(queue);
            }
        } else {
            for (i = 0; i < this.out_queues.size(); ++i) {
                this.out_queues.get(i).setMaxSize(this.maxOutQueueSize);
            }
        }
    }

    private Packet filterPacket(Packet packet, CopyOnWriteArrayList<PacketFilterIfc> filters) {
        PacketFilterIfc packetFilterIfc;
        Packet result = packet;
        Iterator<PacketFilterIfc> iterator = filters.iterator();
        while (iterator.hasNext() && (result = (packetFilterIfc = iterator.next()).filter(result)) != null) {
        }
        return result;
    }

    private void startThreads() {
        Runnable task;
        int i;
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "Starting threads, in_queues_size: {0}, out_queues_size: {1}, schedulerThreads_size: {2}", new Object[]{this.in_queues_size, this.out_queues_size, this.schedulerThreads_size});
        }
        if (this.threadsQueueIn == null) {
            this.threadsQueueIn = new ArrayDeque(8);
            for (i = 0; i < this.in_queues_size; ++i) {
                QueueListener in_thread = new QueueListener(this.in_queues.get(i), QueueType.IN_QUEUE);
                in_thread.setName("in_" + i + "-" + this.getName());
                in_thread.start();
                this.threadsQueueIn.add(in_thread);
            }
        }
        if (this.threadsQueueOut == null) {
            this.threadsQueueOut = new ArrayDeque(8);
            for (i = 0; i < this.out_queues_size; ++i) {
                QueueListener out_thread = new QueueListener(this.out_queues.get(i), QueueType.OUT_QUEUE);
                out_thread.setName("out_" + i + "-" + this.getName());
                out_thread.start();
                this.threadsQueueOut.add(out_thread);
            }
        }
        this.receiverScheduler = Executors.newScheduledThreadPool(this.schedulerThreads_size, this.threadFactory);
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.scheduleAtFixedRate(new java.util.TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everySecond();
            }
        }, 1000L, 1000L);
        this.receiverTasks.scheduleAtFixedRate(new java.util.TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyMinute();
            }
        }, 60000L, 60000L);
        this.receiverTasks.scheduleAtFixedRate(new java.util.TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyHour();
            }
        }, 3600000L, 3600000L);
        while ((task = this.tasksAwaitingReceiver.poll()) != null) {
            task.run();
        }
    }

    private void stopThreads() {
        try {
            this.stopThread(this.threadsQueueIn);
            this.stopThread(this.threadsQueueOut);
            if (this.out_thread != null) {
                this.out_thread.threadStopped = true;
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.threadsQueueIn = null;
        this.threadsQueueOut = null;
        this.out_thread = null;
        if (this.receiverTasks != null) {
            this.receiverTasks.cancel();
            this.receiverTasks = null;
        }
        if (this.receiverScheduler != null) {
            this.receiverScheduler.shutdownNow();
            this.receiverScheduler = null;
        }
    }

    private void stopThread(ArrayDeque<QueueListener> threadsQueue) throws InterruptedException {
        if (threadsQueue != null) {
            for (QueueListener in_thread : threadsQueue) {
                in_thread.threadStopped = true;
                in_thread.interrupt();
            }
            for (QueueListener in_thread : threadsQueue) {
                while (in_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
    }

    protected String getResourceForPacketWithTimeout() {
        return this.resourceForPacketWithTimeout;
    }

    static /* synthetic */ int access$600(AbstractMessageReceiver x0) {
        return x0.packetDeliveryRetryCount;
    }

    private class QueueListener
    extends Thread {
        private String compName = null;
        private long packetCounter = 0L;
        private PriorityQueueAbstract<Packet> queue;
        private boolean threadStopped = false;
        private QueueType type = null;

        private QueueListener(PriorityQueueAbstract<Packet> q, QueueType type) {
            this.queue = q;
            this.type = type;
            this.compName = AbstractMessageReceiver.this.getName();
        }

        @Override
        public void run() {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0} starting queue processing.", this.getName());
            }
            Packet packet = null;
            ArrayDeque<Packet> results = new ArrayDeque<Packet>(2);
            block7: while (!this.threadStopped) {
                try {
                    packet = this.queue.take();
                    ++this.packetCounter;
                    switch (this.type) {
                        case IN_QUEUE: {
                            long timing;
                            String id;
                            long startPPT = System.currentTimeMillis();
                            PacketReceiverTaskIfc task = null;
                            if (packet.getTo() != null) {
                                id = packet.getTo().toString() + packet.getStanzaId();
                                task = (PacketReceiverTaskIfc)AbstractMessageReceiver.this.waitingTasks.remove(id);
                            }
                            if (task == null && packet.getStanzaTo() != null) {
                                id = packet.getStanzaTo().toString() + packet.getStanzaId();
                                task = (PacketReceiverTaskIfc)AbstractMessageReceiver.this.waitingTasks.remove(id);
                            }
                            if (task != null) {
                                task.handleResponse(packet);
                                continue block7;
                            }
                            boolean processed = false;
                            if (packet.isCommand() && packet.getStanzaTo() != null && this.compName.equals(packet.getStanzaTo().getLocalpart()) && AbstractMessageReceiver.this.isLocalDomain(packet.getStanzaTo().getDomain()) && (processed = AbstractMessageReceiver.this.processScriptCommand(packet, results))) {
                                Packet result = null;
                                while ((result = (Packet)results.poll()) != null) {
                                    AbstractMessageReceiver.this.addOutPacket(result);
                                }
                            }
                            if (!processed && (packet = AbstractMessageReceiver.this.filterPacket(packet, AbstractMessageReceiver.this.incoming_filters)) != null) {
                                AbstractMessageReceiver.this.processPacket(packet);
                            }
                            int idx = AbstractMessageReceiver.this.pptIdx;
                            AbstractMessageReceiver.this.pptIdx = (AbstractMessageReceiver.this.pptIdx + 1) % AbstractMessageReceiver.this.processPacketTimings.length;
                            ((AbstractMessageReceiver)AbstractMessageReceiver.this).processPacketTimings[idx] = timing = System.currentTimeMillis() - startPPT;
                            continue block7;
                        }
                        case OUT_QUEUE: {
                            if ((packet = AbstractMessageReceiver.this.filterPacket(packet, AbstractMessageReceiver.this.outgoing_filters)) == null) continue block7;
                            AbstractMessageReceiver.this.processOutPacket(packet);
                            continue block7;
                        }
                    }
                    log.log(Level.SEVERE, "Unknown queue element type: {0}", (Object)this.type);
                }
                catch (InterruptedException e) {
                    System.out.println("interrupted " + this.getName());
                }
                catch (Exception e) {
                    if (this.threadStopped) continue;
                    log.log(Level.SEVERE, "[" + this.getName() + "] Exception during packet processing: " + packet, e);
                }
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.packetCounter);
        }
    }

    private class PacketReceiverTask
    extends TimerTask
    implements PacketReceiverTaskIfc {
        private ReceiverTimeoutHandler handler = null;
        private String id = null;
        private Packet packet = null;
        private int retryCount = AbstractMessageReceiver.access$600(AbstractMessageReceiver.this);

        private PacketReceiverTask(ReceiverTimeoutHandler handler, long delay, TimeUnit unit, Packet packet) {
            this.handler = handler;
            this.packet = packet;
            this.id = packet.getFrom().toString() + packet.getStanzaId();
            String countStr = packet.getElement().getAttributeStaticStr("retryCount");
            if (countStr != null) {
                this.retryCount = Byte.valueOf(countStr).byteValue();
                --this.retryCount;
            }
            this.packet.getElement().setAttribute("retryCount", Integer.toString(this.retryCount));
            if (this.retryCount < 0) {
                PacketReceiverTaskIfc remove;
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "Dropping command packet! Retry limit reached for packet with ID: {0}, retryCount: {1}, packet: {2}", new Object[]{this.id, this.retryCount, this.packet});
                }
                if ((remove = (PacketReceiverTaskIfc)AbstractMessageReceiver.this.waitingTasks.remove(this.id)) instanceof TimerTask) {
                    ((TimerTask)((Object)remove)).cancel();
                }
                return;
            }
            String delayStr = packet.getElement().getAttributeStaticStr("delay");
            if (delayStr != null) {
                delay = (long)((double)Long.valueOf(delayStr).longValue() * 1.5);
            }
            this.packet.getElement().setAttribute("delay", Long.toString(delay));
            AbstractMessageReceiver.this.waitingTasks.put(this.id, this);
            AbstractMessageReceiver.this.addTimerTask((TimerTask)this, delay, unit);
            try {
                this.packet.initVars();
            }
            catch (TigaseStringprepException e) {
                log.log(Level.WARNING, "Reinitializing packet failed", e);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "[{0}] Added timeout task for ID: {1}, delay: {2}, retryCount: {3}, packet: {4}", new Object[]{AbstractMessageReceiver.this.getName(), this.id, delay, this.retryCount, this.packet});
            }
        }

        @Override
        public void handleResponse(Packet response) {
            this.cancel();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "[{0}] Response received for id: {1}", new Object[]{AbstractMessageReceiver.this.getName(), this.id});
            }
            this.handler.responseReceived(this.packet, response);
        }

        @Override
        public void handleTimeout() {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "[{0}] Fired timeout for id: {1}", new Object[]{AbstractMessageReceiver.this.getName(), this.id});
            }
            AbstractMessageReceiver.this.waitingTasks.remove(this.id);
            this.handler.timeOutExpired(this.packet);
        }

        @Override
        public void run() {
            this.handleTimeout();
        }
    }

    private class SimplePacketReceiverTask
    extends TimerTask
    implements PacketReceiverTaskIfc {
        private final PacketWriterWithTimeout.Handler handler;
        private final String id;

        SimplePacketReceiverTask(PacketWriterWithTimeout.Handler handler, Duration timeout, Packet packet) {
            this.handler = handler;
            JID from = packet.getStanzaFrom();
            if (from.getResource() == null && AbstractMessageReceiver.this.isLocalDomainOrComponent(from.toString())) {
                from = from.copyWithResourceNS(AbstractMessageReceiver.this.getResourceForPacketWithTimeout());
            }
            if (packet.getStanzaId() != null) {
                throw new IllegalArgumentException("Packet cannot have `id` set as it is required to be unique and will be set internally.");
            }
            packet.getElement().setAttribute("id", UUID.randomUUID().toString());
            packet.initVars(from, packet.getStanzaTo());
            this.id = packet.getStanzaFrom().toString() + packet.getStanzaId();
            AbstractMessageReceiver.this.waitingTasks.put(this.id, this);
            AbstractMessageReceiver.this.addTimerTask((TimerTask)this, timeout.getSeconds(), TimeUnit.SECONDS);
        }

        @Override
        public void handleResponse(Packet response) {
            this.cancel();
            this.handler.handle(response);
        }

        @Override
        public void handleTimeout() {
            AbstractMessageReceiver.this.waitingTasks.remove(this.id);
            this.handler.handle(null);
        }

        @Override
        public void run() {
            this.handleTimeout();
        }
    }

    private static interface PacketReceiverTaskIfc {
        public void handleResponse(Packet var1);

        public void handleTimeout();
    }
}

