/*
 * Decompiled with CFR 0.152.
 */
package tigase.osgi;

import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.osgi.Activator;
import tigase.osgi.ModulesManager;
import tigase.osgi.util.ClassUtil;

public abstract class AbstractActivator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private static Predicate<Class> PUBLIC_AND_NOT_ABSTRACT = cls -> {
        int mod = cls.getModifiers();
        return !Modifier.isAbstract(mod) && Modifier.isPublic(mod);
    };
    protected Set<Class<?>> classesToExport = null;
    private BundleContext context = null;
    private ModulesManager serviceManager = null;
    private ServiceReference serviceReference = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        AbstractActivator abstractActivator = this;
        synchronized (abstractActivator) {
            this.context = bc;
            bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
            this.serviceReference = bc.getServiceReference(ModulesManager.class.getName());
            if (this.serviceReference != null) {
                this.serviceManager = (ModulesManager)bc.getService(this.serviceReference);
                this.registerAddons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        AbstractActivator abstractActivator = this;
        synchronized (abstractActivator) {
            if (this.serviceManager != null) {
                this.unregisterAddons();
                this.context.ungetService(this.serviceReference);
                this.serviceManager = null;
                this.serviceReference = null;
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)this.context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            this.context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    private void registerAddons() {
        if (this.serviceManager != null) {
            if (this.classesToExport == null) {
                this.classesToExport = ClassUtil.getClassesFromBundle(this.context.getBundle()).stream().filter(PUBLIC_AND_NOT_ABSTRACT).collect(Collectors.toSet());
            }
            this.classesToExport.forEach(cls -> this.serviceManager.registerClass((Class<?>)cls));
            this.serviceManager.update();
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            if (this.classesToExport != null) {
                this.classesToExport.forEach(cls -> this.serviceManager.unregisterClass((Class<?>)cls));
            }
            this.serviceManager.update();
        }
    }
}

