/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.HashSet;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="memory-checker-task", parent=MonitorComponent.class, active=true)
public class MemoryCheckerTask
extends AbstractConfigurableTimerTask
implements InfoTask,
Initializable {
    public static final String HEAP_MEMORY_MONITOR_EVENT_NAME = "tigase.monitor.tasks.HeapMemoryMonitorEvent";
    public static final String NONHEAP_MEMORY_MONITOR_EVENT_NAME = "tigase.monitor.tasks.NonHeapMemoryMonitorEvent";
    private static final TimestampHelper dtf = new TimestampHelper();
    private final HashSet<String> triggeredEvents = new HashSet();
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Max Heap Mem Usage Threshold [%]")
    private int maxHeapMemUsagePercentThreshold = 90;
    @ConfigField(desc="Max Non-Heap Mem Usage Threshold [%]")
    private int maxNonHeapMemUsagePercentThreshold = 90;
    @Inject
    private MonitorRuntime runtime;

    @Override
    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle((String)"maxHeapMemUsagePercentThreshold", (String)String.valueOf(this.maxHeapMemUsagePercentThreshold), (String)"Alarm when heap mem usage is bigger than [%]"));
        form.addField(Field.fieldTextSingle((String)"maxNonHeapMemUsagePercentThreshold", (String)String.valueOf(this.maxNonHeapMemUsagePercentThreshold), (String)"Alarm when non-heap mem usage is bigger than [%]"));
        return form;
    }

    public int getMaxHeapMemUsagePercentThreshold() {
        return this.maxHeapMemUsagePercentThreshold;
    }

    public void setMaxHeapMemUsagePercentThreshold(Integer maxHeapMemUsagePercentThreshold) {
        this.maxHeapMemUsagePercentThreshold = maxHeapMemUsagePercentThreshold;
    }

    public int getMaxNonHeapMemUsagePercentThreshold() {
        return this.maxNonHeapMemUsagePercentThreshold;
    }

    public void setMaxNonHeapMemUsagePercentThreshold(Integer maxNonHeapMemUsagePercentThreshold) {
        this.maxNonHeapMemUsagePercentThreshold = maxNonHeapMemUsagePercentThreshold;
    }

    @Override
    public Form getTaskInfo() {
        Form result = new Form("", "Memory Information", "");
        result.addField(Field.fieldTextSingle((String)"heapMemMax", (String)Long.toString(this.runtime.getHeapMemMax()), (String)"Heap Memory Max"));
        result.addField(Field.fieldTextSingle((String)"heapMemUsed", (String)Long.toString(this.runtime.getHeapMemUsed()), (String)"Heap Memory Used"));
        result.addField(Field.fieldTextSingle((String)"heapMemUsedPercentage", (String)Float.toString(this.runtime.getHeapMemUsage()), (String)"Heap Memory Used [%]"));
        result.addField(Field.fieldTextSingle((String)"nonHeapMemMax", (String)Long.toString(this.runtime.getNonHeapMemMax()), (String)"Non-Heap Memory Max"));
        result.addField(Field.fieldTextSingle((String)"nonHeapMemUsed", (String)Long.toString(this.runtime.getNonHeapMemUsed()), (String)"Non-Heap Memory Used"));
        result.addField(Field.fieldTextSingle((String)"nonHeapMemUsedPercentage", (String)Float.toString(this.runtime.getNonHeapMemUsage()), (String)"Non-Heap Memory Used [%]"));
        result.addField(Field.fieldTextSingle((String)"directMemUsed", (String)Long.toString(this.runtime.getDirectMemUsed()), (String)"Direct Memory Used"));
        return result;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(HEAP_MEMORY_MONITOR_EVENT_NAME, "Fired when HEAP memory is too low", false);
        this.eventBus.registerEvent(NONHEAP_MEMORY_MONITOR_EVENT_NAME, "Fired when NON-HEAP memory is too low", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field nonHeapMemUsage;
        Field heapMemUsage = form.get("maxHeapMemUsagePercentThreshold");
        if (heapMemUsage != null) {
            this.maxHeapMemUsagePercentThreshold = Integer.parseInt(heapMemUsage.getValue());
        }
        if ((nonHeapMemUsage = form.get("maxNonHeapMemUsagePercentThreshold")) != null) {
            this.maxNonHeapMemUsagePercentThreshold = Integer.parseInt(nonHeapMemUsage.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void run() {
        float curHeapMemUsagePercent = this.runtime.getHeapMemUsage();
        if (curHeapMemUsagePercent >= (float)this.maxHeapMemUsagePercentThreshold) {
            Element event = new Element(HEAP_MEMORY_MONITOR_EVENT_NAME);
            event.addChild((XMLNodeIfc)new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild((XMLNodeIfc)new Element("timestamp", "" + dtf.format(new Date())));
            event.addChild((XMLNodeIfc)new Element("heapMemUsage", Float.toString(curHeapMemUsagePercent)));
            event.addChild((XMLNodeIfc)new Element("heapMemMax", Long.toString(this.runtime.getHeapMemMax())));
            event.addChild((XMLNodeIfc)new Element("heapMemUsed", Long.toString(this.runtime.getHeapMemUsed())));
            event.addChild((XMLNodeIfc)new Element("nonHeapMemMax", Long.toString(this.runtime.getNonHeapMemMax())));
            event.addChild((XMLNodeIfc)new Element("nonHeapMemUsed", Long.toString(this.runtime.getNonHeapMemUsed())));
            event.addChild((XMLNodeIfc)new Element("directMemUsed", Long.toString(this.runtime.getDirectMemUsed())));
            event.addChild((XMLNodeIfc)new Element("message", "Heap memory usage is higher than " + this.maxHeapMemUsagePercentThreshold + " and it equals " + curHeapMemUsagePercent));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(HEAP_MEMORY_MONITOR_EVENT_NAME);
        }
        float curNonHeapMemUsagePercent = this.runtime.getNonHeapMemUsage();
        if (curNonHeapMemUsagePercent >= (float)this.maxNonHeapMemUsagePercentThreshold) {
            Element event = new Element(NONHEAP_MEMORY_MONITOR_EVENT_NAME);
            event.addChild((XMLNodeIfc)new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild((XMLNodeIfc)new Element("timestamp", "" + dtf.format(new Date())));
            event.addChild((XMLNodeIfc)new Element("nonHeapMemUsage", Float.toString(curNonHeapMemUsagePercent)));
            event.addChild((XMLNodeIfc)new Element("heapMemMax", Long.toString(this.runtime.getHeapMemMax())));
            event.addChild((XMLNodeIfc)new Element("heapMemUsed", Long.toString(this.runtime.getHeapMemUsed())));
            event.addChild((XMLNodeIfc)new Element("nonHeapMemMax", Long.toString(this.runtime.getNonHeapMemMax())));
            event.addChild((XMLNodeIfc)new Element("nonHeapMemUsed", Long.toString(this.runtime.getNonHeapMemUsed())));
            event.addChild((XMLNodeIfc)new Element("directMemUsed", Long.toString(this.runtime.getDirectMemUsed())));
            event.addChild((XMLNodeIfc)new Element("message", "Non-Heap memory usage is higher than " + this.maxNonHeapMemUsagePercentThreshold + " and it equals " + curHeapMemUsagePercent));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(NONHEAP_MEMORY_MONITOR_EVENT_NAME);
        }
    }
}

