/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import tigase.db.Repository;
import tigase.db.beans.MDPoolBean;
import tigase.db.beans.MDPoolConfigBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsInvocationHandler;
import tigase.stats.StatisticsList;

public abstract class MDPoolBeanWithStatistics<S extends Repository, T extends MDPoolConfigBean<S, T>>
extends MDPoolBean<S, T>
implements ComponentStatisticsProvider {
    private final Class<S> repoClazz;
    private S def;
    private S defProxy;
    private ConcurrentHashMap<String, StatisticsInvocationHandler<S>> handlers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, S> repos = new ConcurrentHashMap();
    private ConcurrentHashMap<String, S> reposProxy = new ConcurrentHashMap();
    @ConfigField(desc="Enable statistics", alias="statistics")
    private boolean statisticsEnabled = true;

    public MDPoolBeanWithStatistics(Class<S> repoClazz) {
        this.repoClazz = repoClazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepo(String name, S repo) {
        MDPoolBeanWithStatistics mDPoolBeanWithStatistics = this;
        synchronized (mDPoolBeanWithStatistics) {
            if (this.statisticsEnabled) {
                this.wrapInProxy(name, repo);
            }
            this.repos.put(name, repo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S removeRepo(String domain) {
        MDPoolBeanWithStatistics mDPoolBeanWithStatistics = this;
        synchronized (mDPoolBeanWithStatistics) {
            Repository repo = (Repository)this.repos.remove(domain);
            if (this.statisticsEnabled) {
                this.reposProxy.remove(domain);
            }
            return (S)repo;
        }
    }

    public Collection<String> getDomainsList() {
        return Collections.unmodifiableCollection(this.repos.keySet());
    }

    public S getDefaultRepository() {
        return this.statisticsEnabled ? this.defProxy : this.def;
    }

    public Stream<S> repositoriesStream() {
        if (this.statisticsEnabled) {
            return this.reposProxy.values().stream();
        }
        return this.repos.values().stream();
    }

    @Override
    public void everyHour() {
        if (this.statisticsEnabled) {
            this.handlers.values().forEach(StatisticsInvocationHandler::everyHour);
        }
    }

    @Override
    public void everyMinute() {
        if (this.statisticsEnabled) {
            this.handlers.values().forEach(StatisticsInvocationHandler::everyMinute);
        }
    }

    @Override
    public void everySecond() {
        if (this.statisticsEnabled) {
            this.handlers.values().forEach(StatisticsInvocationHandler::everySecond);
        }
    }

    @Override
    public void setDefault(S repo) {
        this.def = repo;
        this.defProxy = (Repository)this.reposProxy.get("default");
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        this.handlers.values().forEach(handler -> handler.getStatistics(compName, null, list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatisticsEnabled(boolean value) {
        if (this.statisticsEnabled != value) {
            MDPoolBeanWithStatistics mDPoolBeanWithStatistics = this;
            synchronized (mDPoolBeanWithStatistics) {
                if (value) {
                    this.repos.forEach(this::wrapInProxy);
                }
                this.statisticsEnabled = value;
                if (!value) {
                    this.reposProxy.clear();
                    this.defProxy = null;
                }
            }
        }
    }

    public S getRepo(String domain) {
        if (this.statisticsEnabled) {
            if (domain == null) {
                return this.defProxy;
            }
            Repository result = (Repository)this.reposProxy.get(domain);
            if (result == null) {
                result = this.defProxy;
            }
            return (S)result;
        }
        if (domain == null) {
            return this.def;
        }
        Repository result = (Repository)this.repos.get(domain);
        if (result == null) {
            result = this.def;
        }
        return (S)result;
    }

    public void wrapInProxy(String name, S repo) {
        StatisticsInvocationHandler<S> handler = new StatisticsInvocationHandler<S>(name, repo, this.repoClazz);
        Repository proxy = (Repository)Proxy.newProxyInstance(repo.getClass().getClassLoader(), new Class[]{this.repoClazz}, handler);
        this.handlers.put(name, handler);
        this.reposProxy.put(name, proxy);
    }
}

