/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaVersionCheckerLogger;
import tigase.sys.TigaseRuntime;
import tigase.util.Version;

public interface DataSource
extends Repository {
    public static final Logger log = Logger.getLogger(DataSource.class.getName());

    default public void checkConnectivity(Duration watchdogTime) {
    }

    default public boolean checkSchemaVersion(DataSourceAware<? extends DataSource> datasource, boolean shutdownServer) {
        boolean result = false;
        if (datasource == null) {
            return true;
        }
        Class<?> datasourceClass = datasource.getClass();
        if (datasourceClass.isAnnotationPresent(Repository.SchemaId.class) && RepositoryVersionAware.class.isAssignableFrom(datasourceClass)) {
            Version implementationVersion;
            String dataSourceID = datasourceClass.getAnnotation(Repository.SchemaId.class).id();
            if (!this.automaticSchemaManagement() && log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Automatic schema management is disabled for " + this.getResourceUri() + ", skipping version check for " + dataSourceID + "(" + datasourceClass.getSimpleName() + ")");
                return true;
            }
            Optional<Version> dbVer = this.getSchemaVersion(dataSourceID);
            try {
                RepositoryVersionAware repositoryVersionAware = (RepositoryVersionAware)datasourceClass.newInstance();
                implementationVersion = repositoryVersionAware.getVersion();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.log(Level.WARNING, "Error creating instance", e);
                implementationVersion = Version.of((String)datasourceClass.getPackage().getImplementationVersion());
            }
            implementationVersion = new Version.Builder(implementationVersion).setCommit(null).build();
            if (!dbVer.isPresent() || !implementationVersion.getBaseVersion().equals((Object)dbVer.get().getBaseVersion()) || !Version.TYPE.FINAL.equals((Object)dbVer.get().getVersionType()) && Version.TYPE.FINAL.equals((Object)implementationVersion.getVersionType())) {
                result = false;
                String[] errorMsg = new String[]{"ERROR! Component " + dataSourceID + " (" + datasourceClass.getSimpleName() + ") schema version is not loaded in the database or it is old!", (dbVer.isPresent() ? "Version in database: " + dbVer.get() + ". " : "") + "Required version: " + implementationVersion, "Please upgrade the installation by running:", "\t$ ./scripts/tigase.sh upgrade-schema etc/tigase.conf"};
                if (shutdownServer) {
                    TigaseRuntime.getTigaseRuntime().shutdownTigase(errorMsg);
                }
            } else if (implementationVersion.getBaseVersion().equals((Object)dbVer.get().getBaseVersion()) && !Version.TYPE.FINAL.equals((Object)implementationVersion.getVersionType())) {
                result = false;
                SchemaVersionCheckerLogger.VersionCheckerSchemaInfo versionInfo = new SchemaVersionCheckerLogger.VersionCheckerSchemaInfo(datasourceClass, dbVer, implementationVersion);
                SchemaVersionCheckerLogger.getInstance().logVersion(versionInfo);
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    default public boolean automaticSchemaManagement() {
        return true;
    }

    public Optional<Version> getSchemaVersion(String var1);

    public String getResourceUri();

    public void initialize(String var1) throws RepositoryException;
}

