/*
 * Decompiled with CFR 0.152.
 */
package tigase.component;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigWriter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.config.ConfigAlias;
import tigase.kernel.beans.config.ConfigAliases;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;

@Bean(name="defaultBeanConfigurator", active=true)
public class DSLBeanConfigurator
extends AbstractBeanConfigurator {
    private static final Logger log = Logger.getLogger(DSLBeanConfigurator.class.getCanonicalName());
    private ConfigHolder configHolder;
    private Map<String, Object> props;

    @Override
    public Map<String, Object> getConfiguration(BeanConfig beanConfig) {
        if (this.props == null) {
            return new HashMap<String, Object>();
        }
        Map<String, String> aliassesToFields = this.getFieldAliasses(beanConfig);
        return this.getBeanConfigurationProperties(beanConfig, aliassesToFields);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.props;
    }

    public void setProperties(Map<String, Object> props) {
        this.props = props;
    }

    public ConfigHolder getConfigHolder() {
        return this.configHolder;
    }

    public void setConfigHolder(ConfigHolder config) {
        this.configHolder = config;
        this.setProperties(config.getProperties());
    }

    public void dumpConfiguration(File f) throws IOException {
        log.log(Level.WARNING, "Dumping full server configuration to: {0}", f);
        LinkedHashMap<String, Object> dump = new LinkedHashMap<String, Object>(this.props);
        this.dumpConfiguration(dump, this.kernel);
        new ConfigWriter().resolveVariables().write(f, dump);
    }

    public void dumpConfiguration(Writer writer) throws IOException {
        LinkedHashMap<String, Object> dump = new LinkedHashMap<String, Object>(this.props);
        this.dumpConfiguration(dump, this.kernel);
        new ConfigWriter().resolveVariables().write(writer, dump);
    }

    @Override
    protected boolean hasDirectConfiguration(BeanConfig beanConfig) {
        String name;
        ArrayDeque<String> kernels = this.getBeanConfigPath(beanConfig);
        Map result = this.props;
        while (result != null && (name = kernels.poll()) != null) {
            Object r = result.get(name);
            if (r instanceof Map) {
                result = (Map)r;
                continue;
            }
            result = null;
        }
        return result != null;
    }

    protected Map<String, Object> getBeanConfigurationProperties(BeanConfig beanConfig, Map<String, String> aliasesToFields) {
        String name;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayDeque<String> path = this.getBeanConfigPath(beanConfig);
        ArrayDeque<Map> configPath = new ArrayDeque<Map>();
        Map props = this.props;
        configPath.add(props);
        while ((name = path.poll()) != null) {
            if ((props = (Map)props.get(name)) == null) {
                configPath.offer(Collections.emptyMap());
                break;
            }
            configPath.offer(props);
        }
        while ((props = (Map)configPath.poll()) != null) {
            for (Map.Entry e : props.entrySet()) {
                String fieldName;
                if (configPath.isEmpty()) {
                    fieldName = aliasesToFields.get(e.getKey());
                    if (fieldName != null) {
                        result.put(fieldName, e.getValue());
                        continue;
                    }
                    result.put((String)e.getKey(), e.getValue());
                    continue;
                }
                fieldName = aliasesToFields.get(e.getKey());
                if (fieldName == null) continue;
                result.put(fieldName, e.getValue());
            }
        }
        result.put("name", beanConfig.getBeanName());
        return result;
    }

    protected Map<String, String> getFieldAliasses(BeanConfig beanConfig) {
        ConfigAliases ca;
        Field[] fields;
        HashMap<String, String> configAliasses = new HashMap<String, String>();
        Class<?> cls = beanConfig.getClazz();
        for (Field field : fields = DependencyManager.getAllFields(cls)) {
            ConfigField cf = field.getAnnotation(ConfigField.class);
            if (cf == null || cf.alias().isEmpty()) continue;
            configAliasses.put(cf.alias(), field.getName());
        }
        while ((ca = cls.getAnnotation(ConfigAliases.class)) != null) {
            for (ConfigAlias a : ca.value()) {
                configAliasses.put(a.alias(), a.field());
            }
            if ((cls = cls.getSuperclass()) != null) continue;
        }
        return configAliasses;
    }

    @Override
    protected Map<String, AbstractBeanConfigurator.BeanDefinition> getBeanDefinitions(Map<String, Object> values) {
        Map<String, AbstractBeanConfigurator.BeanDefinition> beanDefinitions = super.getBeanDefinitions(values);
        for (Map.Entry<String, Object> e : values.entrySet()) {
            if (!(e.getValue() instanceof AbstractBeanConfigurator.BeanDefinition)) continue;
            beanDefinitions.put(e.getKey(), (AbstractBeanConfigurator.BeanDefinition)e.getValue());
        }
        return beanDefinitions;
    }

    private void dumpConfiguration(Map<String, Object> dump, Kernel kernel) {
        List beansToDump = kernel.getDependencyManager().getBeanConfigs().stream().filter(bc -> !Kernel.class.isAssignableFrom(bc.getClazz()) && !(bc instanceof Kernel.DelegatedBeanConfig)).collect(Collectors.toList());
        for (BeanConfig bc2 : beansToDump) {
            AbstractBeanConfigurator.BeanDefinition forBean = this.getBeanDefinitionFromDump(dump, bc2.getBeanName());
            if (forBean.getClazzName() == null) {
                forBean.setClazzName(bc2.getClazz().getName());
            }
            forBean.setActive(bc2.getState() != BeanConfig.State.inactive);
            forBean.setExportable(bc2.isExportable());
            try {
                if (forBean.isActive()) {
                    Kernel subkernel;
                    if (RegistrarBean.class.isAssignableFrom(bc2.getClazz()) && (subkernel = bc2.getKernel()) != kernel) {
                        this.dumpConfiguration(forBean, subkernel);
                    }
                    Object bean = bc2.getKernel().getInstanceIfExistsOr(bc2.getBeanName(), bc1 -> {
                        try {
                            return bc1.getClazz().newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            log.log(Level.FINEST, "failed to instantiate class for retrieval of default configuration");
                            return null;
                        }
                    });
                    Map<Field, Object> defaults = this.grabCurrentConfig(bean, bc2.getBeanName());
                    Map<String, Object> cfg = bc2.getState() != BeanConfig.State.initialized ? this.getConfiguration(bc2) : null;
                    HashSet validProps = new HashSet();
                    if (defaults != null) {
                        defaults.forEach((field, v) -> {
                            ConfigField cf = field.getAnnotation(ConfigField.class);
                            Object v1 = null;
                            if (cfg != null && (v1 = cfg.get(field.getName())) == null && cf != null && !cf.alias().isEmpty()) {
                                v1 = cfg.get(cf.alias());
                            }
                            String prop = cf == null || cf.alias().isEmpty() ? field.getName() : cf.alias();
                            forBean.put(prop, v1 == null ? v : v1);
                            validProps.add(prop);
                        });
                    }
                    new ArrayList(forBean.entrySet()).stream().filter(e -> !validProps.contains(e.getKey())).filter(e -> !(e.getValue() instanceof AbstractBeanConfigurator.BeanDefinition)).map(e -> e.getKey()).forEach(forBean::remove);
                    forBean.remove("name");
                    continue;
                }
                this.dumpConfigFromSubBeans(forBean, kernel);
            }
            catch (Exception ex) {
                log.log(Level.FINEST, "failed to retrieve default values for bean " + bc2.getBeanName() + ", class = " + bc2.getClazz(), ex);
            }
        }
    }

    private void dumpConfigFromSubBeans(AbstractBeanConfigurator.BeanDefinition beanDef, Kernel kernel) {
        try {
            Object bean = ModulesManagerImpl.getInstance().forName(beanDef.getClazzName()).newInstance();
            HashMap cfg = new HashMap(beanDef);
            Map<Field, Object> defaults = this.grabCurrentConfig(bean, beanDef.getBeanName());
            if (defaults != null) {
                HashSet validProps = new HashSet();
                defaults.forEach((field, v) -> {
                    ConfigField cf = field.getAnnotation(ConfigField.class);
                    Object v1 = beanDef.remove(field.getName());
                    if (v1 == null) {
                        v1 = beanDef.remove(cf.alias());
                    }
                    String prop = cf == null || cf.alias().isEmpty() ? field.getName() : cf.alias();
                    beanDef.put(prop, v1 == null ? v : v1);
                    validProps.add(prop);
                });
                new ArrayList(beanDef.entrySet()).stream().filter(e -> !validProps.contains(e.getKey())).filter(e -> !(e.getValue() instanceof AbstractBeanConfigurator.BeanDefinition)).map(e -> e.getKey()).forEach(beanDef::remove);
            }
            beanDef.remove("name");
            if (RegistrarBean.class.isAssignableFrom(bean.getClass())) {
                Kernel tmpKernel = new Kernel("DLSConfiguratorTmpKernel"){

                    @Override
                    public void registerLinks(String beanName) {
                    }

                    @Override
                    public <T> T getInstance(String beanName) {
                        return null;
                    }

                    @Override
                    protected <T> T getInstance(Class<T> beanClass, boolean allowNonExportable) {
                        if (AbstractBeanConfigurator.class.isAssignableFrom(beanClass)) {
                            return (T)DSLBeanConfigurator.this;
                        }
                        return null;
                    }

                    @Override
                    protected void injectIfRequired(BeanConfig beanConfig) {
                    }
                };
                tmpKernel.registerBean("defaultBeanConfigurator").asInstance(this).exportable().exec();
                if (bean instanceof RegistrarBean) {
                    ((RegistrarBean)bean).register(tmpKernel);
                }
                HashMap subbeans = new HashMap();
                tmpKernel.getDependencyManager().getBeanConfigs().stream().filter(bc -> !Kernel.class.isAssignableFrom(bc.getClazz())).forEach(bc -> subbeans.put(bc.getBeanName(), bc.getClazz()));
                subbeans.putAll(DSLBeanConfigurator.getBeanClassesFromAnnotations(kernel, bean.getClass()));
                Map<String, AbstractBeanConfigurator.BeanDefinition> beansFromConfig = DSLBeanConfigurator.mergeWithBeansPropertyValue(this.getBeanDefinitions(beanDef), beanDef);
                subbeans.entrySet().stream().filter(e -> !beansFromConfig.containsKey(e.getKey())).map(e -> {
                    AbstractBeanConfigurator.BeanDefinition def = new AbstractBeanConfigurator.BeanDefinition();
                    def.setBeanName((String)e.getKey());
                    def.setClazzName(((Class)e.getValue()).getName());
                    Bean b = ((Class)e.getValue()).getAnnotation(Bean.class);
                    if (b != null) {
                        def.setActive(b.active());
                    }
                    Object tmp = beanDef.get(def.getBeanName());
                    cfg.entrySet().stream().filter(x -> !(x.getValue() instanceof AbstractBeanConfigurator.BeanDefinition)).forEach(x -> def.put(x.getKey(), x.getValue()));
                    if (tmp != null && tmp instanceof Map) {
                        def.putAll((Map)tmp);
                    }
                    beanDef.put(def.getBeanName(), def);
                    return def;
                }).forEach(def -> this.dumpConfigFromSubBeans((AbstractBeanConfigurator.BeanDefinition)def, kernel));
                beansFromConfig.values().stream().map(def -> {
                    Class x;
                    if (def.getClazzName() == null && (x = (Class)subbeans.get(def.getBeanName())) != null) {
                        def.setClazzName(x.getName());
                    }
                    return def;
                }).forEach(def -> this.dumpConfigFromSubBeans((AbstractBeanConfigurator.BeanDefinition)def, kernel));
            }
        }
        catch (Exception ex) {
            log.log(Level.FINEST, "exception retrieving configuration of subbeans = " + beanDef.getBeanName(), ex);
        }
    }

    private AbstractBeanConfigurator.BeanDefinition getBeanDefinitionFromDump(Map<String, Object> dump, String name) {
        Object tmp = dump.get(name);
        if (tmp == null || !(tmp instanceof AbstractBeanConfigurator.BeanDefinition)) {
            AbstractBeanConfigurator.BeanDefinition def = new AbstractBeanConfigurator.BeanDefinition();
            def.setBeanName(name);
            dump.entrySet().stream().filter(e -> !(e.getValue() instanceof AbstractBeanConfigurator.BeanDefinition)).forEach(e -> def.putIfAbsent(e.getKey(), e.getValue()));
            if (tmp != null && tmp instanceof Map) {
                def.putAll((Map)tmp);
            }
            dump.put(name, def);
            tmp = def;
        } else {
            AbstractBeanConfigurator.BeanDefinition def = new AbstractBeanConfigurator.BeanDefinition((AbstractBeanConfigurator.BeanDefinition)tmp);
            dump.entrySet().stream().filter(e -> !(e.getValue() instanceof AbstractBeanConfigurator.BeanDefinition)).forEach(e -> def.putIfAbsent(e.getKey(), e.getValue()));
            dump.put(name, def);
            tmp = def;
        }
        return (AbstractBeanConfigurator.BeanDefinition)tmp;
    }
}

