/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="disco", parent=SessionManager.class, active=true)
public class ServiceDiscovery
extends XMPPProcessorAbstract {
    protected static final String ID = "disco";
    private static final Logger log = Logger.getLogger(ServiceDiscovery.class.getName());
    private static final String[][] ELEMENTS = new String[][]{Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH, Iq.IQ_QUERY_PATH};
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/commands"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#info"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/disco#items"})};
    @Inject(nullAllowed=true)
    private AccountServiceProvider serviceProvider;
    @Inject(nullAllowed=true)
    private SessionManager sessionManager;
    @Inject
    private VHostManagerIfc vhostManager;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        JID to = packet.getStanzaTo();
        if (to != null) {
            JID from = packet.getStanzaFrom();
            if (from == null) {
                if (session == null || !session.isAuthorized()) {
                    log.log(Level.FINEST, "got <iq/> packet with no ''from'' attribute = {0}", packet);
                    return;
                }
                from = session.getjid();
            }
            if (packet.getType() == StanzaType.get && to.getLocalpart() != null && to.getResource() == null && this.sessionManager.isLocalDomain(to.getDomain())) {
                Element query = packet.getElement().findChild(el -> el.getName() == "query" && el.getXMLNS() == "http://jabber.org/protocol/disco#info");
                if (!this.isLocalComponent(to)) {
                    if (this.serviceProvider != null) {
                        if (query != null && query.getAttributeStaticStr("node") == null) {
                            Packet result = packet.copyElementOnly();
                            result.setPacketTo(this.serviceProvider.getServiceProviderComponentJid());
                            result.setPacketFrom(this.sessionManager.getComponentId());
                            results.offer(result);
                        } else {
                            Packet result = packet.copyElementOnly();
                            if (packet.getStanzaTo() == null && session != null) {
                                JID userJid = JID.jidInstance((BareJID)session.getBareJID());
                                result.initVars(packet.getStanzaFrom() != null ? packet.getStanzaFrom() : session.getJID(), userJid);
                            }
                            if (packet.getStanzaFrom() == null) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.log(Level.FINEST, "received <iq/> packet to forward to service provider component without ''from'' attribute, dropping packet = {0}", packet);
                                }
                                return;
                            }
                            result.setPacketFrom(packet.getFrom());
                            result.setPacketTo(this.serviceProvider.getServiceProviderComponentJid());
                            results.offer(result);
                        }
                    } else if (query != null && query.getAttributeStaticStr("node") == null) {
                        query = new Element("query");
                        query.setXMLNS("http://jabber.org/protocol/disco#info");
                        Packet result = packet.okResult(query, 0);
                        this.addAccountFeatures(result, from.getBareJID().equals((Object)to.getBareJID()));
                        results.offer(result);
                    } else {
                        super.process(packet, session, repo, results, settings);
                    }
                } else {
                    super.process(packet, session, repo, results, settings);
                }
            } else if ((packet.getType() == StanzaType.result || packet.getType() == StanzaType.error) && from.getLocalpart() != null && from.getResource() == null && this.sessionManager.isLocalDomain(from.getDomain())) {
                if (this.serviceProvider != null && packet.getPacketFrom() != null && packet.getPacketFrom().equals((Object)this.serviceProvider.getServiceProviderComponentJid())) {
                    if (session != null && session.isUserId(to.getBareJID())) {
                        Packet result = packet.copyElementOnly();
                        result.setPacketFrom(packet.getFrom());
                        result.setPacketTo(session.getConnectionId());
                        this.addAccountFeatures(result, from.getBareJID().equals((Object)to.getBareJID()));
                        results.offer(result);
                    } else {
                        if (this.sessionManager.isLocalDomain(to.getDomain())) {
                            return;
                        }
                        Packet result = packet.copyElementOnly();
                        result.setPacketFrom(packet.getFrom());
                        result.setPacketTo(null);
                        this.addAccountFeatures(result, false);
                        results.offer(result);
                    }
                } else {
                    super.process(packet, session, repo, results, settings);
                }
            } else {
                super.process(packet, session, repo, results, settings);
            }
        } else {
            super.process(packet, session, repo, results, settings);
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getStanzaTo() != null) {
            log.log(Level.FINEST, "forwarding packet to MR" + packet.toString());
            results.offer(packet.copyElementOnly());
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        results.offer(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The target is unavailable at this time.", true));
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private boolean isLocalComponent(JID jid) {
        return this.vhostManager.isLocalDomainOrComponent(jid.getLocalpart() + "." + jid.getDomain());
    }

    private void addAccountFeatures(Packet result, boolean isOwner) {
        if (result.getType() != StanzaType.result) {
            return;
        }
        Element query = result.getElement().getChild("query");
        if (query != null && isOwner) {
            List features = query.getChildren();
            query.setChildren(Collections.emptyList());
            query.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"account", "registered"}));
            if (features != null) {
                features.forEach(arg_0 -> ((Element)query).addChild(arg_0));
            }
            this.sessionManager.getDiscoFeatures(result.getStanzaFrom()).forEach(arg_0 -> ((Element)query).addChild(arg_0));
        }
    }

    public static interface AccountServiceProvider {
        public JID getServiceProviderComponentJid();
    }
}

