/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.db.TigaseDBException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqPrivacy;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PrivacyList {
    public static final PrivacyList ALLOW_ALL = new PrivacyList(null, new Element("list"));
    private static final Logger log = Logger.getLogger(PrivacyList.class.getCanonicalName());
    private static final Set<Item.Type> ALL_TYPES = EnumSet.allOf(Item.Type.class);
    private static final PrivacyList DENY_ALL = new PrivacyList(null, new Element("list")){

        @Override
        public boolean isAllowed(JID jid, Item.Type type) {
            return false;
        }
    };
    private final Item[] items;
    private final String name;
    private final Function<JID, RosterElement> rosterElementGetter;

    public static PrivacyList create(Map<BareJID, RosterElement> roster, Element el) {
        if (el == null) {
            return null;
        }
        return new PrivacyList(jid -> {
            if (jid == null) {
                return null;
            }
            return (RosterElement)roster.get(jid.getBareJID());
        }, el).getSingletonIfPossible();
    }

    public static PrivacyList create(XMPPResourceConnection session, RosterAbstract rosterUtil, Element el) throws NotAuthorizedException, TigaseDBException {
        if (el == null) {
            return null;
        }
        return new PrivacyList(rosterUtil.rosterElementProvider(session), el).getSingletonIfPossible();
    }

    public PrivacyList(Function<JID, RosterElement> rosterElementGetter, Element el) {
        this.rosterElementGetter = rosterElementGetter;
        this.name = el.getAttributeStaticStr("name");
        this.items = (Item[])Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().sorted(JabberIqPrivacy.compar).map(this::elemToItem).filter(it -> it != null).toArray(Item[]::new);
    }

    public String getName() {
        return this.name;
    }

    public Stream<JID> getBlockedJids() {
        return Arrays.stream(this.items).filter(x -> x instanceof ItemJid).filter(x -> !x.isAllowed()).map(x -> ((ItemJid)x).jid);
    }

    public boolean isAllowed(JID jid, Item.Type type) {
        for (Item item : this.items) {
            if (!item.matches(jid, type)) continue;
            return item.isAllowed();
        }
        return true;
    }

    public boolean isEmpty() {
        return this.items.length == 0;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "PrivacyList[name=" + this.name + ", size: " + this.items.length + ", items: ", "]");
        for (int i = 0; i < this.items.length; ++i) {
            Item item = this.items[i];
            joiner.add(item.toString());
            if (i + 1 < 10) continue;
            joiner.add("... " + (this.items.length - i - 1) + " more...");
            break;
        }
        return joiner.toString();
    }

    private PrivacyList getSingletonIfPossible() {
        if (this.isEmpty()) {
            return ALLOW_ALL;
        }
        if (this.items.length == 1 && this.items[0] instanceof ItemAll) {
            return this.items[0].isAllowed() ? ALLOW_ALL : DENY_ALL;
        }
        return this;
    }

    private Item elemToItem(Element el) {
        boolean allow;
        String type = el.getAttributeStaticStr("type");
        String value = el.getAttributeStaticStr("value");
        String action = el.getAttributeStaticStr("action");
        if (action == null) {
            return null;
        }
        switch (action) {
            case "allow": {
                allow = true;
                break;
            }
            case "deny": {
                allow = false;
                break;
            }
            default: {
                return null;
            }
        }
        if (type == null) {
            return new ItemAll(allow);
        }
        Set<Item.Type> types = ALL_TYPES;
        List children = el.getChildren();
        if (children != null && !children.isEmpty() && (types = children.stream().map(child -> {
            switch (child.getName()) {
                case "message": {
                    return Item.Type.message;
                }
                case "iq": {
                    return Item.Type.iq;
                }
                case "presence-in": {
                    return Item.Type.presenceIn;
                }
                case "presence-out": {
                    return Item.Type.presenceOut;
                }
            }
            return null;
        }).filter(val -> val != null).collect(Collectors.toSet())).isEmpty()) {
            types = ALL_TYPES;
        }
        switch (type) {
            case "jid": {
                try {
                    JID jid = JID.jidInstance((String)value);
                    return new ItemJid(jid, allow, types);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.FINEST, "Exception while creating jid instance for value: " + value, ex);
                    return null;
                }
            }
            case "group": {
                return new ItemGroup(value, allow, types);
            }
            case "subscription": {
                try {
                    return new ItemSubscription(RosterAbstract.SubscriptionType.valueOf(value), allow, types);
                }
                catch (IllegalArgumentException ex) {
                    log.log(Level.FINEST, "Exception while parsing subscription value: " + value, ex);
                    return null;
                }
            }
        }
        return null;
    }

    private class ItemSubscription
    extends AbstractItem {
        private final RosterAbstract.SubscriptionType subscription;

        public ItemSubscription(RosterAbstract.SubscriptionType subscription, boolean allowed, Set<Item.Type> types) {
            super(allowed, types);
            this.subscription = subscription;
        }

        @Override
        public boolean matches(JID jid, Item.Type type) {
            if (!this.types.contains((Object)type)) {
                return false;
            }
            RosterAbstract.SubscriptionType subscription = this.getSubscriptionForJID(jid);
            switch (this.subscription) {
                case none: {
                    return subscription == null || !RosterAbstract.TO_SUBSCRIBED.contains((Object)subscription) && !RosterAbstract.FROM_SUBSCRIBED.contains((Object)subscription);
                }
                case to: {
                    return RosterAbstract.TO_SUBSCRIBED.contains((Object)subscription);
                }
                case from: {
                    return RosterAbstract.FROM_SUBSCRIBED.contains((Object)subscription);
                }
                case both: {
                    return RosterAbstract.TO_SUBSCRIBED.contains((Object)subscription) && RosterAbstract.FROM_SUBSCRIBED.contains((Object)subscription);
                }
            }
            return false;
        }

        public String toString() {
            return "Subscription: " + (Object)((Object)this.subscription) + ": " + (this.allowed ? "allowed" : "blocked");
        }
    }

    private class ItemJid
    extends AbstractItem {
        private final JID jid;

        public ItemJid(JID jid, boolean allowed, Set<Item.Type> types) {
            super(allowed, types);
            this.jid = jid;
        }

        @Override
        public boolean matches(JID jid, Item.Type type) {
            return this.matches(jid) && this.types.contains((Object)type);
        }

        public String toString() {
            return "JID: " + this.jid + ": " + (this.allowed ? "allowed" : "blocked");
        }

        private boolean matches(JID jid) {
            if (this.jid.getLocalpart() != null) {
                if (this.jid.getResource() != null) {
                    return jid.equals((Object)this.jid);
                }
                if (this.jid.getResource() == null) {
                    return jid.getBareJID().equals((Object)this.jid.getBareJID());
                }
            } else {
                if (this.jid.getResource() != null) {
                    return jid.equals((Object)this.jid);
                }
                if (this.jid.getResource() == null) {
                    return jid.getDomain().equals(this.jid.getDomain());
                }
            }
            return false;
        }
    }

    private class ItemGroup
    extends AbstractItem {
        private final String group;

        public ItemGroup(String group, boolean allowed, Set<Item.Type> types) {
            super(allowed, types);
            this.group = group;
        }

        @Override
        public boolean matches(JID jid, Item.Type type) {
            if (!this.types.contains((Object)type)) {
                return false;
            }
            String[] groups = this.getRosterGroupsForJid(jid);
            if (groups != null) {
                for (String group : groups) {
                    if (!group.equals(this.group)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "Group: " + this.group + ": " + (this.allowed ? "allowed" : "blocked");
        }
    }

    private class ItemAll
    implements Item {
        private final boolean allowed;

        public ItemAll(boolean allowed) {
            this.allowed = allowed;
        }

        @Override
        public boolean isAllowed() {
            return this.allowed;
        }

        @Override
        public boolean matches(JID jid, Item.Type type) {
            return true;
        }

        public String toString() {
            return "All items: " + (this.allowed ? "allowed" : "blocked");
        }
    }

    private abstract class AbstractItem
    implements Item {
        protected final boolean allowed;
        protected final Set<Item.Type> types;

        protected AbstractItem(boolean allowed, Set<Item.Type> types) {
            this.allowed = allowed;
            this.types = types;
        }

        @Override
        public boolean isAllowed() {
            return this.allowed;
        }

        protected String[] getRosterGroupsForJid(JID jid) {
            RosterElement item = (RosterElement)PrivacyList.this.rosterElementGetter.apply(jid);
            return item == null ? null : item.getGroups();
        }

        protected RosterAbstract.SubscriptionType getSubscriptionForJID(JID jid) {
            RosterElement item = (RosterElement)PrivacyList.this.rosterElementGetter.apply(jid);
            return item == null ? null : item.getSubscription();
        }
    }

    public static interface Item {
        public boolean isAllowed();

        public boolean matches(JID var1, Type var2);

        public static enum Type {
            message,
            iq,
            presenceIn,
            presenceOut;

        }
    }
}

