/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts.filter;

import java.util.Objects;
import tigase.xmpp.jid.JID;

public class Rule
implements Comparable<Rule> {
    boolean allow;
    int id;
    RuleType type;
    JID value;

    public Rule(int id, boolean allow, RuleType type, JID value) {
        this.id = id;
        this.allow = allow;
        this.type = type;
        this.value = value;
    }

    @Override
    public int compareTo(Rule o) {
        return this.id > o.getId() ? 1 : (this.id < o.getId() ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.allow != other.allow) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public boolean isAllowed() {
        return this.allow;
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + this.id;
        hash = 11 * hash + (this.allow ? 1 : 0);
        hash = 11 * hash + Objects.hashCode((Object)this.type);
        if (this.value != null) {
            hash = 11 * hash + this.value.toString().hashCode();
        }
        return hash;
    }

    public String toString() {
        return "Rule{id=" + this.id + ", allow=" + this.allow + ", type=" + (Object)((Object)this.type) + ", value=" + this.value + '}';
    }

    public String toConfigurationString() {
        return this.id + "|" + (this.allow ? "allow" : "deny") + "|" + (Object)((Object)this.type) + (this.type == RuleType.domain || this.type == RuleType.jid ? "|" + this.value : "") + ";";
    }

    boolean isMatched(JID source, JID destination) {
        boolean result = false;
        switch (this.type) {
            case all: {
                result = true;
                break;
            }
            case self: {
                if (source != null && destination != null) {
                    result = source.getBareJID().equals((Object)destination.getBareJID());
                    break;
                }
                if (source != null) break;
                result = true;
                break;
            }
            case domain: {
                if (this.value != null && destination != null) {
                    result = this.value.getDomain().equals(destination.getDomain());
                }
                if (this.value == null || destination == null) break;
                result |= this.value.getDomain().equals(source.getDomain());
                break;
            }
            case jid: {
                if (this.value != null && destination != null) {
                    result = this.value.getBareJID().equals((Object)destination.getBareJID());
                }
                if (this.value == null || destination == null) break;
                result |= this.value.getBareJID().equals((Object)source.getBareJID());
            }
        }
        return result;
    }

    protected int getId() {
        return this.id;
    }

    public static enum RuleType {
        jid,
        self,
        domain,
        all;

    }
}

