/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.net.IOService;
import tigase.net.IOServiceListener;
import tigase.net.SocketThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:sm:3", parent=ClientConnectionManager.class, active=true)
public class StreamManagementIOProcessor
implements XMPPIOProcessor {
    public static final String XMLNS = "urn:xmpp:sm:3";
    private static final Logger log = Logger.getLogger(StreamManagementIOProcessor.class.getCanonicalName());
    private static final String ACK_NAME = "a";
    private static final String ENABLE_NAME = "enable";
    private static final String ENABLED_NAME = "enabled";
    private static final String REQ_NAME = "r";
    private static final String RESUME_NAME = "resume";
    private static final String RESUMED_NAME = "resumed";
    private static final String H_ATTR = "h";
    private static final String LOCATION_ATTR = "location";
    private static final String RESUME_ATTR = "resume";
    private static final String MAX_ATTR = "max";
    private static final String PREVID_ATTR = "previd";
    private static final String ACK_REQUEST_COUNT_KEY = "ack-request-count";
    private static final int DEF_ACK_REQUEST_COUNT_VAL = 10;
    private static final String[] DELAY_PATH = new String[]{"message", "delay"};
    private static final String DELAY_XMLNS = "urn:xmpp:delay";
    private static final String IGNORE_UNDELIVERED_PRESENCE_KEY = "ignore-undelivered-presence";
    private static final String IN_COUNTER_KEY = "urn:xmpp:sm:3_in";
    private static final String MAX_RESUMPTION_TIMEOUT_KEY = "urn:xmpp:sm:3_resumption-timeout";
    private static final String MAX_RESUMPTION_TIMEOUT_PROP_KEY = "max-resumption-timeout";
    private static final String OUT_COUNTER_KEY = "urn:xmpp:sm:3_out";
    private static final String RESUMPTION_TASK_KEY = "urn:xmpp:sm:3_resumption-task";
    private static final String RESUMPTION_TIMEOUT_PROP_KEY = "resumption-timeout";
    private static final String RESUMPTION_TIMEOUT_START_KEY = "resumption-timeout-start";
    private static final String STREAM_ID_KEY = "urn:xmpp:sm:3_stream_id";
    private static final Element[] FEATURES = new Element[]{new Element("sm", new String[]{"xmlns"}, new String[]{"urn:xmpp:sm:3"})};
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final ConcurrentHashMap<String, XMPPIOService> services = new ConcurrentHashMap();
    @ConfigField(desc="Number of sent packets after should ask for confirmation of delivery", alias="ack-request-count")
    private int ack_request_count = 10;
    @Inject(bean="service")
    private ConnectionManager connectionManager;
    @ConfigField(desc="Ignore undelivered presence packets", alias="ignore-undelivered-presence")
    private boolean ignoreUndeliveredPresence = true;
    @ConfigField(desc="Maximal allowed time for session resumption", alias="max-resumption-timeout")
    private int max_resumption_timeout = 900;
    @ConfigField(desc="Default resumption timeout", alias="resumption-timeout")
    private int resumption_timeout = 60;

    public static boolean isEnabled(XMPPIOService service) {
        return service.getSessionData().containsKey(IN_COUNTER_KEY);
    }

    private static boolean isResumptionEnabled(XMPPIOService service) {
        return service.getSessionData().containsKey(STREAM_ID_KEY);
    }

    @Override
    public String getId() {
        return XMLNS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPIOService service) {
        return FEATURES;
    }

    @Override
    public boolean processIncoming(XMPPIOService service, Packet packet) {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            if (packet.getXMLNS() != XMLNS) {
                return false;
            }
            if (packet.getElemName() == ENABLE_NAME) {
                OutQueue outQueue = this.newOutQueue();
                service.getSessionData().putIfAbsent(OUT_COUNTER_KEY, outQueue);
                service.getSessionData().putIfAbsent(IN_COUNTER_KEY, this.newCounter());
                String id = null;
                String location = null;
                int timeout = this.resumption_timeout;
                if (this.resumption_timeout > 0 && packet.getElement().getAttributeStaticStr("resume") != null) {
                    outQueue.setResumptionEnabled(true);
                    String maxStr = packet.getElement().getAttributeStaticStr(MAX_ATTR);
                    if (maxStr != null) {
                        timeout = Math.min(this.max_resumption_timeout, Integer.parseInt(maxStr));
                    }
                    id = UUID.randomUUID().toString();
                    location = DNSResolverFactory.getInstance().getSecondaryHost();
                    service.getSessionData().putIfAbsent(STREAM_ID_KEY, id);
                    service.getSessionData().put(MAX_RESUMPTION_TIMEOUT_KEY, timeout);
                    this.services.put(id, service);
                }
                try {
                    service.writeRawData("<enabled xmlns='urn:xmpp:sm:3'" + (id != null ? " id='" + id + "' " + "resume" + "='true' " + MAX_ATTR + "='" + timeout + "'" : "") + (location != null ? " location='" + location + "'" : "") + " />");
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0}, started StreamManagement with resumption timeout set to = {1}", new Object[]{service.toString(), id != null ? Integer.valueOf(this.resumption_timeout) : null});
                    }
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, service.toString() + ", exception during sending <enabled/>, stopping...", ex);
                    }
                    service.forceStop();
                }
                return true;
            }
            if (packet.getElemName() == "resume") {
                String h = packet.getElement().getAttributeStaticStr(H_ATTR);
                String id = packet.getElement().getAttributeStaticStr(PREVID_ATTR);
                try {
                    this.resumeStream(service, id, Integer.parseInt(h));
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, service.toString() + ", exception while resuming stream for user " + service.getUserJid() + " with id " + id, ex);
                    }
                    service.forceStop();
                }
                return true;
            }
            return false;
        }
        if (packet.getXMLNS() == XMLNS) {
            block22: {
                if (packet.getElemName() == ACK_NAME) {
                    String valStr = packet.getAttributeStaticStr(H_ATTR);
                    int val = Integer.parseInt(valStr);
                    OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
                    if (outQueue != null) {
                        outQueue.ack(val);
                    } else if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0}, outQueue already null while processing: {1}", new Object[]{service, packet});
                    }
                } else if (packet.getElemName() == REQ_NAME) {
                    int value = ((Counter)service.getSessionData().get(IN_COUNTER_KEY)).get();
                    try {
                        service.writeRawData("<a xmlns='urn:xmpp:sm:3' h='" + String.valueOf(value) + "'/>");
                    }
                    catch (IOException ex) {
                        if (!log.isLoggable(Level.FINE)) break block22;
                        log.log(Level.FINE, service.toString() + ", exception during sending <a/> as response for <r/>, not stopping serivce as it will be stopped after processing all incoming data...", ex);
                    }
                }
            }
            return true;
        }
        ((Counter)service.getSessionData().get(IN_COUNTER_KEY)).inc();
        return false;
    }

    @Override
    public boolean processOutgoing(XMPPIOService service, Packet packet) {
        if (!StreamManagementIOProcessor.isEnabled(service) || packet.getXMLNS() == XMLNS) {
            return false;
        }
        OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
        if (outQueue == null) {
            OutQueue.Entry e = new OutQueue.Entry(packet);
            this.connectionManager.processUndeliveredPacket(e.getPacketWithStamp(), e.stamp, null);
        } else {
            outQueue.append(packet);
        }
        return service.getSessionData().containsKey(RESUMPTION_TASK_KEY);
    }

    @Override
    public void packetsSent(XMPPIOService service) throws IOException {
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            return;
        }
        OutQueue outQueue = (OutQueue)service.getSessionData().get(OUT_COUNTER_KEY);
        if (outQueue != null && this.shouldRequestAck(service, outQueue)) {
            service.writeRawData("<r xmlns='urn:xmpp:sm:3' />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCommand(XMPPIOService service, Packet pc) {
        String cmdId = Command.getFieldValue(pc, "cmd");
        if ("stream-moved".equals(cmdId)) {
            block18: {
                String newConn = Command.getFieldValue(pc, "new-conn-jid");
                String id = (String)service.getSessionData().get(STREAM_ID_KEY);
                JID newConnJid = JID.jidInstanceNS((String)newConn);
                Object newService = this.connectionManager.getXMPPIOService(newConnJid.getResource());
                if (newService != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "stream for user {2} moved from {0} to {1}", new Object[]{service.getConnectionId(), ((IOService)newService).getConnectionId(), ((XMPPIOService)newService).getUserJid()});
                    }
                    try {
                        ((XMPPIOService)newService).setUserJid(service.getUserJid());
                        Counter inCounter = (Counter)((IOService)newService).getSessionData().get(IN_COUNTER_KEY);
                        ((XMPPIOService)newService).writeRawData("<resumed xmlns='urn:xmpp:sm:3' previd='" + id + "' " + H_ATTR + "='" + inCounter.get() + "' />");
                        service.getSessionData().put("stream-closed", "stream-closed");
                        this.services.put(id, (XMPPIOService)newService);
                        OutQueue outQueue = (OutQueue)((IOService)newService).getSessionData().get(OUT_COUNTER_KEY);
                        ArrayList<OutQueue.Entry> packetsToResend = new ArrayList<OutQueue.Entry>(outQueue.getQueue());
                        for (OutQueue.Entry entry : packetsToResend) {
                            Packet packetToResend = entry.getPacketWithStamp();
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "{0}, resuming stream with id = {1} resending unacked packet = {2}", new Object[]{service, id, packetToResend});
                            }
                            ((XMPPIOService)newService).addPacketToSend(packetToResend);
                        }
                        if (packetsToResend.isEmpty() || !((XMPPIOService)newService).writeInProgress.tryLock()) break block18;
                        try {
                            ((XMPPIOService)newService).processWaitingPackets();
                            SocketThread.addSocketService(newService);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, newService + "Exception during writing packets: ", e);
                            try {
                                ((XMPPIOService)newService).stop();
                            }
                            catch (Exception e1) {
                                log.log(Level.WARNING, newService + "Exception stopping XMPPIOService: ", e1);
                            }
                        }
                        finally {
                            ((XMPPIOService)newService).writeInProgress.unlock();
                        }
                    }
                    catch (IOException ex) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "could not confirm session resumption for user = " + ((XMPPIOService)newService).getUserJid(), ex);
                        }
                        this.services.remove(id, service);
                        this.services.remove(id, newService);
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "no new service available for user {0} to resume from {1}, already closed?", new Object[]{service.getUserJid(), service});
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "closing old service {0} for user {1}", new Object[]{service, service.getUserJid()});
            }
            this.connectionManager.serviceStopped(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean serviceStopped(XMPPIOService service, boolean streamClosed) {
        Long resumptionTimeoutStart;
        if (!StreamManagementIOProcessor.isEnabled(service)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, service stopped - StreamManagement disabled", new Object[]{service});
            }
            return false;
        }
        String id = (String)service.getSessionData().get(STREAM_ID_KEY);
        if (streamClosed) {
            service.getSessionData().remove(STREAM_ID_KEY);
        }
        if ((resumptionTimeoutStart = (Long)service.getSessionData().get(RESUMPTION_TIMEOUT_START_KEY)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, service stopped - checking resumption timeout", new Object[]{service});
            }
            if (System.currentTimeMillis() - resumptionTimeoutStart > (long)(2 * this.resumption_timeout * 1000) || streamClosed) {
                this.services.remove(id, service);
                service.clearWaitingPackets();
                this.connectionManager.serviceStopped(service);
                TimerTask timerTask = (TimerTask)service.getSessionData().get(RESUMPTION_TASK_KEY);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                this.sendErrorsForQueuedPackets(service);
            }
            return false;
        }
        if (StreamManagementIOProcessor.isResumptionEnabled(service)) {
            if (service.getSessionData().getOrDefault("stream-closing", false) == Boolean.TRUE) {
                this.services.remove(id, service);
                this.connectionManager.serviceStopped(service);
                this.sendErrorsForQueuedPackets(service);
                return false;
            }
            if (!this.services.containsKey(id)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, service stopped - resumption enabled but service not available", new Object[]{service});
                }
                return false;
            }
            service.setIOServiceListener((IOServiceListener)null);
            int resumptionTimeout = (Integer)service.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY);
            XMPPIOService xMPPIOService = service;
            synchronized (xMPPIOService) {
                if (!service.getSessionData().containsKey(RESUMPTION_TASK_KEY)) {
                    ResumptionTimeoutTask timerTask = new ResumptionTimeoutTask(service);
                    service.getSessionData().put(RESUMPTION_TASK_KEY, timerTask);
                    this.connectionManager.addTimerTask(timerTask, resumptionTimeout * 1000);
                    service.getSessionData().put(RESUMPTION_TIMEOUT_START_KEY, System.currentTimeMillis());
                    service.clearWaitingPackets();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, service stopped - resumption enabled and timeout started", new Object[]{service});
                    }
                }
            }
            return false;
        }
        if (id != null) {
            this.services.remove(id, service);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, service stopped - resumption disabled, sending unacked packets", new Object[]{service});
        }
        service.clearWaitingPackets();
        this.connectionManager.serviceStopped(service);
        this.sendErrorsForQueuedPackets(service);
        return false;
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }

    @Override
    public void streamError(XMPPIOService service, StreamError streamErrorName) {
    }

    protected boolean shouldRequestAck(XMPPIOService service, OutQueue outQueue) {
        return outQueue.waitingForAck() >= this.ack_request_count;
    }

    protected Counter newCounter() {
        return new Counter();
    }

    protected OutQueue newOutQueue() {
        return new OutQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeStream(XMPPIOService service, String id, int h) throws IOException {
        XMPPIOService oldService = this.services.get(id);
        if (oldService == null || !this.isSameUser(oldService, service)) {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><item-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
            return;
        }
        if (service.getUserJid() != null && JID.jidInstanceNS((String)service.getUserJid()).getResource() != null) {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><unexpected-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
            return;
        }
        if (this.services.remove(id, oldService)) {
            XMPPIOService xMPPIOService = oldService;
            synchronized (xMPPIOService) {
                TimerTask timerTask = (TimerTask)oldService.getSessionData().remove(RESUMPTION_TASK_KEY);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                oldService.getSessionData().put(RESUMPTION_TASK_KEY, true);
                oldService.clearWaitingPackets();
            }
            OutQueue outQueue = (OutQueue)oldService.getSessionData().get(OUT_COUNTER_KEY);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "{0}, resuming stream with id = {1} with {2} packets waiting for ack, local h = {3} and remote h = {4}", new Object[]{service, id, outQueue.waitingForAck(), outQueue.get(), h});
            }
            outQueue.ack(h);
            service.getSessionData().put(OUT_COUNTER_KEY, outQueue);
            service.getSessionData().put(MAX_RESUMPTION_TIMEOUT_KEY, oldService.getSessionData().get(MAX_RESUMPTION_TIMEOUT_KEY));
            service.getSessionData().put(IN_COUNTER_KEY, oldService.getSessionData().get(IN_COUNTER_KEY));
            service.getSessionData().put(STREAM_ID_KEY, oldService.getSessionData().get(STREAM_ID_KEY));
            Packet cmd = Command.STREAM_MOVED.getPacket(service.getConnectionId(), service.getDataReceiver(), StanzaType.set, "moved");
            cmd.setPacketFrom(service.getConnectionId());
            cmd.setPacketTo(service.getDataReceiver());
            Command.addFieldValue(cmd, "old-conn-jid", oldService.getConnectionId().toString());
            this.connectionManager.processOutPacket(cmd);
        } else {
            service.writeRawData("<failed xmlns='urn:xmpp:sm:3'><item-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></failed>");
        }
    }

    private boolean isSameUser(XMPPIOService oldService, XMPPIOService newService) {
        if (oldService.getUserJid() == null || newService.getUserJid() == null) {
            return false;
        }
        JID oldUserJid = JID.jidInstanceNS((String)oldService.getUserJid());
        JID newUserJid = JID.jidInstanceNS((String)newService.getUserJid());
        return oldUserJid.getBareJID().equals((Object)newUserJid.getBareJID());
    }

    private void sendErrorsForQueuedPackets(XMPPIOService service) {
        service.clearWaitingPackets();
        OutQueue outQueue = (OutQueue)service.getSessionData().remove(OUT_COUNTER_KEY);
        if (outQueue != null) {
            OutQueue.Entry e = null;
            while ((e = (OutQueue.Entry)outQueue.queue.poll()) != null) {
                this.connectionManager.processUndeliveredPacket(e.getPacketWithStamp(), e.stamp, null);
            }
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private class ResumptionTimeoutTask
    extends TimerTask {
        private final XMPPIOService service;

        public ResumptionTimeoutTask(XMPPIOService service) {
            this.service = service;
        }

        @Override
        public void run() {
            String id = (String)this.service.getSessionData().get(StreamManagementIOProcessor.STREAM_ID_KEY);
            if (StreamManagementIOProcessor.this.services.remove(id, this.service)) {
                this.service.clearWaitingPackets();
                StreamManagementIOProcessor.this.connectionManager.serviceStopped(this.service);
                StreamManagementIOProcessor.this.sendErrorsForQueuedPackets(this.service);
            }
        }
    }

    public static class OutQueue
    extends Counter {
        private final ArrayDeque<Entry> queue = new ArrayDeque();
        private boolean resumptionEnabled = false;

        public void append(Packet packet) {
            if (!packet.wasProcessedBy(StreamManagementIOProcessor.XMLNS)) {
                packet.processedBy(StreamManagementIOProcessor.XMLNS);
                this.queue.offer(new Entry(packet));
                this.inc();
            }
        }

        public void ack(int value) {
            int count = this.get() - value;
            if (count < 0) {
                count = Integer.MAX_VALUE - value + this.get() + 1;
            }
            while (count < this.queue.size()) {
                this.queue.poll();
            }
        }

        public void setResumptionEnabled(boolean enabled) {
            this.resumptionEnabled = enabled;
        }

        public int waitingForAck() {
            return this.queue.size();
        }

        protected ArrayDeque<Entry> getQueue() {
            return this.queue;
        }

        public static class Entry {
            private final Packet packet;
            private final long stamp = System.currentTimeMillis();

            public Entry(Packet packet) {
                this.packet = packet;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Packet getPacketWithStamp() {
                if (this.packet.getElemName() != "iq" && !this.packet.isXMLNSStaticStr(DELAY_PATH, StreamManagementIOProcessor.DELAY_XMLNS)) {
                    String stamp = null;
                    SimpleDateFormat simpleDateFormat = formatter;
                    synchronized (simpleDateFormat) {
                        stamp = formatter.format(this.stamp);
                    }
                    String from = this.packet.getStanzaTo() != null ? this.packet.getStanzaTo().getDomain() : this.packet.getPacketTo().getDomain();
                    Element x = new Element("delay", new String[]{"from", "stamp", "xmlns"}, new String[]{from, stamp, StreamManagementIOProcessor.DELAY_XMLNS});
                    this.packet.getElement().addChild((XMLNodeIfc)x);
                }
                return this.packet;
            }
        }
    }

    public static class Counter {
        private int counter = 0;

        public void inc() {
            ++this.counter;
            if (this.counter < 0) {
                this.counter = 0;
            }
        }

        public int get() {
            return this.counter;
        }

        protected void setCounter(int value) {
            this.counter = value;
        }
    }
}

