/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.server.ext.lb.LoadBalancerIfc;
import tigase.server.ext.lb.ReceiverBareJidLB;
import tigase.xml.Element;

public class CompRepoItem
extends RepositoryItemAbstract {
    public static final String CONN_TYPE_ATTR = "type";
    public static final String CONNECTION_TYPE_LABEL = "Connection type";
    public static final String DOMAIN_ATTR = "domain";
    public static final String DOMAIN_NAME_LABEL = "Domain name";
    public static final String DOMAIN_PASS_LABEL = "Domain password";
    public static final String LB_CLASS_LABEL = "Load balancer class";
    public static final String LB_NAME_ATTR = "lb-class";
    public static final String PASSWORD_ATTR = "pass";
    public static final String PORT_NO_ATTR = "port";
    public static final String PORT_NO_LABEL = "Port number";
    public static final String PROTO_XMLNS_ATTR = "proto-xmlns";
    public static final String PROTO_XMLNS_LABEL = "Protocol";
    public static final String REMOTE_HOST_ATTR = "remote";
    public static final String REMOTE_HOST_LABEL = "Remote host";
    public static final String REPO_ITEM_ELEM_NAME = "item";
    public static final String ROUTINGS_ATTR = "routings";
    public static final String ROUTINGS_LABEL = "(Optional) Routings";
    public static final String SOCKET_ATTR = "socket";
    public static final String SOCKET_LABEL = "(Optional) Socket type";
    public static final LoadBalancerIfc DEF_LB_CLASS = new ReceiverBareJidLB();
    private static final Logger log = Logger.getLogger(CompRepoItem.class.getName());
    private String auth_pass = null;
    private String domain = null;
    private LoadBalancerIfc lb = DEF_LB_CLASS;
    private int port = -1;
    private String prop_xmlns = null;
    private String remoteHost = null;
    private String[] routings = null;
    private ConnectionType type = ConnectionType.accept;
    private String xmlns = null;
    private SocketType socket = SocketType.plain;

    @Override
    public void addCommandFields(Packet packet) {
        new Command.Builder(packet).addDataForm(Command.DataType.form).withFields(builder -> {
            builder.addField(this.domain == null ? DataForm.FieldType.TextSingle : DataForm.FieldType.Fixed, DOMAIN_NAME_LABEL).setRequired(true).setValue(this.domain).build();
            builder.addField(DataForm.FieldType.TextSingle, DOMAIN_PASS_LABEL).setRequired(true).setValue(this.auth_pass).build();
            builder.addField(DataForm.FieldType.ListSingle, CONNECTION_TYPE_LABEL).setLabel(CONNECTION_TYPE_LABEL).setRequired(true).setValue(this.type.name()).setOptions(ConnectionType.names()).build();
            builder.addField(DataForm.FieldType.TextSingle, PORT_NO_LABEL).setRequired(true).setValue(this.port > 0 ? String.valueOf(this.port) : null).build();
            builder.addField(DataForm.FieldType.TextSingle, REMOTE_HOST_LABEL).setValue(this.remoteHost).build();
            builder.addField(DataForm.FieldType.ListSingle, PROTO_XMLNS_LABEL).addOption("", "Autodetect").addOption("accept", "XEP-0114: Jabber Component Protocol (accept)").addOption("client", "XEP-0225: Component Connections").setValue(this.prop_xmlns).setDesc("For 'accept' connection type you may use 'Autodetect' but for 'connect' type you need to select exact protocol").build();
            builder.addField(DataForm.FieldType.TextSingle, LB_CLASS_LABEL).setValue(this.lb != null ? this.lb.getClass().getName() : null).build();
            builder.addField(DataForm.FieldType.TextSingle, ROUTINGS_LABEL).setValue((String)Optional.ofNullable(this.routings).map(Arrays::stream).map(stream -> stream.collect(Collectors.joining(","))).orElse(null));
            builder.addField(DataForm.FieldType.ListSingle, SOCKET_LABEL).setValue(this.socket.name()).setLabel(SOCKET_LABEL).setOptions(SocketType.names()).build();
        }).build();
        super.addCommandFields(packet);
    }

    public String getAuthPasswd() {
        return this.auth_pass;
    }

    public ConnectionType getConnectionType() {
        return this.type;
    }

    void setConnectionType(String connection_type) {
        this.type = this.parseConnectionType(connection_type);
    }

    public LoadBalancerIfc getLoadBalancer() {
        return this.lb;
    }

    public String getLb() {
        if (this.lb != null) {
            return this.lb.getClass().getCanonicalName();
        }
        return null;
    }

    public void setLb(String clazz) {
        if (clazz != null) {
            this.lb = this.lbInstance(clazz);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.routings = new String[]{domain, ".*@" + domain, ".*\\." + domain};
    }

    @Override
    public String getElemName() {
        return REPO_ITEM_ELEM_NAME;
    }

    @Override
    public String getKey() {
        return this.domain;
    }

    @Override
    protected void setKey(String key) {
        this.setDomain(key);
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String[] getRoutings() {
        return this.routings;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    public SocketType getSocket() {
        return this.socket;
    }

    @Override
    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        this.domain = Command.getFieldValue(packet, DOMAIN_NAME_LABEL);
        this.routings = new String[]{this.domain, ".*@" + this.domain, ".*\\." + this.domain};
        this.auth_pass = Command.getFieldValue(packet, DOMAIN_PASS_LABEL);
        String tmp = Command.getFieldValue(packet, REMOTE_HOST_LABEL);
        if (tmp != null && !tmp.isEmpty()) {
            this.remoteHost = tmp;
        }
        if ((tmp = Command.getFieldValue(packet, CONNECTION_TYPE_LABEL)) != null && !tmp.isEmpty()) {
            this.type = this.parseConnectionType(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, PORT_NO_LABEL)) != null && !tmp.isEmpty()) {
            this.port = this.parsePortNo(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, PROTO_XMLNS_LABEL)) != null && !tmp.isEmpty()) {
            this.prop_xmlns = tmp;
            this.xmlns = this.parseProtoXMLNS(this.prop_xmlns);
        }
        if ((tmp = Command.getFieldValue(packet, LB_CLASS_LABEL)) != null && !tmp.trim().isEmpty()) {
            this.lb = this.lbInstance(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, ROUTINGS_LABEL)) != null && !tmp.isEmpty()) {
            this.routings = tmp.split(",");
        }
        if ((tmp = Command.getFieldValue(packet, SOCKET_LABEL)) != null && !tmp.isEmpty()) {
            this.socket = this.parseSocket(tmp);
        }
    }

    @Override
    public void initFromElement(Element elem) {
        if (elem.getName() != REPO_ITEM_ELEM_NAME) {
            throw new IllegalArgumentException("Incorrect element name, expected: item");
        }
        super.initFromElement(elem);
        this.setDomain(elem.getAttributeStaticStr(DOMAIN_ATTR));
        this.auth_pass = elem.getAttributeStaticStr(PASSWORD_ATTR);
        this.remoteHost = elem.getAttributeStaticStr(REMOTE_HOST_ATTR);
        String tmp = elem.getAttributeStaticStr(CONN_TYPE_ATTR);
        if (tmp != null) {
            this.setConnectionType(tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(PORT_NO_ATTR)) != null) {
            this.port = this.parsePortNo(tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(PROTO_XMLNS_ATTR)) != null) {
            this.setProtocol(tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(LB_NAME_ATTR)) != null) {
            this.lb = this.lbInstance(tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(ROUTINGS_ATTR)) != null) {
            this.routings = tmp.split(",");
        }
        if ((tmp = elem.getAttributeStaticStr(SOCKET_ATTR)) != null) {
            this.socket = this.parseSocket(tmp);
        }
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        if (props.length > 0) {
            this.setDomain(props[0]);
        }
        if (props.length > 1) {
            this.auth_pass = props[1];
        }
        if (props.length > 2 && !props[2].trim().isEmpty()) {
            this.setConnectionType(props[2]);
        }
        if (props.length > 3 && !props[3].trim().isEmpty()) {
            this.port = this.parsePortNo(props[3]);
        }
        if (props.length > 4 && !props[4].trim().isEmpty()) {
            this.remoteHost = props[4];
        }
        if (props.length > 5 && !props[5].trim().isEmpty()) {
            this.setProtocol(props[5]);
        }
        if (props.length > 6 && !props[6].trim().isEmpty()) {
            this.lb = this.lbInstance(props[6]);
        }
        if (props.length > 7 && !props[7].trim().isEmpty()) {
            this.socket = this.parseSocket(props[7]);
        }
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        elem.addAttribute(DOMAIN_ATTR, this.domain);
        elem.addAttribute(PASSWORD_ATTR, this.auth_pass);
        if (this.remoteHost != null && !this.remoteHost.isEmpty()) {
            elem.addAttribute(REMOTE_HOST_ATTR, this.remoteHost);
        }
        elem.addAttribute(CONN_TYPE_ATTR, this.type.name());
        if (this.port > 0) {
            elem.addAttribute(PORT_NO_ATTR, "" + this.port);
        }
        if (this.prop_xmlns != null) {
            elem.addAttribute(PROTO_XMLNS_ATTR, this.prop_xmlns);
        }
        elem.addAttribute(LB_NAME_ATTR, this.lb.getClass().getName());
        StringBuilder route = new StringBuilder();
        for (String r : this.routings) {
            if (route.length() > 0) {
                route.append(',');
            }
            route.append(r);
        }
        elem.addAttribute(ROUTINGS_ATTR, route.toString());
        elem.addAttribute(SOCKET_ATTR, this.socket.name());
        return elem;
    }

    @Override
    public String toPropertyString() {
        return this.domain + ":" + this.auth_pass + ":" + this.type.name() + ":" + this.port + ":" + this.remoteHost + ":" + this.prop_xmlns + ":" + this.lb.getClass().getName();
    }

    public String toString() {
        return this.toPropertyString();
    }

    void setPassword(String password) {
        this.auth_pass = password;
    }

    void setProtocol(String protocol) {
        this.prop_xmlns = protocol;
        this.xmlns = this.parseProtoXMLNS(protocol);
    }

    void setRemoteDomain(String remote_domain) {
        this.remoteHost = remote_domain;
    }

    String validate() {
        if (this.domain == null) {
            return "Domain name is required";
        }
        if (this.auth_pass == null) {
            return "Password is required";
        }
        if (this.prop_xmlns != null && "connect".equals(this.prop_xmlns)) {
            return "Feature not implemented. Please use 'accept' protocol";
        }
        if (this.type == ConnectionType.connect && this.prop_xmlns == null) {
            return "It is required to select protocol for connecting socket!";
        }
        return null;
    }

    private LoadBalancerIfc lbInstance(String cls_name) {
        String class_name = cls_name;
        log.log(Level.INFO, "Activating load-balancer for domain: {0}, class: {1}", new Object[]{this.domain, class_name});
        LoadBalancerIfc result = null;
        try {
            result = (LoadBalancerIfc)Class.forName(class_name).newInstance();
        }
        catch (Exception ex1) {
            class_name = "tigase.server.ext.lb." + class_name;
            log.log(Level.INFO, "Cannot active load balancer for class: {0}, trying: {1}", new Object[]{cls_name, class_name});
            try {
                result = (LoadBalancerIfc)Class.forName(class_name).newInstance();
            }
            catch (Exception ex2) {
                log.log(Level.WARNING, "Cannot active load balancer for class: {0}, or: {1}, errors: {2} or {3}, using default LB: {4}", new Object[]{cls_name, class_name, ex1, ex2, DEF_LB_CLASS.getClass().getName()});
                result = DEF_LB_CLASS;
            }
        }
        log.log(Level.INFO, "Activated load-balancer for domain: {0}, class: {1}", new Object[]{this.domain, result.getClass().getName()});
        return result;
    }

    private ConnectionType parseConnectionType(String input) {
        ConnectionType result = ConnectionType.accept;
        if (input.equals("connect")) {
            result = ConnectionType.connect;
        }
        if (input.equals("accept") || input.equals("listen")) {
            result = ConnectionType.accept;
        }
        return result;
    }

    private int parsePortNo(String input) {
        int result = -1;
        try {
            result = Integer.parseInt(input);
        }
        catch (Exception e) {
            result = 5277;
            log.warning("Incorrect port number, can''t parse: " + input);
        }
        return result;
    }

    private String parseProtoXMLNS(String input) {
        String result = input;
        if (input.equals("accept")) {
            result = "jabber:component:accept";
        }
        if (input.equals("client")) {
            result = "jabber:client";
        }
        if (input.equals("connect")) {
            result = "jabber:component:connect";
        }
        return result;
    }

    private SocketType parseSocket(String socket) {
        SocketType result = SocketType.plain;
        try {
            return SocketType.valueOf(socket.trim().toLowerCase());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error parsing external connection type: " + socket + ", using default: " + (Object)((Object)SocketType.plain), e);
            return result;
        }
    }
}

