/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import tigase.cert.CertificateEntry;
import tigase.cert.CertificateUtil;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainer;
import tigase.io.SSLContextContainerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;

@Bean(name="certificate-container", parent=Kernel.class, active=true, exportable=true)
public class CertificateContainer
implements CertificateContainerIfc,
Initializable,
UnregisterAware {
    public static final String PER_DOMAIN_CERTIFICATE_KEY = "virt-hosts-cert-";
    public static final String SNI_DISABLE_KEY = "sni-disable";
    private static final Logger log = Logger.getLogger(CertificateContainer.class.getCanonicalName());
    private static final EventBus eventBus = EventBusFactory.getInstance();
    private Map<String, CertificateEntry> cens = new ConcurrentSkipListMap<String, CertificateEntry>();
    private File defaultCertDirectory = null;
    @ConfigField(desc="Custom certificates", alias="custom-certificates")
    private Map<String, String> customCerts = new HashMap<String, String>();
    @ConfigField(desc="Alias for default certificate", alias="ssl-def-cert-domain")
    private String def_cert_alias = "default";
    private String email = "admin@tigase.org";
    private char[] emptyPass = new char[0];
    private Map<String, KeyManagerFactory> kmfs = new ConcurrentSkipListMap<String, KeyManagerFactory>();
    private KeyManager[] kms = new KeyManager[]{new SniKeyManager()};
    private String o = "Tigase.org";
    private String ou = "XMPP Service";
    @ConfigField(desc="Disable SNI support", alias="sni-disable")
    private boolean sniDisable = false;
    @ConfigField(desc="Location of server SSL certificates", alias="ssl-certs-location")
    private String[] sslCertsLocation = new String[]{"certs/"};
    private X509TrustManager[] tms = new X509TrustManager[]{new FakeTrustManager()};
    private KeyStore trustKeyStore = null;
    @ConfigField(desc="Location of trusted certificates", alias="trusted-certs-dir")
    private String[] trustedCertsDir = new String[]{"/etc/ssl/certs"};
    @ConfigField(desc="Whether generated certificate should be wildcard")
    private boolean generateWildcardCertificate = true;
    @ConfigField(desc="Remove root CA (efectively self-signed) certificate from chain")
    private boolean removeRootCACertificate = true;

    @Override
    public void addCertificates(Map<String, String> params) throws CertificateParsingException {
        String pemCert = params.get("pem-certificate");
        String saveToDiskVal = params.get("cert-save-to-disk");
        boolean saveToDisk = saveToDiskVal != null && saveToDiskVal.equalsIgnoreCase("true");
        String alias = params.get("cert-alias");
        if (alias == null) {
            throw new RuntimeException("Certificate alias must be specified");
        }
        if (pemCert != null) {
            this.addCertificate(alias, pemCert, saveToDisk, true);
        }
    }

    @Override
    public KeyManager[] createCertificate(String alias) throws NoSuchAlgorithmException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException, IOException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory keyManagerFactory = this.createCertificateKmf(alias);
        KeyManager[] kms = keyManagerFactory.getKeyManagers();
        log.log(Level.WARNING, "Auto-generated certificate for domain: {0}", alias);
        return kms;
    }

    @Override
    public String getDefCertAlias() {
        return this.def_cert_alias;
    }

    @Override
    public CertificateEntry getCertificateEntry(String hostname) {
        String alias = hostname == null ? this.getDefCertAlias() : hostname.toLowerCase();
        return SSLContextContainerAbstract.find(this.cens, alias);
    }

    @Override
    public KeyManager[] getKeyManagers(String hostname) {
        KeyManagerFactory kmf;
        if (hostname == null && !this.sniDisable) {
            return this.kms;
        }
        String alias = hostname;
        if (alias == null) {
            alias = this.getDefCertAlias();
        }
        return (kmf = SSLContextContainerAbstract.find(this.kmfs, alias)) == null ? null : kmf.getKeyManagers();
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return this.tms;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustKeyStore;
    }

    @Override
    public void init(Map<String, Object> params) {
        try {
            this.def_cert_alias = (String)params.get("ssl-def-cert-domain");
            if (this.def_cert_alias == null) {
                this.def_cert_alias = "default";
            }
            this.sniDisable = params.containsKey(SNI_DISABLE_KEY) ? (Boolean)params.get(SNI_DISABLE_KEY) : false;
            String pemD = (String)params.get("ssl-certs-location");
            if (pemD == null) {
                pemD = "certs/";
            }
            String[] pemDirs = pemD.split(",");
            this.defaultCertDirectory = this.getDefaultCertDirectory(pemDirs);
            this.loadCertificatesFromDirectories(pemDirs);
            Map<String, String> predefined = this.findPredefinedCertificates(params);
            this.loadPredefinedCertificates(predefined);
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "There was a problem initializing SSL certificates.", ex);
            }
            log.log(Level.WARNING, "There was a problem initializing SSL certificates.");
        }
        String trustLoc = (String)params.get("trusted-certs-dir");
        if (trustLoc == null) {
            trustLoc = "/etc/ssl/certs";
        }
        final String[] trustLocations = trustLoc.split(",");
        new Thread(){

            @Override
            public void run() {
                CertificateContainer.this.loadTrustedCerts(trustLocations);
            }
        }.start();
    }

    private void loadCertificatesFromDirectories(String[] pemDirs) {
        for (String pemDir : pemDirs) {
            log.log(Level.CONFIG, "Loading server certificates from PEM directory: {0}", pemDir);
            File directory = new File(pemDir);
            if (!directory.exists()) continue;
            File[] files = directory.listFiles(new PEMFileFilter());
            Arrays.sort(files, Comparator.comparingInt(fn -> fn.getName().split("\\.").length));
            for (File file : files) {
                this.loadCertificateFromFile(file);
            }
        }
    }

    private void loadCertificateFromFile(File file) {
        try {
            CertificateEntry certEntry = CertificateUtil.loadCertificate((File)file);
            String alias = file.getName();
            if (alias.endsWith(".pem")) {
                alias = alias.substring(0, alias.length() - 4);
            }
            this.addCertificateEntry(certEntry, alias, false);
            Set domains = certEntry.getCertificate().map(CertificateContainer::getAllCNames).orElse(Collections.emptySet());
            log.log(Level.CONFIG, "Loaded server certificate for domain: {0} (altCNames: {1}) from file: {2}", new Object[]{alias, String.join((CharSequence)", ", domains), file});
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Cannot load certficate from file: " + file, ex);
            }
            log.log(Level.WARNING, "Cannot load certficate from file: " + file);
        }
    }

    private void loadPredefinedCertificates(Map<String, String> predefined) {
        log.log(Level.CONFIG, "Loading predefined server certificates");
        for (Map.Entry<String, String> entry : predefined.entrySet()) {
            try {
                File file = new File(entry.getValue());
                CertificateEntry certEntry = CertificateUtil.loadCertificate((File)file);
                String alias = entry.getKey();
                this.addCertificateEntry(certEntry, alias, false);
                Set domains = certEntry.getCertificate().map(CertificateContainer::getAllCNames).orElse(Collections.emptySet());
                log.log(Level.CONFIG, "Loaded predefined server certificate for domain: {0} (altCNames: {1}) from file: {2}", new Object[]{alias, String.join((CharSequence)", ", domains), entry.getValue()});
            }
            catch (Exception ex) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Cannot load certficate from file: " + entry.getValue(), ex);
                }
                log.log(Level.WARNING, "Cannot load certficate from file: " + entry.getValue());
            }
        }
    }

    @Override
    public void initialize() {
        eventBus.registerAll(this);
        try {
            String[] pemDirs = this.sslCertsLocation;
            this.defaultCertDirectory = this.getDefaultCertDirectory(pemDirs);
            this.loadCertificatesFromDirectories(pemDirs);
            this.loadPredefinedCertificates(this.customCerts);
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "There was a problem initializing SSL certificates.", ex);
            }
            log.log(Level.WARNING, "There was a problem initializing SSL certificates.");
        }
        new Thread(){

            @Override
            public void run() {
                CertificateContainer.this.loadTrustedCerts(CertificateContainer.this.trustedCertsDir);
            }
        }.start();
    }

    private File getDefaultCertDirectory(String[] pemDirs) {
        File file = Arrays.stream(pemDirs).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toFile).filter(File::exists).findFirst().orElse(Paths.get(pemDirs[0], new String[0]).toFile());
        log.log(Level.CONFIG, () -> "Setting default directory for storing certificates to: " + file.getAbsolutePath());
        return file;
    }

    KeyManagerFactory addCertificateEntry(CertificateEntry entry, String alias, boolean store) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        PrivateKey privateKey = entry.getPrivateKey();
        Certificate[] certChain = CertificateUtil.sort((Certificate[])entry.getCertChain());
        if (this.removeRootCACertificate) {
            certChain = CertificateUtil.removeRootCACertificate((Certificate[])certChain);
        }
        KeyManagerFactory kmf = this.getKeyManagerFactory(alias, privateKey, certChain);
        this.kmfs.put(alias, kmf);
        this.cens.put(alias, entry);
        Optional certificate = entry.getCertificate();
        if (certificate.isPresent()) {
            Set<String> domains = CertificateContainer.getAllCNames((Certificate)certificate.get());
            SSLContextContainerAbstract.removeMatchedDomains(this.kmfs, domains);
            SSLContextContainerAbstract.removeMatchedDomains(this.cens, domains);
            for (String domain : domains) {
                kmf = this.getKeyManagerFactory(domain, privateKey, certChain);
                this.kmfs.put(domain, kmf);
                this.cens.put(domain, entry);
            }
        }
        if (store) {
            String filename = alias.startsWith("*.") ? alias.substring(2) : alias;
            CertificateUtil.storeCertificate((String)new File(this.defaultCertDirectory, filename + ".pem").toString(), (CertificateEntry)entry);
        }
        return kmf;
    }

    private KeyManagerFactory getKeyManagerFactory(String domain, PrivateKey privateKey, Certificate[] certChain) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keys = KeyStore.getInstance("JKS");
        keys.load(null, this.emptyPass);
        keys.setKeyEntry(domain, privateKey, this.emptyPass, certChain);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keys, this.emptyPass);
        return kmf;
    }

    @Override
    public void beforeUnregister() {
        eventBus.unregisterAll(this);
    }

    @HandleEvent
    public void certificateChange(CertificateChange event) {
        if (event.isLocal()) {
            return;
        }
        try {
            this.addCertificate(event.getAlias(), event.getPemCertificate(), event.isSaveToDisk(), false);
        }
        catch (CertificateParsingException ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Failed to update certificate for " + event.getAlias(), ex);
            }
            log.log(Level.WARNING, "Failed to update certificate for " + event.getAlias() + ", " + ex);
        }
    }

    private void addCertificate(String alias, String pemCert, boolean saveToDisk, boolean notifyCluster) throws CertificateParsingException {
        try {
            CertificateEntry entry = CertificateUtil.parseCertificate((Reader)new CharArrayReader(pemCert.toCharArray()));
            this.addCertificateEntry(entry, alias, saveToDisk);
            if (notifyCluster) {
                eventBus.fire(new CertificateChange(alias, pemCert, saveToDisk));
            }
            Optional certificate = entry.getCertificate();
            Set<String> domains = certificate.map(CertificateContainer::getAllCNames).orElse(Collections.emptySet());
            eventBus.fire(new CertificateChanged(alias, domains));
            log.log(Level.INFO, "Certificate with alias: {0} for domains: {1} added. Saving to disk: {2}, notify cluster: {3}", new Object[]{alias, domains, saveToDisk, notifyCluster});
        }
        catch (Exception ex) {
            throw new CertificateParsingException("Problem adding a new certificate (" + ex.getMessage() + ")", ex);
        }
    }

    private KeyManagerFactory createCertificateKmf(String alias) throws NoSuchAlgorithmException, CertificateException, IOException, InvalidKeyException, NoSuchProviderException, SignatureException, KeyStoreException, UnrecoverableKeyException {
        alias = !alias.startsWith("*.") && this.generateWildcardCertificate ? "*." + alias : alias;
        CertificateEntry entry = CertificateUtil.createSelfSignedCertificate((String)this.email, (String)alias, (String)this.ou, (String)this.o, null, null, null, () -> CertificateUtil.createKeyPair((int)1024, (String)"secret"));
        return this.addCertificateEntry(entry, alias, true);
    }

    private Map<String, String> findPredefinedCertificates(Map<String, Object> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params == null) {
            return result;
        }
        for (String t : params.keySet()) {
            if (!t.startsWith(PER_DOMAIN_CERTIFICATE_KEY)) continue;
            String domainName = t.substring(PER_DOMAIN_CERTIFICATE_KEY.length());
            result.put(domainName, params.get(t).toString());
        }
        return result;
    }

    private void loadTrustedCerts(String[] trustLocations) {
        int counter = 0;
        long start = System.currentTimeMillis();
        ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>(200);
        try {
            FileInputStream in;
            this.trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.trustKeyStore.load(null, this.emptyPass);
            File trustStoreFile = new File(System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar));
            File userStoreFile = new File("~/.keystore");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Looking for trusted certs in: {0}", trustStoreFile);
            }
            if (trustStoreFile.exists()) {
                log.log(Level.CONFIG, "Loading trustKeyStore from location: {0}", trustStoreFile);
                in = new FileInputStream(trustStoreFile);
                this.trustKeyStore.load(in, null);
                ((InputStream)in).close();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Looking for trusted certs in: {0}", userStoreFile);
            }
            if (userStoreFile.exists()) {
                log.log(Level.CONFIG, "Loading trustKeyStore from location: {0}", userStoreFile);
                in = new FileInputStream(userStoreFile);
                this.trustKeyStore.load(in, null);
                ((InputStream)in).close();
            }
            log.log(Level.CONFIG, "Loading trustKeyStore from locations: {0}", Arrays.toString(trustLocations));
            for (String location : trustLocations) {
                File root = new File(location);
                File[] files = root.listFiles(new PEMFileFilter());
                if (files == null) continue;
                for (File file : files) {
                    try {
                        CertificateEntry certEntry = CertificateUtil.loadCertificate((File)file);
                        Certificate[] chain = certEntry.getCertChain();
                        if (chain == null) continue;
                        for (Certificate cert : chain) {
                            if (!(cert instanceof X509Certificate)) continue;
                            X509Certificate crt = (X509Certificate)cert;
                            String alias = crt.getSubjectX500Principal().getName();
                            this.trustKeyStore.setCertificateEntry(alias, crt);
                            acceptedIssuers.add(crt);
                            log.log(Level.FINEST, "Imported certificate: {0}", alias);
                            ++counter;
                        }
                    }
                    catch (Exception e) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Problem loading certificate from file: " + file, e);
                        }
                        log.log(Level.WARNING, "Problem loading certificate from file: {0}", file);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "An error loading trusted certificates", ex);
            }
            log.log(Level.WARNING, "An error loading trusted certificates");
        }
        try {
            if (!this.trustKeyStore.aliases().hasMoreElements()) {
                log.log(Level.CONFIG, "No Trusted Anchors!!! Creating temporary trusted CA cert!");
                CertificateEntry entry = CertificateUtil.createSelfSignedCertificate((String)"fake_local@tigase", (String)"fake one", (String)"none", (String)"none", (String)"none", (String)"none", (String)"US", () -> CertificateUtil.createKeyPair((int)1024, (String)"secret"));
                this.trustKeyStore.setCertificateEntry("generated fake CA", entry.getCertChain()[0]);
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Can''t generate fake trusted CA certificate", e);
            }
            log.log(Level.WARNING, "Can''t generate fake trusted CA certificate");
        }
        this.tms = new X509TrustManager[]{new FakeTrustManager(acceptedIssuers.toArray(new X509Certificate[acceptedIssuers.size()]))};
        long seconds = (System.currentTimeMillis() - start) / 1000L;
        log.log(Level.CONFIG, "Loaded {0} trust certificates, it took {1} seconds.", new Object[]{counter, seconds});
    }

    private static Set<String> getAllCNames(Certificate certificate) {
        TreeSet<String> altDomains = new TreeSet<String>();
        if (certificate instanceof X509Certificate) {
            X509Certificate certX509 = (X509Certificate)certificate;
            String certCName = CertificateUtil.getCertCName((X509Certificate)certX509);
            if (certCName != null) {
                altDomains.add(certCName);
            }
            List certAltCName = CertificateUtil.getCertAltCName((X509Certificate)certX509);
            altDomains.addAll(certAltCName);
        }
        return altDomains;
    }

    private class SniKeyManager
    extends X509ExtendedKeyManager {
        private SniKeyManager() {
        }

        @Override
        public String[] getClientAliases(String string, Principal[] prncpls) {
            return null;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
            return null;
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            Set aliases = CertificateContainer.this.kmfs.keySet();
            return aliases.toArray(new String[aliases.size()]);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            if (socket instanceof SSLSocket) {
                ExtendedSSLSession session = (ExtendedSSLSession)((SSLSocket)socket).getSession();
                return this.chooseServerAlias(session);
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            ExtendedSSLSession session = (ExtendedSSLSession)engine.getHandshakeSession();
            return this.chooseServerAlias(session);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            KeyManagerFactory kmf;
            if (alias == null) {
                alias = CertificateContainer.this.def_cert_alias;
            }
            if ((kmf = (KeyManagerFactory)SSLContextContainerAbstract.find(CertificateContainer.this.kmfs, alias)) == null) {
                alias = CertificateContainer.this.def_cert_alias;
                kmf = (KeyManagerFactory)SSLContextContainer.find(CertificateContainer.this.kmfs, alias);
            }
            if (kmf == null) {
                try {
                    kmf = CertificateContainer.this.createCertificateKmf(alias);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Failed to create certificate for alias: " + alias, e);
                    }
                    log.log(Level.WARNING, "Failed to create certificate for alias: " + alias);
                }
            }
            return kmf != null ? ((X509KeyManager)kmf.getKeyManagers()[0]).getCertificateChain(alias) : null;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            KeyManagerFactory kmf;
            if (alias == null) {
                alias = CertificateContainer.this.def_cert_alias;
            }
            if ((kmf = (KeyManagerFactory)SSLContextContainerAbstract.find(CertificateContainer.this.kmfs, alias)) == null) {
                alias = CertificateContainer.this.def_cert_alias;
                kmf = (KeyManagerFactory)SSLContextContainer.find(CertificateContainer.this.kmfs, alias);
            }
            if (kmf == null) {
                try {
                    kmf = CertificateContainer.this.createCertificateKmf(alias);
                }
                catch (Exception e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Failed to create certificate for alias: " + alias, e);
                    }
                    log.log(Level.WARNING, "Failed to create certificate for alias: " + alias);
                }
            }
            return kmf != null ? ((X509KeyManager)kmf.getKeyManagers()[0]).getPrivateKey(alias) : null;
        }

        private String chooseServerAlias(ExtendedSSLSession session) {
            String hostname = null;
            for (SNIServerName name : session.getRequestedServerNames()) {
                if (name.getType() != 0) continue;
                hostname = ((SNIHostName)name).getAsciiName();
                break;
            }
            if (hostname != null && this.getCertificateChain(hostname) != null && this.getPrivateKey(hostname) != null) {
                return hostname;
            }
            return CertificateContainer.this.def_cert_alias;
        }
    }

    private class PEMFileFilter
    implements FileFilter {
        private PEMFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && (pathname.getName().endsWith(".pem") || pathname.getName().endsWith(".PEM") || pathname.getName().endsWith(".crt") || pathname.getName().endsWith(".CRT") || pathname.getName().endsWith(".cer") || pathname.getName().endsWith(".CER"));
        }
    }

    public class CertificateChanged {
        private String alias;
        Set<String> domains = new ConcurrentSkipListSet<String>();

        public CertificateChanged(String alias, Set<String> domains) {
            this.alias = alias;
            if (domains != null) {
                this.domains.addAll(domains);
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public Set<String> getDomains() {
            return this.domains;
        }
    }

    public static class CertificateChange
    implements Serializable {
        private String alias;
        private String pemCert;
        private boolean saveToDisk;
        private transient boolean local = false;

        public CertificateChange() {
        }

        public CertificateChange(String alias, String pemCert, boolean saveToDisk) {
            this.alias = alias;
            this.pemCert = pemCert;
            this.saveToDisk = saveToDisk;
            this.local = true;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getPemCertificate() {
            return this.pemCert;
        }

        public boolean isLocal() {
            return this.local;
        }

        public boolean isSaveToDisk() {
            return this.saveToDisk;
        }
    }

    private static class FakeTrustManager
    implements X509TrustManager {
        private X509Certificate[] issuers = null;

        FakeTrustManager() {
            this(new X509Certificate[0]);
        }

        FakeTrustManager(X509Certificate[] ai) {
            this.issuers = ai;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.issuers;
        }
    }
}

