/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.lang.reflect.Method;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.impl.AbstractHandler;

public class ReflectEventListenerHandler
extends AbstractHandler {
    protected final Object consumerObject;
    protected final HandleEvent.Type filter;
    protected final Method handlerMethod;

    public ReflectEventListenerHandler(HandleEvent.Type filter, String packageName, String eventName, Object consumerObject, Method handlerMethod) {
        super(packageName, eventName);
        this.filter = filter;
        this.consumerObject = consumerObject;
        this.handlerMethod = handlerMethod;
    }

    @Override
    public void dispatch(Object event, Object source, boolean remotelyGeneratedEvent) {
        if (remotelyGeneratedEvent && this.filter == HandleEvent.Type.local || !remotelyGeneratedEvent && this.filter == HandleEvent.Type.remote) {
            return;
        }
        try {
            this.handlerMethod.invoke(this.consumerObject, event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectEventListenerHandler that = (ReflectEventListenerHandler)o;
        if (!this.consumerObject.equals(that.consumerObject)) {
            return false;
        }
        return this.handlerMethod.equals(that.handlerMethod);
    }

    @Override
    public AbstractHandler.Type getRequiredEventType() {
        return AbstractHandler.Type.object;
    }

    public int hashCode() {
        int result = this.consumerObject.hashCode();
        result = 31 * result + this.handlerMethod.hashCode();
        return result;
    }
}

