/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigReader;
import tigase.conf.ConfigWriter;
import tigase.conf.ConfiguratorAbstract;
import tigase.db.RepositoryFactory;
import tigase.kernel.beans.Bean;
import tigase.server.ext.ComponentProtocol;
import tigase.util.reflection.ClassUtilBean;
import tigase.util.repository.DataTypes;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPProcessor;

public class OldConfigHolder {
    private static final Logger log = Logger.getLogger(OldConfigHolder.class.getCanonicalName());
    private List<String> output = new ArrayList<String>();
    private Path[] propertyFileNames = null;
    private Map<String, Object> props = new LinkedHashMap<String, Object>();

    public Optional<String[]> getOutput() {
        if (this.output.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.output.toArray(new String[this.output.size()]));
    }

    public void convert(String[] args, Path tdslPath) throws IOException, ConfigReader.ConfigException {
        LinkedList<String> settings = new LinkedList<String>();
        ConfiguratorAbstract.parseArgs(this.props, settings, args);
        this.props.remove("--test");
        if (this.detectPathAndFormat() == Format.dsl) {
            Optional<Object> backup = Optional.empty();
            if (Files.exists(tdslPath, new LinkOption[0])) {
                backup = Optional.ofNullable(ConfigHolder.backupOldConfigFile(tdslPath));
            }
            Files.move(this.propertyFileNames[0], tdslPath, new CopyOption[0]);
            this.logOutput("Configuration file {0} was updated to match current configuration format and renamed to {1}.", this.propertyFileNames[0], tdslPath);
            backup.ifPresent(backupPath -> this.logOutput("Previous version of a configuration file was saved as {0}", backupPath));
            return;
        }
        if (this.propertyFileNames.length == 0) {
            return;
        }
        this.loadFromPropertyFiles();
        this.convertFromOldFormat();
        this.props = ConfigWriter.buildTree(this.props);
        this.props.remove("--property-file");
        this.props.remove("--config-file");
        if (Files.exists(tdslPath, new LinkOption[0])) {
            Path backup = ConfigHolder.backupOldConfigFile(tdslPath);
            this.logOutput("Existing DSL config file {0} was renamed to {1} as conversion from property files was started.", tdslPath, backup);
        }
        new ConfigWriter().write(tdslPath.toFile(), this.props);
        this.logOutput("Configuration files {0} were updated to DSL configuration format and saved as {1}.", Arrays.stream(this.propertyFileNames).map(path -> path.toString()).collect(Collectors.joining()), tdslPath);
        for (Path path2 : this.propertyFileNames) {
            Path backup = ConfigHolder.backupOldConfigFile(path2);
            this.logOutput("Old configuration file {0} was renamed to {1}.", path2, backup);
        }
    }

    protected Map<String, Object> getProperties() {
        return this.props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Format detectPathAndFormat() {
        File f;
        String property_filenames = (String)this.props.remove("--property-file");
        if (property_filenames == null) {
            property_filenames = "etc/init.properties";
            log.log(Level.FINEST, "No property file not specified! Using default one {0}", property_filenames);
        }
        if (property_filenames == null) return Format.properties;
        String[] prop_filenames = property_filenames.split(",");
        if (prop_filenames.length == 1 && !(f = new File(prop_filenames[0])).exists()) {
            log.log(Level.FINEST, "Provided property file {0} does NOT EXISTS! Trying to use default one {1}", new String[]{f.getAbsolutePath(), "etc/init.properties"});
            prop_filenames[0] = "etc/init.properties";
        }
        Path[] pathArray = this.propertyFileNames = (Path[])Arrays.stream(prop_filenames).map(filename -> Paths.get(filename, new String[0])).filter(path -> Files.exists(path, new LinkOption[0])).toArray(Path[]::new);
        int n = pathArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path path2 = pathArray[n2];
            File file = path2.toFile();
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null && !line.startsWith("--user-db")) {
                    if (!line.contains("{") || line.contains("{clusterNode}") || line.contains("{ call") && !line.contains("'{ call") && !line.contains("\"{ call")) continue;
                    Format format = Format.dsl;
                    return format;
                }
            }
            catch (IOException e) {
                log.log(Level.FINEST, "Error detecting paths script", e);
            }
            ++n2;
        }
        return Format.properties;
    }

    protected Map<String, Object> loadFromPropertyStrings(List<String> settings) {
        for (String propString : settings) {
            int idx_eq = propString.indexOf(61);
            String key = propString.substring(0, idx_eq).trim();
            String valStr = propString.substring(idx_eq + 1);
            if (valStr != null) {
                valStr = valStr.trim();
            }
            Object val = valStr;
            if (key.matches(".*\\[[LISBlisb]\\]$")) {
                char c = key.charAt(key.length() - 2);
                key = key.substring(0, key.length() - 3);
                if (val != null) {
                    val = DataTypes.decodeValueType(c, valStr);
                }
            }
            this.props.put(key, val);
        }
        return this.props;
    }

    protected void convertFromOldFormat() throws ConfigReader.ConfigException {
        String plugins;
        String statsHistory;
        String statsArchiv;
        String monitoring;
        String maxQueueSize;
        String trusted;
        HashMap toAdd = new HashMap();
        ArrayList toRemove = new ArrayList();
        HashMap<String, Map> dataSources = new HashMap<String, Map>();
        Pattern commandsPattern = Pattern.compile("^([^\\/]+)\\/command\\/(.+)$");
        Pattern processorsPattern = Pattern.compile("^([^\\/]+)\\/processors\\/(.+)$");
        if (this.props.containsKey("--auth-domain-repo-pool")) {
            throw new ConfigReader.ConfigException("Cannot convert property --auth-domain-repo-pool!\nPlease check if provided class is compatible with Tigase XMPP Server data sources. If so, then please remove this property, convert the configuration file and then manually modify configuration.");
        }
        if (this.props.containsKey("--user-domain-repo-pool")) {
            throw new ConfigReader.ConfigException("Cannot convert property --user-domain-repo-pool!\nPlease check if provided class is compatible with Tigase XMPP Server data sources. If so, then please remove this property, convert the configuration file and then manually modify configuration.");
        }
        Object defDataPoolSize = this.props.remove("--data-repo-pool-size");
        Object defAuthRepoPool = this.props.remove("--auth-repo-pool-size");
        this.props.forEach((k, v) -> {
            Map authParams;
            Map ds;
            String prop;
            String[] tmp;
            int idx;
            String t;
            Matcher m;
            if (k.equals("config-type")) {
                switch ((String)v) {
                    case "--gen-config-all": 
                    case "--gen-config-def": 
                    case "--gen-config-default": {
                        toAdd.put(k, "default");
                        break;
                    }
                    case "--gen-config-sm": {
                        toAdd.put(k, "session-manager");
                        break;
                    }
                    case "--gen-config-cs": {
                        toAdd.put(k, "connection-managers");
                        break;
                    }
                    case "--gen-config-comp": {
                        toAdd.put(k, "component");
                        break;
                    }
                }
            }
            if (k.startsWith("--comp-name")) {
                String suffix = k.replace("--comp-name-", "");
                String name = ((String)v).trim();
                String cls = ((String)this.props.get("--comp-class-" + suffix)).trim();
                String active = "true";
                toAdd.put(name + "/class", cls);
                toAdd.put(name + "/active", active);
                if ("tigase.http.HttpMessageReceiver".equals(cls)) {
                    this.props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(name + "/http/")).forEach(e -> {
                        String key = ((String)e.getKey()).replace(name + "/http/", "");
                        Map httpServerCfg = (Map)toAdd.computeIfAbsent("httpServer", k1 -> new HashMap());
                        if (key.equals("server-class")) {
                            httpServerCfg.put("class", e.getValue());
                            toRemove.add(e.getKey());
                        } else if (key.equals("ports")) {
                            Map connections = (Map)httpServerCfg.computeIfAbsent("connections", k1 -> new HashMap());
                            for (int port : (int[])e.getValue()) {
                                connections.compute(String.valueOf(port), (k1, v1) -> {
                                    if (v1 == null) {
                                        v1 = new HashMap();
                                    }
                                    ((Map)v1).put("active", true);
                                    return v1;
                                });
                            }
                            if (!Arrays.stream((int[])e.getValue()).filter(v1 -> v1 == 8080).findAny().isPresent()) {
                                connections.compute(String.valueOf(8080), (k1, v1) -> {
                                    if (v1 == null) {
                                        v1 = new HashMap();
                                    }
                                    ((Map)v1).put("active", true);
                                    return v1;
                                });
                            }
                            toRemove.add(e.getKey());
                        } else if (key.endsWith("/socket") || key.endsWith("/domain")) {
                            Map connections = (Map)httpServerCfg.computeIfAbsent("connections", k1 -> new HashMap());
                            String[] parts = key.split("/");
                            String port = parts[0];
                            Map portCfg = (Map)connections.computeIfAbsent(port, k1 -> new HashMap());
                            portCfg.put(parts[1], e.getValue());
                            toRemove.add(e.getKey());
                        } else {
                            httpServerCfg.put(key, e.getValue());
                            toRemove.add(e.getKey());
                        }
                    });
                }
            }
            if (k.startsWith("--user-db") || k.startsWith("--auth-db") || k.startsWith("--amp-repo")) {
                String domain = "default";
                if (k.endsWith("]")) {
                    domain = k.substring(k.indexOf(91) + 1, k.length() - 1);
                }
                toRemove.add(k);
                Map ds2 = dataSources.computeIfAbsent(domain, key -> new HashMap());
                if (k.startsWith("--user-db-uri")) {
                    ds2.put("user-uri", (String)v);
                } else if (k.startsWith("--user-db")) {
                    ds2.put("user-type", (String)v);
                }
                if (k.startsWith("--auth-db-uri")) {
                    ds2.put("auth-uri", (String)v);
                } else if (k.startsWith("--auth-db")) {
                    ds2.put("auth-type", (String)v);
                }
                if (k.startsWith("--amp-repo-uri")) {
                    ds2.put("amp-uri", (String)v);
                } else if (k.startsWith("--amp-repo-class")) {
                    ds2.put("amp-type", (String)v);
                }
            }
            if (k.equals("--sm-cluster-strategy-class")) {
                toAdd.put("sess-man/strategy/class", v.toString());
                toAdd.put("sess-man/strategy/active", "true");
                toRemove.add(k);
            }
            if (k.contains("pubsub-repo-url")) {
                this.props.put("dataSource/pubsub/uri", v);
                this.props.put("dataSource/pubsub/active", "true");
                this.props.put("pubsub/dao/default/data-source", "pubsub");
                toRemove.add(k);
            }
            if (k.startsWith("sess-man/plugins-conf/")) {
                if (k.equals("sess-man/plugins-conf/dynamic-roster-classes")) {
                    toAdd.put("sess-man/dynamic-rosters/active", "true");
                    this.stringToStreamOfStrings(v.toString()).forEach(clazzName -> {
                        String[] parts = clazzName.split("\\.");
                        toAdd.put("sess-man/dynamic-rosters/" + parts[parts.length - 1] + "/active", "true");
                        toAdd.put("sess-man/dynamic-rosters/" + parts[parts.length - 1] + "/class", clazzName);
                    });
                    toRemove.add(k);
                } else {
                    toRemove.add(k);
                    k = k.replace("/plugins-conf/", "/");
                    if (k.endsWith("/amp/msg-offline")) {
                        toAdd.put(k.replace("/msg-offline", "/msgoffline/active"), v);
                    } else if (k.endsWith("/presence-state/disable-roster-lazy-loading")) {
                        k = k.replace("/disable-roster-lazy-loading", "/enable-roster-lazy-loading");
                        if ("true".equals(v)) {
                            toAdd.put(k, false);
                        } else {
                            toAdd.put(k, true);
                        }
                    } else if (k.equals("/presence-state/extended-presence-processors")) {
                        String k12 = k.replace("presence-state/extended-presence-processors", "");
                        String prefix = k;
                        this.stringToStreamOfStrings(v.toString()).forEach(ext -> {
                            String[] parts = ext.split(".");
                            toAdd.put(prefix + "/" + parts[parts.length - 1] + "/class", ext);
                            toAdd.put(prefix + "/" + parts[parts.length - 1] + "/active", true);
                        });
                    } else {
                        toAdd.put(k, v);
                    }
                }
            }
            if (k.startsWith("stats/stats-archiv/")) {
                toRemove.add(k);
                toAdd.put(k.replace("stats/stats-archiv/", "stats/"), v);
            }
            if (k.contains("/command/") && (m = commandsPattern.matcher((CharSequence)k)).matches()) {
                String cmp = m.group(1);
                String cmdId = m.group(2).replace("\\:", ":");
                Map acls = (Map)toAdd.computeIfAbsent(cmp + "/commands", k1 -> new HashMap());
                List values = this.stringToStreamOfStrings(v.toString()).map(x -> {
                    int idx = x.indexOf(58);
                    if (idx > 0) {
                        return x.substring(idx + 1);
                    }
                    return x;
                }).collect(Collectors.toList());
                acls.put(cmdId, values.size() > 1 ? values : values.get(0));
                toRemove.add(k);
            }
            if (k.equals("--sm-threads-pool")) {
                this.props.put("sess-man/sm-threads-pool", v);
            }
            if (k.endsWith("/processors")) {
                String cmp = k.replace("/processors", "");
                Arrays.stream((String[])v).forEach(procId -> {
                    toAdd.compute(cmp, (k1, v1) -> {
                        if (v1 == null) {
                            v1 = new HashMap();
                        }
                        ((Map)v1).compute(procId, (k2, v2) -> {
                            if (v2 == null) {
                                v2 = new HashMap();
                            }
                            ((Map)v2).put("active", true);
                            return v2;
                        });
                        return v1;
                    });
                    toAdd.put(cmp + "/" + procId + "/active", true);
                });
                toRemove.add(k);
            }
            if (k.contains("/processors/")) {
                m = processorsPattern.matcher((CharSequence)k);
                if (m.matches()) {
                    String cmp = m.group(1);
                    String key2 = m.group(2).replace("\\:", ":");
                    String[] parts = key2.split("/");
                    Map cmpCfg = (Map)toAdd.computeIfAbsent(cmp, k1 -> new HashMap());
                    Map procCfg = (Map)cmpCfg.computeIfAbsent(parts[0], k1 -> new HashMap());
                    procCfg.put(parts[1], v);
                }
                toRemove.add(k);
            }
            if (k.startsWith("basic-conf/logging/") && (t = k.replace("basic-conf/logging/", "")).contains(".") && (idx = t.lastIndexOf(46)) > 0) {
                String group = t.substring(0, idx);
                String key3 = t.substring(idx + 1);
                Map logging = (Map)toAdd.computeIfAbsent("logging", k1 -> new HashMap());
                Map handler = (Map)logging.computeIfAbsent(group, k1 -> new HashMap());
                handler.put(key3, v);
                toRemove.add(k);
            }
            if (k.startsWith("basic-conf/user-repo-params/")) {
                tmp = k.replace("basic-conf/user-repo-params/", "").split("/");
                String domain = "default";
                prop = null;
                if (tmp.length == 1) {
                    prop = tmp[0];
                } else {
                    domain = tmp[0];
                    prop = tmp[1];
                }
                ds = dataSources.computeIfAbsent(domain, key -> new HashMap());
                authParams = (Map)ds.computeIfAbsent("user-params", x -> new HashMap());
                authParams.put(prop, v.toString());
                toRemove.add(k);
            }
            if (k.startsWith("basic-conf/auth-repo-params/")) {
                tmp = k.replace("basic-conf/auth-repo-params/", "").split("/");
                String domain = "default";
                prop = null;
                if (tmp.length == 1) {
                    prop = tmp[0];
                } else {
                    domain = tmp[0];
                    prop = tmp[1];
                }
                ds = dataSources.computeIfAbsent(domain, key -> new HashMap());
                authParams = (Map)ds.computeIfAbsent("auth-params", x -> new HashMap());
                authParams.put(prop, v.toString());
                toRemove.add(k);
            }
        });
        dataSources.forEach((domain, cfg) -> {
            String cls;
            String userType = (String)cfg.get("user-type");
            String userUri = (String)cfg.get("user-uri");
            String authType = (String)cfg.get("auth-type");
            String authUri = (String)cfg.get("auth-uri");
            String ampUri = (String)cfg.get("amp-uri");
            String ampType = (String)cfg.get("amp-type");
            Map authParams = (Map)cfg.get("auth-params");
            Map userParams = (Map)cfg.get("user-params");
            String sourcePrefix = "dataSource/" + domain + "/";
            String authPrefix = "authRepository/" + domain + "/";
            String userPrefix = "userRepository/" + domain + "/";
            if (userUri != null) {
                this.props.put("dataSource/" + domain + "/uri", userUri);
                this.props.put("dataSource/" + domain + "/active", "true");
                if (defDataPoolSize != null) {
                    this.props.put(sourcePrefix + "pool-size", defDataPoolSize);
                }
                this.props.put("userRepository/" + domain + "/active", "true");
                this.props.put("authRepository/" + domain + "/active", "true");
            }
            if (!(authUri == null || userUri != null && userUri.contains(authUri))) {
                this.props.put("dataSource/" + domain + "-auth/uri", authUri);
                this.props.put("dataSource/" + domain + "-auth/active", "true");
                if (defDataPoolSize != null) {
                    this.props.put("dataSource/" + domain + "-auth/pool-size", defDataPoolSize);
                }
                this.props.put("authRepository/" + domain + "/data-source", domain + "-auth");
                this.props.put("authRepository/" + domain + "/active", "true");
            }
            if (!(ampUri == null || userUri != null && userUri.equals(ampUri))) {
                this.props.put("dataSource/" + domain + "-amp/uri", ampUri);
                this.props.put("dataSource/" + domain + "-amp/active", "true");
                this.props.put("msgRepository/" + domain + "/data-source", domain + "-amp");
                this.props.put("msgRepository/" + domain + "/active", "true");
            }
            if (!(userType == null || userType.equals("mysql") || userType.equals("pgsql") || userType.equals("derby") || userType.equals("sqlserver"))) {
                cls = RepositoryFactory.getRepoClass(userType);
                this.props.put("userRepository/" + domain + "/cls", cls);
            }
            if (authType != null && !authType.equals("tigase-custom-auth")) {
                cls = RepositoryFactory.getRepoClass(authType);
                this.props.put("authRepository/" + domain + "/cls", cls);
            }
            if (ampType != null) {
                this.props.put("msgRepository/" + domain + "/cls", ampType);
            }
            if (authParams != null) {
                authParams.forEach((k, v) -> {
                    if (k.equals("auth-repo-class")) {
                        this.props.put(authPrefix + "/cls", v);
                    } else if (k.equals("auth-repo-pool")) {
                        this.props.put(authPrefix + "/pool-class", v);
                    } else if (k.equals("auth-repo-pool-size")) {
                        this.props.put(authPrefix + "/pool-size", v);
                    } else {
                        this.props.put(authPrefix + k, v);
                    }
                });
            }
            if (userParams != null) {
                userParams.forEach((k, v) -> {
                    if (k.equals("user-repo-class")) {
                        this.props.put(userPrefix + "/cls", v);
                    } else if (k.equals("user-repo-pool")) {
                        this.props.put(userPrefix + "/pool-class", v);
                    } else if (k.equals("user-repo-pool-size")) {
                        this.props.put(userPrefix + "/pool-size", v);
                    } else {
                        this.props.put(userPrefix + k, v);
                    }
                });
            }
            if (defAuthRepoPool != null) {
                this.props.putIfAbsent(authPrefix + "/pool-size", defAuthRepoPool);
            }
        });
        String external = (String)this.props.remove("--external");
        if (external != null) {
            Optional<String> extCmpName = toAdd.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("/class") && e.getValue().equals(ComponentProtocol.class.getCanonicalName())).map(e -> ((String)e.getKey()).replace("/class", "")).findFirst();
            extCmpName.ifPresent(cmpName -> {
                String[] components = external.split(",");
                OldConfigHolder.saveOldExternalComponentConfigItems(components);
            });
            ConfigHolder.renameIfExists(this.props, "--bind-ext-hostnames", "bind-ext-hostnames", value -> this.stringToListOfStrings(value.toString()));
        } else {
            this.props.remove("--bind-ext-hostnames");
        }
        String admins = (String)this.props.remove("--admins");
        if (admins != null) {
            this.props.put("admins", this.stringToListOfStrings(admins));
        }
        if ((trusted = (String)this.props.remove("--trusted")) != null) {
            this.props.put("trusted", this.stringToListOfStrings(trusted));
        }
        if ((maxQueueSize = (String)this.props.remove("--max-queue-size")) != null) {
            this.props.put("max-queue-size", Integer.valueOf(maxQueueSize.trim()));
        }
        if ((monitoring = (String)this.props.remove("--monitoring")) != null) {
            this.props.put("monitoring/active", "true");
            this.stringToStreamOfStrings(monitoring).forEach(e -> {
                String[] tmp = e.split(":");
                if (tmp.length == 2) {
                    this.props.put("monitoring/" + tmp[0] + "/active", "true");
                    this.props.put("monitoring/" + tmp[0] + "/port", tmp[1]);
                }
            });
        }
        if ((statsArchiv = (String)this.props.remove("--stats-archiv")) != null) {
            this.stringToStreamOfStrings(statsArchiv).forEach(archiver -> {
                String[] parts = archiver.split(":");
                String k = "stats/" + parts[1];
                this.props.put(k + "/class", parts[0]);
                this.props.put(k + "/active", "true");
                if (parts.length > 2) {
                    this.props.put(k + "/frequency", parts[2]);
                }
                if ("tigase.mongo.stats.CounterDataLoggerMongo".equals(parts[1]) || "tigase.stats.CounterDataLogger".equals(parts[1])) {
                    this.props.putIfAbsent(k + "/db-url", this.props.get("dataSource/default/uri"));
                }
            });
        }
        if ((statsHistory = (String)this.props.remove("--stats-history")) != null) {
            String[] parts = statsHistory.split(",");
            this.props.putIfAbsent("stats/stats-history-size", parts[0]);
            if (parts.length > 1) {
                this.props.putIfAbsent("stats/stats-update-interval", parts[1]);
            }
        }
        Iterator<Map.Entry<String, Object>> it = this.props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e2 = it.next();
            if (!((String)e2.getKey()).startsWith("--comp-")) continue;
            it.remove();
        }
        for (String k2 : toRemove) {
            this.props.remove(k2);
        }
        this.props.putAll(toAdd);
        if (!"connection-managers".equals(this.props.get("config-type")) && !"component".equals(this.props.get("config-type"))) {
            this.props.put("sess-man/active", "true");
        }
        if ((plugins = (String)this.props.remove("--sm-plugins")) != null) {
            Set knownProcessors = ClassUtilBean.getInstance().getAllClasses().stream().filter(cls -> XMPPProcessor.class.isAssignableFrom((Class<?>)cls) && !Modifier.isAbstract(cls.getModifiers()) && !Modifier.isInterface(cls.getModifiers())).map(cls -> {
                try {
                    return (XMPPProcessor)cls.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.log(Level.WARNING, "Failed to instanticate");
                    return null;
                }
            }).collect(Collectors.toSet());
            HashMap plugins_concurrency = new HashMap();
            this.stringToStreamOfStrings(plugins).forEach(part -> {
                String[] tmp = part.split("=");
                String name = tmp[0].charAt(0) == '+' || tmp[0].charAt(0) == '-' ? tmp[0].substring(1) : tmp[0];
                boolean active = !tmp[0].startsWith("-");
                this.props.put("sess-man/" + name + "/active", String.valueOf(active));
                if (tmp.length > 1) {
                    plugins_concurrency.put(name, tmp[1]);
                }
                try {
                    XMPPImplIfc proc = knownProcessors.stream().filter(p -> p != null && name.equals(p.id())).findFirst().orElse(null);
                    if (proc != null) {
                        Bean ann = proc.getClass().getAnnotation(Bean.class);
                        if (ann == null) {
                            this.props.put("sess-man/" + name + "/class", proc.getClass().getCanonicalName());
                        }
                    } else {
                        log.log(Level.WARNING, "could not find class for processor " + name);
                    }
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "not able to get instance of processor " + name, ex);
                }
            });
            String concurrency = (String)this.props.get("plugins-concurrency");
            if (concurrency != null) {
                this.stringToStreamOfStrings(concurrency).forEach(part -> {
                    String[] tmp = part.split("=");
                    plugins_concurrency.put(tmp[0], tmp[1]);
                });
            }
            for (Map.Entry e3 : plugins_concurrency.entrySet()) {
                String prefix = "sess-man/" + (String)e3.getKey() + "/";
                String[] tmp = ((String)e3.getValue()).split(":");
                try {
                    this.props.put(prefix + "threadsNo", Integer.parseInt(tmp[0]));
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Plugin " + (String)e3.getKey() + " concurrency parsing error for: " + tmp[0], ex);
                }
                if (tmp.length <= 1) continue;
                try {
                    this.props.put(prefix + "queueSize", Integer.parseInt(tmp[1]));
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Plugin " + (String)e3.getKey() + " queueSize parsing error for: " + tmp[1], ex);
                }
            }
        }
    }

    public static void saveOldExternalComponentConfigItems(String[] components) {
        File f = new File("etc/externalComponentItems");
        if (f.exists()) {
            f.delete();
        }
        try (FileWriter writer = new FileWriter(f);){
            for (int i = 0; i < components.length; ++i) {
                if (i > 0) {
                    writer.write(10);
                }
                writer.write(components[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void logOutput(String msg, Object ... args) {
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, msg, args);
        }
        if (args.length > 0) {
            this.output.add(MessageFormat.format(msg, args));
        } else {
            this.output.add(msg);
        }
    }

    private void loadFromPropertyFiles() throws ConfigReader.ConfigException {
        LinkedList<String> settings = new LinkedList<String>();
        for (Path path : this.propertyFileNames) {
            ConfiguratorAbstract.loadFromPropertiesFiles(path.toString(), this.props, settings);
            this.loadFromPropertyStrings(settings);
        }
    }

    private Stream<String> stringToStreamOfStrings(String val) {
        return Arrays.stream(val.split(",")).map(String::trim);
    }

    private List<String> stringToListOfStrings(String val) {
        return this.stringToStreamOfStrings(val).collect(Collectors.toList());
    }

    public static enum Format {
        dsl,
        properties;

    }
}

