/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.repo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.cluster.repo.ClConConfigRepository;
import tigase.cluster.repo.ClusterRepoConstants;
import tigase.cluster.repo.ClusterRepoItem;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.RepositoryFactory;
import tigase.db.comp.ComponentRepositoryDataSourceAware;
import tigase.db.util.RepositoryVersionAware;
import tigase.sys.TigaseRuntime;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
public class ClConSQLRepository
extends ClConConfigRepository
implements ClusterRepoConstants,
ComponentRepositoryDataSourceAware<ClusterRepoItem, DataRepository>,
RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(ClConSQLRepository.class.getName());
    private static final String GET_ITEM_QUERY = "select hostname, secondary, password, last_update, port, cpu_usage, mem_usage from tig_cluster_nodes where hostname = ?";
    private static final String GET_ALL_ITEMS_QUERY = "select hostname, secondary, password, last_update, port, cpu_usage, mem_usage from tig_cluster_nodes";
    private static final String DELETE_ITEM_QUERY = "delete from tig_cluster_nodes where (hostname = ?)";
    private static final String INSERT_ITEM_QUERY = "insert into tig_cluster_nodes (hostname, secondary, password, last_update, port, cpu_usage, mem_usage)  (select ?, ?, ?, ?, ?, ?, ? from tig_cluster_nodes WHERE hostname=? HAVING count(*)=0)";
    private static final String UPDATE_ITEM_QUERY = "update tig_cluster_nodes set hostname= ?, secondary= ?, password= ?, last_update = ?,port= ?, cpu_usage= ?, mem_usage= ?  where hostname= ?";
    private DataRepository data_repo = null;

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put("repo-uri", repo_uri);
    }

    @Override
    public void setDataSource(DataRepository data_repo) {
        try {
            this.checkDB(data_repo);
            data_repo.initPreparedStatement(GET_ITEM_QUERY, GET_ITEM_QUERY);
            data_repo.initPreparedStatement(GET_ALL_ITEMS_QUERY, GET_ALL_ITEMS_QUERY);
            data_repo.initPreparedStatement(INSERT_ITEM_QUERY, INSERT_ITEM_QUERY);
            data_repo.initPreparedStatement(UPDATE_ITEM_QUERY, UPDATE_ITEM_QUERY);
            data_repo.initPreparedStatement(DELETE_ITEM_QUERY, DELETE_ITEM_QUERY);
            this.data_repo = data_repo;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem initializing database: ", e);
        }
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public void initRepository(String conn_str, Map<String, String> params) throws DBInitException {
        super.initRepository(conn_str, params);
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, params);
            this.data_repo.checkSchemaVersion(this, true);
            this.setDataSource(this.data_repo);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem initializing database: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(String key) {
        super.removeItem(key);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing item form database: {0}", key);
        }
        try {
            PreparedStatement removeItem;
            PreparedStatement preparedStatement = removeItem = this.data_repo.getPreparedStatement(null, DELETE_ITEM_QUERY);
            synchronized (preparedStatement) {
                removeItem.setString(1, key);
                removeItem.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem removing elements from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeItem(ClusterRepoItem item) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Storing item to repository: {0}", item);
        }
        try {
            PreparedStatement updateItemSt = this.data_repo.getPreparedStatement(null, UPDATE_ITEM_QUERY);
            PreparedStatement insertItemSt = this.data_repo.getPreparedStatement(null, INSERT_ITEM_QUERY);
            Date date = new Date();
            PreparedStatement preparedStatement = updateItemSt;
            synchronized (preparedStatement) {
                updateItemSt.setString(1, item.getHostname());
                updateItemSt.setString(2, item.getSecondaryHostname());
                updateItemSt.setString(3, item.getPassword());
                this.data_repo.setTimestamp(updateItemSt, 4, new Timestamp(date.getTime()));
                updateItemSt.setInt(5, item.getPortNo());
                updateItemSt.setFloat(6, item.getCpuUsage());
                updateItemSt.setFloat(7, item.getMemUsage());
                updateItemSt.setString(8, item.getHostname());
                updateItemSt.executeUpdate();
            }
            preparedStatement = insertItemSt;
            synchronized (preparedStatement) {
                insertItemSt.setString(1, item.getHostname());
                insertItemSt.setString(2, item.getSecondaryHostname());
                insertItemSt.setString(3, item.getPassword());
                this.data_repo.setTimestamp(insertItemSt, 4, new Timestamp(date.getTime()));
                insertItemSt.setInt(5, item.getPortNo());
                insertItemSt.setFloat(6, item.getCpuUsage());
                insertItemSt.setFloat(7, item.getMemUsage());
                insertItemSt.setString(8, item.getHostname());
                insertItemSt.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Reloading items");
        }
        if (System.currentTimeMillis() - this.lastReloadTime <= this.autoReloadInterval * this.lastReloadTimeFactor) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Last reload performed in {0}, skipping: ", System.currentTimeMillis() - this.lastReloadTime);
            }
            return;
        }
        this.lastReloadTime = System.currentTimeMillis();
        super.reload();
        try {
            PreparedStatement getAllItemsSt;
            ResultSet rs = null;
            PreparedStatement preparedStatement = getAllItemsSt = this.data_repo.getPreparedStatement(null, GET_ALL_ITEMS_QUERY);
            synchronized (preparedStatement) {
                try {
                    rs = getAllItemsSt.executeQuery();
                    while (rs.next()) {
                        ClusterRepoItem item = this.getItemInstance();
                        item.setHostname(rs.getString("hostname"));
                        item.setSecondaryHostname(rs.getString("secondary"));
                        item.setPassword(rs.getString("password"));
                        item.setLastUpdate(this.data_repo.getTimestamp(rs, "last_update").getTime());
                        item.setPort(rs.getInt("port"));
                        item.setCpuUsage(rs.getFloat("cpu_usage"));
                        item.setMemUsage(rs.getFloat("mem_usage"));
                        this.itemLoaded(item);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
        if (this.auto_remove_obsolete_items) {
            this.removeObsoloteItems(5000L);
        }
    }

    @Override
    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
    }

    @Override
    public void store() {
    }

    private void checkDB(DataRepository data_repo) throws SQLException {
        if (!data_repo.checkTable("tig_cluster_nodes")) {
            log.info("DB for external component is not OK, stopping server...");
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"ERROR! Terminating the server process.", "Problem initializing the server: missing tig_cluster_nodes table on " + data_repo.getResourceUri(), "Please fix the problem and start the server again."}, 1);
        }
    }
}

