/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Optional;
import tigase.cert.CertificateUtil;

public class CertificateEntry {
    private Certificate[] chain = null;
    private PrivateKey privateKey = null;

    public Certificate[] getCertChain() {
        return this.chain;
    }

    public void setCertChain(Certificate[] chain) {
        this.chain = chain;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean basic) {
        StringBuilder sb = new StringBuilder(4096);
        for (Certificate cert : this.chain) {
            if (basic) {
                CertificateUtil.getCertificateBasicInfo(sb, cert);
                continue;
            }
            sb.append(cert.toString());
        }
        return "Private key: " + (this.privateKey != null ? this.privateKey.toString() : "private key missing!!! \n\n\n") + '\n' + sb;
    }

    public Optional<Certificate> getCertificate() {
        return this.chain != null && this.chain.length > 0 ? Optional.of(this.chain[0]) : Optional.empty();
    }
}

