/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.Map;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.Logic;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="logic", parent=PubSubComponent.class, active=true)
public class DefaultPubSubLogic
implements Logic {
    @Inject
    private PubSubConfig pubSubConfig;
    @Inject
    private IPubSubRepository repository;

    @Override
    public void checkAccessPermission(BareJID serviceJid, String nodeName, JID senderJid) throws PubSubException, RepositoryException {
        this.checkAccessPermission(serviceJid, this.repository.getNodeConfig(serviceJid, nodeName), this.repository.getNodeAffiliations(serviceJid, nodeName), this.repository.getNodeSubscriptions(serviceJid, nodeName), senderJid);
    }

    @Override
    public void checkAccessPermission(BareJID serviceJid, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodeSubscriptions, JID senderJid) throws PubSubException, RepositoryException {
        boolean allowed;
        if (nodeConfig == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (this.pubSubConfig.isAdmin(senderJid)) {
            return;
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.open && !Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains())) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
        if (senderAffiliation.getAffiliation() == Affiliation.outcast) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        Subscription senderSubscription = nodeSubscriptions.getSubscription(senderJid.getBareJID());
        if (nodeConfig.getNodeAccessModel() == AccessModel.whitelist && !senderAffiliation.getAffiliation().isRetrieveItem()) {
            throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
        }
        if (!(nodeConfig.getNodeAccessModel() != AccessModel.authorize || senderSubscription == Subscription.subscribed && senderAffiliation.getAffiliation().isRetrieveItem())) {
            throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_SUBSCRIBED);
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.presence) {
            boolean allowed2 = this.hasSenderSubscription(senderJid.getBareJID(), nodeAffiliations, nodeSubscriptions);
            if (!allowed2) {
                throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
            }
        } else if (nodeConfig.getNodeAccessModel() == AccessModel.roster && !(allowed = this.isSenderInRosterGroup(senderJid.getBareJID(), nodeConfig, nodeAffiliations, nodeSubscriptions))) {
            throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
        }
    }

    @Override
    public Element prepareNotificationMessage(JID from, JID to, String id, Element itemToSend, Map<String, String> headers) {
        Element message = new Element("message", new String[]{"xmlns", "from", "to", "id"}, new String[]{"jabber:client", from.toString(), to.toString(), id});
        Element event = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
        event.addChild((XMLNodeIfc)itemToSend);
        String expireAttr = itemToSend.getAttributeStaticStr(new String[]{"items", "item"}, "expire-at");
        if (expireAttr != null) {
            Element amp = new Element("amp");
            amp.setXMLNS("http://jabber.org/protocol/amp");
            amp.addChild((XMLNodeIfc)new Element("rule", new String[]{"condition", "action", "value"}, new String[]{"expire-at", "drop", expireAttr}));
            message.addChild((XMLNodeIfc)amp);
        }
        message.addChild((XMLNodeIfc)event);
        if (headers != null && headers.size() > 0) {
            Element headElem = new Element("headers", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/shim"});
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                Element h = new Element("header", entry.getValue(), new String[]{"name"}, new String[]{entry.getKey()});
                headElem.addChild((XMLNodeIfc)h);
            }
            message.addChild((XMLNodeIfc)headElem);
        }
        return message;
    }

    @Override
    public boolean hasSenderSubscription(BareJID bareJid, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        for (UsersAffiliation affiliation : affiliations.getAffiliations()) {
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals((Object)affiliation.getJid())) {
                return true;
            }
            Map<BareJID, RosterElement> buddies = this.repository.getUserRoster(affiliation.getJid());
            RosterElement re = buddies.get(bareJid);
            if (re == null || re.getSubscription() != RosterAbstract.SubscriptionType.both && re.getSubscription() != RosterAbstract.SubscriptionType.from && re.getSubscription() != RosterAbstract.SubscriptionType.from_pending_out) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSenderInRosterGroup(BareJID bareJid, AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        UsersSubscription[] subscribers = subscriptions.getSubscriptions();
        String[] groupsAllowed = nodeConfig.getRosterGroupsAllowed();
        if (groupsAllowed == null || groupsAllowed.length == 0) {
            return true;
        }
        for (UsersSubscription owner : subscribers) {
            UsersAffiliation affiliation = affiliations.getSubscriberAffiliation(owner.getJid());
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals((Object)owner)) {
                return true;
            }
            Map<BareJID, RosterElement> buddies = this.repository.getUserRoster(owner.getJid());
            RosterElement re = buddies.get(bareJid);
            if (re == null || re.getGroups() == null) continue;
            for (String group : groupsAllowed) {
                if (!Utils.contain(group, groupsAllowed)) continue;
                return true;
            }
        }
        return false;
    }

    protected PubSubConfig getPubSubConfig() {
        return this.pubSubConfig;
    }

    protected IPubSubRepository getRepository() {
        return this.repository;
    }
}

