/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Bean(name="disco", parent=PubSubComponent.class, active=true)
public class DiscoveryModule
extends tigase.component.modules.impl.DiscoveryModule {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    @Inject
    private PubSubConfig config;
    @Inject
    private IPubSubRepository repository;
    private static final String[] EMPTY_NODES = new String[0];

    public DiscoveryModule() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node == null) {
            super.processDiscoInfo(packet, jid, node, senderJID);
        } else {
            boolean allowed;
            AbstractNodeConfig nodeConfigClone;
            JID senderJid = packet.getStanzaFrom();
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            INodeMeta nodeMeta = this.repository.getNodeMeta(packet.getStanzaTo().getBareJID(), node);
            if (nodeMeta == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            try {
                nodeConfigClone = nodeMeta.getNodeConfig().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RepositoryException("Exception retrieving node configuration", (Throwable)ex);
            }
            boolean bl = allowed = senderJid == null || nodeConfigClone == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfigClone.getDomains());
            if (!allowed) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", nodeConfigClone.getNodeType().name()}));
            resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
            Form form = nodeConfigClone.getForm();
            form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#meta-data"));
            ArrayList<String> owners = new ArrayList<String>();
            ArrayList<String> publishers = new ArrayList<String>();
            IAffiliations affiliations = this.repository.getNodeAffiliations(packet.getStanzaTo().getBareJID(), node);
            block9: for (UsersAffiliation affiliation : affiliations.getAffiliations()) {
                if (affiliation.getAffiliation() == null) continue;
                switch (affiliation.getAffiliation()) {
                    case owner: {
                        owners.add(affiliation.getJid().toString());
                        continue block9;
                    }
                    case publisher: {
                        publishers.add(affiliation.getJid().toString());
                        continue block9;
                    }
                }
            }
            form.addField(Field.fieldJidMulti((String)"pubsub#owner", (String[])owners.toArray(new String[owners.size()]), (String)"Node owners"));
            form.addField(Field.fieldJidMulti((String)"pubsub#publisher", (String[])publishers.toArray(new String[publishers.size()]), (String)"Publishers to this node"));
            BareJID creator = nodeMeta.getCreator();
            String creationDateStr = "";
            if (nodeMeta.getCreationTime() != null) {
                SimpleDateFormat simpleDateFormat = this.formatter;
                synchronized (simpleDateFormat) {
                    creationDateStr = this.formatter.format(nodeMeta.getCreationTime());
                }
            }
            form.addField(Field.fieldJidSingle((String)"pubsub#creator", (String)(creator != null ? creator.toString() : ""), (String)"Node creator"));
            form.addField(Field.fieldTextSingle((String)"pubsub#creation_date", (String)creationDateStr, (String)"Creation date"));
            resultQuery.addChild((XMLNodeIfc)form.getElement());
            this.write(resultIq);
        }
    }

    protected void processDiscoItems(Packet packet, JID jid, String nodeName, JID senderJID) throws ComponentException, RepositoryException {
        AbstractNodeConfig nodeConfig;
        this.log.finest("Asking about Items of node " + nodeName);
        JID senderJid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        Element element = packet.getElement();
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
        Packet resultIq = packet.okResult(resultQuery, 0);
        AbstractNodeConfig abstractNodeConfig = nodeConfig = nodeName == null ? null : this.repository.getNodeConfig(toJid.getBareJID(), nodeName);
        if (nodeName != null && nodeConfig == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        Element rsmEl = element.getChildStaticStr("query", "http://jabber.org/protocol/disco#items").getChildStaticStr("set", "http://jabber.org/protocol/rsm");
        RSM rsm = null;
        if (rsmEl != null) {
            rsm = RSM.parseRootElement((Element)element.getChild("query"));
        }
        if (nodeName == null || nodeConfig != null && nodeConfig.getNodeType() == NodeType.collection) {
            String[] nodes;
            String parentName;
            if (nodeName == null) {
                parentName = "";
                try {
                    nodes = this.repository.getRootCollection(toJid.getBareJID());
                }
                catch (CachedPubSubRepository.RootCollectionSet.IllegalStateException e) {
                    throw new PubSubException(Authorization.RESOURCE_CONSTRAINT);
                }
            } else {
                parentName = nodeName;
                nodes = this.repository.getChildNodes(toJid.getBareJID(), nodeName);
            }
            if (nodes != null) {
                int count = nodes.length;
                int index = 0;
                boolean inverted = false;
                if (nodes.length > 0 && rsm != null) {
                    String[] originalNodes = nodes;
                    if ((nodes = this.prefilterNodesWithRSM(nodes, rsm)).length > 0 && originalNodes.length > nodes.length) {
                        for (int i = 0; i < originalNodes.length; ++i) {
                            if (!originalNodes[i].equals(nodes[0])) continue;
                            index = i;
                            break;
                        }
                    }
                    if (inverted = rsm.hasBefore()) {
                        List<String> tmp = Arrays.asList(nodes);
                        Collections.reverse(tmp);
                        nodes = tmp.toArray(new String[tmp.size()]);
                    }
                }
                ArrayList<Element> results = new ArrayList<Element>();
                for (String node : nodes) {
                    boolean allowed;
                    AbstractNodeConfig childNodeConfig = this.repository.getNodeConfig(toJid.getBareJID(), node);
                    if (childNodeConfig == null) continue;
                    boolean bl = allowed = senderJid == null || childNodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), childNodeConfig.getDomains());
                    if (allowed) {
                        String name = childNodeConfig.getTitle();
                        name = name == null || name.length() == 0 ? node : name;
                        Element item = new Element("item", new String[]{"jid", "node", "name"}, new String[]{element.getAttributeStaticStr("to"), node, name});
                        results.add(item);
                        if (rsm == null || results.size() < rsm.getMax()) continue;
                        break;
                    }
                    this.log.fine("User " + senderJid + " not allowed to see node '" + node + "'");
                }
                if (inverted) {
                    index = nodes.length - results.size();
                    Collections.reverse(results);
                }
                if (rsm != null && !results.isEmpty()) {
                    rsm.setResults(Integer.valueOf(count), ((Element)results.get(0)).getAttributeStaticStr("node"), ((Element)results.get(results.size() - 1)).getAttributeStaticStr("node"));
                    rsm.setIndex(Integer.valueOf(index));
                    resultQuery.addChildren(results);
                    resultQuery.addChild((XMLNodeIfc)rsm.toElement());
                } else {
                    resultQuery.addChildren(results);
                }
            }
        } else {
            boolean allowed;
            boolean bl = allowed = senderJid == null || nodeConfig == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains());
            if (!allowed) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            resultQuery.addAttribute("node", nodeName);
            IItems items = this.repository.getNodeItems(toJid.getBareJID(), nodeName);
            String[] itemsId = items.getItemsIds();
            if (itemsId != null) {
                for (String itemId : itemsId) {
                    resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{element.getAttributeStaticStr("to"), itemId}));
                }
            }
        }
        this.write(resultIq);
    }

    protected String[] prefilterNodesWithRSM(String[] nodes, RSM rsm) throws PubSubException {
        Integer start = null;
        if (rsm.getAfter() != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].equals(rsm.getAfter())) continue;
                start = i + 1;
                break;
            }
            if (start == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
        } else if (rsm.getIndex() != null) {
            start = rsm.getIndex();
        }
        Integer stop = null;
        if (rsm.getBefore() != null) {
            for (int i = nodes.length - 1; i >= 0; --i) {
                if (!nodes[i].equals(rsm.getBefore())) continue;
                stop = i;
                break;
            }
            if (stop == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
        }
        if (start == null) {
            start = 0;
        }
        if (stop == null) {
            stop = nodes.length;
        }
        if (start <= stop) {
            return Arrays.copyOfRange(nodes, (int)start, (int)stop);
        }
        return EMPTY_NODES;
    }

    protected Packet prepareDiscoInfoResponse(Packet packet, JID jid, String node, JID senderJID) {
        Element query;
        Packet result = super.prepareDiscoInfoResponse(packet, jid, node, senderJID);
        if (node == null && jid.getLocalpart() != null && this.config.isPepPeristent() && (query = result.getElement().getChild("query", "http://jabber.org/protocol/disco#info")) != null) {
            Stream.of("http://jabber.org/protocol/pubsub#auto-create", "http://jabber.org/protocol/pubsub#auto-subscribe").map(feature -> new Element("feature", new String[]{"var"}, new String[]{feature})).forEach(arg_0 -> ((Element)query).addChild(arg_0));
        }
        return result;
    }
}

