/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Arrays;
import java.util.HashSet;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.PresenceCapabilitiesManager;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="capsModule", parent=PubSubComponent.class, active=true)
public class CapsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = new Or(new Criteria[]{ElementCriteria.nameType((String)"iq", (String)"result").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info")), ElementCriteria.nameType((String)"iq", (String)"error").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"))});
    private static String[] FEATURES = new String[0];
    @Inject
    private EventBus eventBus;

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        PresenceCapabilitiesManager.processCapsQueryResponse((Packet)packet);
        if (packet.getType() == StanzaType.result) {
            String[] features;
            String node;
            String id = packet.getAttributeStaticStr("id");
            if (id == null) {
                return;
            }
            BareJID serviceJid = id.contains("@") ? BareJID.bareJIDInstance((String)id) : packet.getStanzaTo().getBareJID();
            Element query = packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info");
            if (query != null && (node = query.getAttributeStaticStr("node")) != null && (features = PresenceCapabilitiesManager.getNodeFeatures((String)node)) != null) {
                this.eventBus.fire((Object)new PresenceCollectorModule.CapsChangeEvent(serviceJid, packet.getStanzaFrom(), new String[]{node}, EMPTY_FEATURES, new HashSet<String>(Arrays.asList(features))));
            }
        }
    }

    public String[] processPresence(Packet packet) {
        Object[] caps = null;
        Element c = packet.getElement().getChildStaticStr("c");
        if (c != null) {
            JID jid = packet.getStanzaFrom();
            caps = PresenceCapabilitiesManager.processPresence((Element)c);
            if (caps != null) {
                Arrays.sort(caps);
                JID pubSubJid = packet.getStanzaTo();
                if (pubSubJid.getLocalpart() != null) {
                    String compName = this.config.getComponentJID().getLocalpart();
                    pubSubJid = JID.jidInstanceNS((String)(compName + "." + pubSubJid.getDomain()));
                }
                for (Object node : caps) {
                    if (PresenceCapabilitiesManager.getNodeFeatures((String)node) != null) continue;
                    Packet p = PresenceCapabilitiesManager.prepareCapsQuery((JID)jid, (JID)pubSubJid, (String)node);
                    p.getElement().setAttribute("id", packet.getStanzaTo().getBareJID().toString());
                    this.packetWriter.write(p);
                }
            }
        }
        return caps;
    }
}

