/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.processors;

import java.util.Map;
import java.util.Queue;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.JID;

@Id(value="unified-archive")
@Handles(value={@Handle(path={"iq", "query"}, xmlns="urn:xmpp:tigase:recent")})
@Bean(name="unified-archive", parent=SessionManager.class, active=false)
public class UnifiedArchivePlugin
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc {
    protected static final String ID = "unified-archive";
    @ConfigField(desc="Unified Archive component JID", alias="component-jid")
    private JID componentJid = JID.jidInstanceNS((String)"unified-archive", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
    @Inject
    protected MessageArchivePlugin messageArchivePlugin;

    public void setMessageArchivePlugin(MessageArchivePlugin messageArchivePlugin) {
        this.messageArchivePlugin = messageArchivePlugin;
        if (this.messageArchivePlugin != null && this.componentJid != null) {
            messageArchivePlugin.setComponentJid(this.componentJid);
        }
    }

    public void setComponentJid(JID componentJid) {
        this.componentJid = componentJid;
        if (this.messageArchivePlugin != null && this.componentJid != null) {
            this.messageArchivePlugin.setComponentJid(componentJid);
        }
    }

    public String id() {
        return ID;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> results, Map<String, Object> map) throws XMPPException {
        if (this.messageArchivePlugin.getComponentJid().equals((Object)packet.getPacketFrom())) {
            JID jID = session.getConnectionId(packet.getStanzaTo());
            Packet packet2 = packet.copyElementOnly();
            packet2.setPacketTo(jID);
            results.offer(packet2);
            return;
        }
        Packet packet3 = packet.copyElementOnly();
        packet3.setPacketFrom(session.getJID().copyWithoutResource());
        packet3.setPacketTo(this.componentJid);
        results.offer(packet3);
    }
}

