/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.archive.db.JDBCMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.unified.QueryCriteria;
import tigase.archive.unified.db.UnifiedArchiveRepository;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="unified-archive", name="Tigase Unified Archive Component")
public class JDBCUnifiedArchiveRepository
extends JDBCMessageArchiveRepository<QueryCriteria>
implements UnifiedArchiveRepository<DataRepository>,
RepositoryVersionAware {
    protected static final String OFFLINE_STORE_KEY = "offline-store";
    private static final Logger a = Logger.getLogger(JDBCUnifiedArchiveRepository.class.getCanonicalName());
    private static final String b = "{ call Tig_UA_GetItems(?,?,?,?,?,?,?,?,?,?) }";
    private static final String c = "{ call Tig_UA_GetItemsCount(?,?,?,?,?,?,?,?) }";
    private static final String d = "{ call Tig_UA_GetItemPosition(?,?,?,?,?,?,?,?,?) }";
    private static final String e = "{ call Tig_UA_GetCollections(?,?,?,?,?,?,?,?,?,?,?) }";
    private static final String f = "{ call Tig_UA_GetCollectionsCount(?,?,?,?,?,?,?,?,?) }";
    private static final String g = "{ call Tig_UA_AddItem(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
    private static final String h = "{ call Tig_UA_QueryRecent(?,?,?,?,?,?,?,?,?,?,?) }";
    private static final String i = "{ call Tig_UA_QueryRecentCount(?,?,?,?,?,?,?,?,?) }";

    public JDBCUnifiedArchiveRepository() {
        this.GET_MESSAGES_QUERY = b;
        this.GET_MESSAGES_COUNT_QUERY = c;
        this.GET_MESSAGE_POSITION_QUERY = d;
        this.GET_COLLECTIONS_QUERY = e;
        this.GET_COLLECTIONS_COUNT_QUERY = f;
        this.ADD_MESSAGE_QUERY = g;
    }

    public void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags) {
        Element element2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = msg.getAttributeStaticStr("item-type");
        if (string == null) {
            string = msg.getName() == "presence" ? "presence" : "chat";
        }
        msg.removeAttribute("item-type");
        hashMap.put("item-type", string);
        if ("call".equals(string)) {
            msg.setName("iq");
        }
        boolean bl = false;
        String string2 = msg.getAttributeStaticStr("tigase-offline");
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        msg.removeAttribute("tigase-offline");
        hashMap.put("tigase-offline", bl);
        boolean bl2 = false;
        String string3 = msg.getAttributeStaticStr("tigase-offline-only");
        if (string3 != null) {
            bl2 = Boolean.parseBoolean(string3);
        }
        msg.removeAttribute("tigase-offline-only");
        hashMap.put("tigase-offline-only", bl2);
        if (msg.getName() == "iq" && (element2 = msg.getChild("jingle")) != null) {
            Element element3;
            hashMap.put("jingle-sid", element2.getAttributeStaticStr("sid"));
            hashMap.put("jingle-action", element2.getAttributeStaticStr("action"));
            Element element4 = element2.getChild("reason");
            String string4 = null;
            if (element4 != null && (element3 = element4.findChild(element -> element.getName() != "text")) != null) {
                string4 = element3.getName();
            }
            hashMap.put("jingle-reason", string4);
        }
        this.archiveMessage(owner, buddy, direction, timestamp, msg, tags, hashMap);
    }

    public QueryCriteria newQuery() {
        return new QueryCriteria();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<? extends UnifiedArchiveRepository.Item> queryRecents(BareJID ownerJid, Date start, Date end, Set<UnifiedArchiveRepository.Type> types, Set<UnifiedArchiveRepository.CallCondition> callConditions, RSM rsm) throws TigaseDBException {
        PreparedStatement preparedStatement;
        rsm.setCount(Integer.valueOf(this.queryRecentsCount(ownerJid, start, end, types, callConditions)));
        int n = 0;
        if (rsm.getIndex() != null) {
            n = rsm.getIndex();
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = preparedStatement = this.getDataRepository().getPreparedStatement(ownerJid, h);
        synchronized (preparedStatement2) {
            Object object;
            try {
                int n2 = 1;
                preparedStatement.setString(n2++, ownerJid.toString());
                if (start != null) {
                    this.data_repo.setTimestamp(preparedStatement, n2++, new Timestamp(start.getTime()));
                } else {
                    preparedStatement.setNull(n2++, 93);
                }
                if (end != null) {
                    this.data_repo.setTimestamp(preparedStatement, n2++, new Timestamp(end.getTime()));
                } else {
                    preparedStatement.setNull(n2++, 93);
                }
                preparedStatement.setShort(n2++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.chat) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.groupchat) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.call) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.success) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.missed) ? 1 : 0));
                preparedStatement.setShort(n2++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.canceled) ? 1 : 0));
                preparedStatement.setInt(n2++, rsm.getMax());
                preparedStatement.setInt(n2++, n);
                resultSet = preparedStatement.executeQuery();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (resultSet.next()) {
                    object = new RecentItem(this.data_repo, resultSet);
                    arrayList.add(object);
                }
                if (!arrayList.isEmpty()) {
                    rsm.setResults(rsm.getCount(), ((UnifiedArchiveRepository.Item)arrayList.get(0)).getId(), ((UnifiedArchiveRepository.Item)arrayList.get(arrayList.size() - 1)).getId());
                    rsm.setIndex(Integer.valueOf(n));
                }
                object = arrayList.stream();
            }
            catch (Throwable throwable) {
                try {
                    this.getDataRepository().release(null, resultSet);
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw new TigaseDBException("Failed to retrieve list of recent items", (Throwable)sQLException);
                }
            }
            this.getDataRepository().release(null, resultSet);
            return object;
        }
    }

    protected int addMessageAdditionalInfo(PreparedStatement stmt, int i, Map<String, Object> additionalData) throws SQLException {
        stmt.setString(i++, (String)additionalData.get("item-type"));
        if (((Boolean)additionalData.get("tigase-offline")).booleanValue()) {
            stmt.setShort(i++, (short)((Boolean)additionalData.get("tigase-offline-only") != false ? 2 : 1));
        } else {
            stmt.setShort(i++, (short)0);
        }
        stmt.setString(i++, (String)additionalData.get("jingle-sid"));
        stmt.setString(i++, (String)additionalData.get("jingle-action"));
        stmt.setString(i++, (String)additionalData.get("jingle-reason"));
        stmt.setShort(i++, (short)((Boolean)additionalData.get("tigase-offline") != false ? 1 : 0));
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int queryRecentsCount(BareJID ownerJid, Date start, Date end, Set<UnifiedArchiveRepository.Type> types, Set<UnifiedArchiveRepository.CallCondition> callConditions) throws SQLException {
        PreparedStatement preparedStatement;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = preparedStatement = this.getDataRepository().getPreparedStatement(ownerJid, i);
        synchronized (preparedStatement2) {
            block9: {
                int n2;
                try {
                    int n = 1;
                    preparedStatement.setString(n++, ownerJid.toString());
                    if (start != null) {
                        this.data_repo.setTimestamp(preparedStatement, n++, new Timestamp(start.getTime()));
                    } else {
                        preparedStatement.setNull(n++, 93);
                    }
                    if (end != null) {
                        this.data_repo.setTimestamp(preparedStatement, n++, new Timestamp(end.getTime()));
                    } else {
                        preparedStatement.setNull(n++, 93);
                    }
                    preparedStatement.setShort(n++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.chat) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.groupchat) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(types.contains((Object)UnifiedArchiveRepository.Type.call) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.success) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.missed) ? 1 : 0));
                    preparedStatement.setShort(n++, (short)(callConditions.contains((Object)UnifiedArchiveRepository.CallCondition.canceled) ? 1 : 0));
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    n2 = resultSet.getInt(1);
                }
                catch (Throwable throwable) {
                    this.getDataRepository().release(null, resultSet);
                    throw throwable;
                }
                this.getDataRepository().release(null, resultSet);
                return n2;
            }
            int n = 0;
            this.getDataRepository().release(null, resultSet);
            return n;
        }
    }

    protected void initPreparedStatements(DataRepository data_repo) throws SQLException {
        super.initPreparedStatements(data_repo);
        data_repo.initPreparedStatement(h, h);
        data_repo.initPreparedStatement(i, i);
    }

    protected Item newItemInstance() {
        return new Item();
    }

    protected int setQueryParams(PreparedStatement stmt, QueryCriteria crit, Boolean groupByType, int i) throws SQLException {
        int n = super.setQueryParams(stmt, (tigase.archive.QueryCriteria)crit, groupByType, i);
        if (crit.getItemType() != null) {
            stmt.setString(n++, crit.getItemType());
        } else {
            stmt.setObject(n++, null);
        }
        if (crit.getOffline() != null) {
            stmt.setShort(n++, (short)(crit.getOffline() != false ? 1 : 0));
        } else {
            stmt.setObject(n++, null);
        }
        return n;
    }

    protected DataRepository getDataRepository() {
        return this.data_repo;
    }

    protected byte[] generateHashOfMessage(MessageArchiveRepository.Direction direction, Element msg, Date ts, Map<String, Object> additionalData) {
        try {
            String string;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            String string2 = string = direction == MessageArchiveRepository.Direction.incoming ? msg.getAttributeStaticStr("from") : msg.getAttributeStaticStr("to");
            if (string != null) {
                messageDigest.update(string.getBytes());
            }
            String string3 = msg.getAttributeStaticStr("type");
            Element element = msg.getChild("subject");
            String string4 = msg.getChildCData(MSG_SUBJECT_PATH);
            String string5 = msg.getAttributeStaticStr("id");
            if (string5 != null) {
                if (!"groupchat".equals(string3) || element == null) {
                    messageDigest.update(string5.getBytes());
                } else {
                    messageDigest.update(":".getBytes());
                    messageDigest.update(new Long(ts.getTime() / 60000L).toString().getBytes());
                }
            }
            if (string3 == null || !"groupchat".equals(string3)) {
                messageDigest.update(":".getBytes());
                messageDigest.update(new Long(ts.getTime() / 1000L).toString().getBytes());
            }
            messageDigest.update(":".getBytes());
            messageDigest.update(((String)additionalData.get("item-type")).getBytes());
            messageDigest.update(":".getBytes());
            String string6 = msg.getChildCData(MSG_BODY_PATH);
            if (string6 != null) {
                messageDigest.update(string6.getBytes());
            }
            if (string4 != null) {
                messageDigest.update(string4.getBytes());
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static class RecentItem
    implements UnifiedArchiveRepository.Item {
        private static final SimpleParser a = SingletonFactory.getParserInstance();
        private final String b;
        private final MessageArchiveRepository.Direction c;
        private final Long d;
        private final String e;
        private final Element f;
        private final String g;
        private final Timestamp h;
        private final String i;

        protected RecentItem(DataRepository repo, ResultSet rs) throws SQLException {
            this.i = rs.getString(1);
            this.h = repo.getTimestamp(rs, 2);
            this.c = MessageArchiveRepository.Direction.getDirection((short)rs.getShort(3));
            String string = rs.getString(4);
            this.e = rs.getString(5);
            this.b = rs.getString(6);
            DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
            a.parse((SimpleHandler)domBuilderHandler, string.toCharArray(), 0, string.length());
            this.f = (Element)domBuilderHandler.getParsedElements().poll();
            this.g = rs.getString(7);
            this.d = rs.getLong(8);
        }

        public String getId() {
            return this.g;
        }

        public Element getMessage() {
            return this.f;
        }

        public Date getTimestamp() {
            return this.h;
        }

        public MessageArchiveRepository.Direction getDirection() {
            return this.c;
        }

        public String getWith() {
            return this.i;
        }

        @Override
        public String getItemType() {
            return this.e;
        }

        @Override
        public Long getDuration() {
            return this.d;
        }

        @Override
        public String getCondition() {
            return this.b;
        }
    }

    protected static class Item
    extends JDBCMessageArchiveRepository.Item<QueryCriteria>
    implements UnifiedArchiveRepository.Item {
        private String a = null;

        protected Item() {
        }

        @Override
        public String getItemType() {
            return this.a;
        }

        @Override
        public Long getDuration() {
            return null;
        }

        @Override
        public String getCondition() {
            return null;
        }

        protected int read(DataRepository repo, ResultSet rs, QueryCriteria crit) throws SQLException {
            int n = super.read(repo, rs, (tigase.archive.QueryCriteria)crit);
            if (!crit.hasItemType()) {
                this.a = rs.getString(n++);
            }
            return n;
        }
    }
}

