/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.archive.QueryCriteria;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.component.exceptions.ComponentException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Base64;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.rsm.RSM;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"}, isDefault=true)
@Repository.SchemaId(id="message-archiving", name="Tigase Message Archiving Component")
public class JDBCMessageArchiveRepository<Q extends QueryCriteria>
extends AbstractMessageArchiveRepository<Q, DataRepository>
implements RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(JDBCMessageArchiveRepository.class.getCanonicalName());
    private static final long LONG_NULL = 0L;
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final String STORE_PLAINTEXT_BODY_KEY = "store-plaintext-body";
    private static final String GROUP_BY_TYPE_KEY = "group-by-chat-type";
    private static final String DELETE_EXPIRED_QUERY_TIMEOUT_KEY = "remove-expired-messages-query-timeout";
    private static final int DEF_DELETE_EXPIRED_QUERY_TIMEOUT_VAL = 300;
    private static final String DEF_GET_MESSAGES_QUERY = "{ call Tig_MA_GetMessages(?,?,?,?,?,?,?,?) }";
    private static final String DEF_GET_MESSAGES_COUNT_QUERY = "{ call Tig_MA_GetMessagesCount(?,?,?,?,?,?) }";
    private static final String DEF_GET_MESSAGES_POSITION_QUERY = "{ call Tig_MA_GetMessagePosition(?,?,?,?,?,?,?) }";
    private static final String DEF_GET_COLLECTIONS_QUERY = "{ call Tig_MA_GetCollections(?,?,?,?,?,?,?,?,?) }";
    private static final String DEF_GET_COLLECTIONS_COUNT_QUERY = "{ call Tig_MA_GetCollectionsCount(?,?,?,?,?,?,?) }";
    private static final String DEF_ADD_MESSAGE_QUERY = "{ call Tig_MA_AddMessage(?,?,?,?,?,?,?,?,?) }";
    private static final String DEF_ADD_TAG_TO_MESSAGE_QUERY = "{ call Tig_MA_AddTagToMessage(?,?) }";
    private static final String DEF_REMOVE_MESSAGES_QUERY = "{ call Tig_MA_RemoveMessages(?,?,?,?) }";
    private static final String DEF_DELETE_EXPIRED_MESSAGES_QUERY = "{ call Tig_MA_DeleteExpiredMessages(?,?) }";
    private static final String DEF_GET_TAGS_FOR_USER_QUERY = "{ call Tig_MA_GetTagsForUser(?,?,?,?) }";
    private static final String DEF_GET_TAGS_FOR_USER_COUNT_QUERY = "{ call Tig_MA_GetTagsForUserCount(?,?) }";
    @ConfigField(desc="Query to add message to store", alias="add-message-query")
    protected String ADD_MESSAGE_QUERY = "{ call Tig_MA_AddMessage(?,?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to add tag to message in store", alias="add-tag-to-message-query")
    protected String ADD_TAG_TO_MESSAGE_QUERY = "{ call Tig_MA_AddTagToMessage(?,?) }";
    @ConfigField(desc="Query to delete expired messages", alias="delete-expired-messages-query")
    protected String DELETE_EXPIRED_MESSAGES_QUERY = "{ call Tig_MA_DeleteExpiredMessages(?,?) }";
    @ConfigField(desc="Query to retrieve number of collections", alias="get-collections-count-query")
    protected String GET_COLLECTIONS_COUNT_QUERY = "{ call Tig_MA_GetCollectionsCount(?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to retrieve list of collections", alias="get-collections-query")
    protected String GET_COLLECTIONS_QUERY = "{ call Tig_MA_GetCollections(?,?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to retrieve number of messages", alias="get-messages-count-query")
    protected String GET_MESSAGES_COUNT_QUERY = "{ call Tig_MA_GetMessagesCount(?,?,?,?,?,?) }";
    @ConfigField(desc="Query to retrieve list of messages", alias="get-messages-query")
    protected String GET_MESSAGES_QUERY = "{ call Tig_MA_GetMessages(?,?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to retrieve message possition", alias="get-message-position-query")
    protected String GET_MESSAGE_POSITION_QUERY = "{ call Tig_MA_GetMessagePosition(?,?,?,?,?,?,?) }";
    @ConfigField(desc="Query to retrieve number of tags used by user", alias="get-tags-for-user-count-query")
    protected String GET_TAGS_FOR_USER_COUNT_QUERY = "{ call Tig_MA_GetTagsForUserCount(?,?) }";
    @ConfigField(desc="Query to retrieve tags used by user", alias="get-tags-for-user-query")
    protected String GET_TAGS_FOR_USER_QUERY = "{ call Tig_MA_GetTagsForUser(?,?,?,?) }";
    @ConfigField(desc="Query to remove messages", alias="remove-messages-query")
    protected String REMOVE_MESSAGES_QUERY = "{ call Tig_MA_RemoveMessages(?,?,?,?) }";
    protected DataRepository data_repo = null;
    @ConfigField(desc="Delete expired messages statement query timeout", alias="remove-expired-messages-query-timeout")
    private int delete_expired_timeout = 300;
    @ConfigField(desc="Group collections by stanza type", alias="group-by-chat-type")
    private boolean groupByType = false;
    @ConfigField(desc="Store plaintext body in separate field", alias="store-plaintext-body")
    private boolean storePlaintextBody = true;

    public void setDataSource(DataRepository data_repo) {
        try {
            this.initPreparedStatements(data_repo);
            this.data_repo = data_repo;
        }
        catch (SQLException ex) {
            throw new RuntimeException("MessageArchiveDB initialization exception", ex);
        }
    }

    @Override
    @TigaseDeprecated(since="2.1.0", removeIn="3.0.0", note="New version of this method will be introduced in 3.0.0")
    @Deprecated
    public void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags) {
        this.archiveMessage(owner, buddy, direction, timestamp, msg, tags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteExpiredMessages(BareJID owner, LocalDateTime before) throws TigaseDBException {
        try {
            PreparedStatement delete_expired_msgs_st = this.data_repo.getPreparedStatement(owner, this.DELETE_EXPIRED_MESSAGES_QUERY);
            long timestamp_long = before.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            Timestamp ts = new Timestamp(timestamp_long);
            PreparedStatement preparedStatement = delete_expired_msgs_st;
            synchronized (preparedStatement) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "executing removal of expired messages for domain {0} with timeout set to {1} seconds", new Object[]{owner, this.delete_expired_timeout});
                }
                delete_expired_msgs_st.setQueryTimeout(this.delete_expired_timeout);
                delete_expired_msgs_st.setString(1, owner.toString());
                this.data_repo.setTimestamp(delete_expired_msgs_st, 2, ts);
                delete_expired_msgs_st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not remove expired messages", (Throwable)ex);
        }
    }

    @Override
    public void queryCollections(Q crit, MessageArchiveRepository.CollectionHandler<Q> collectionHandler) throws TigaseDBException {
        try {
            Integer count = this.getCollectionsCount(crit);
            if (count == null) {
                count = 0;
            }
            Integer after = this.getColletionPosition(crit.getRsm().getAfter(), crit);
            Integer before = this.getColletionPosition(crit.getRsm().getBefore(), crit);
            this.calculateOffsetAndPosition(crit, count, before, after);
            this.getCollectionsItems(crit, collectionHandler);
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve collections", (Throwable)ex);
        }
    }

    public void queryItems(Q crit, MAMRepository.ItemHandler<Q, MAMRepository.Item> itemHandler) throws TigaseDBException, ComponentException {
        try {
            Integer count = this.getItemsCount(crit);
            if (count == null) {
                count = 0;
            }
            Integer after = this.getItemPosition(crit.getRsm().getAfter(), crit);
            Integer before = this.getItemPosition(crit.getRsm().getBefore(), crit);
            this.calculateOffsetAndPosition(crit, count, before, after);
            this.getItemsItems(crit, itemHandler);
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItems(BareJID owner, String withJid, Date start, Date end) throws TigaseDBException {
        try {
            PreparedStatement remove_msgs_st;
            PreparedStatement preparedStatement = remove_msgs_st = this.data_repo.getPreparedStatement(owner, this.REMOVE_MESSAGES_QUERY);
            synchronized (preparedStatement) {
                PreparedStatement preparedStatement2 = remove_msgs_st;
                synchronized (preparedStatement2) {
                    remove_msgs_st.setString(1, owner.toString());
                    remove_msgs_st.setString(2, withJid);
                    this.data_repo.setTimestamp(remove_msgs_st, 3, start == null ? null : new Timestamp(start.getTime()));
                    this.data_repo.setTimestamp(remove_msgs_st, 4, end == null ? null : new Timestamp(end.getTime()));
                    remove_msgs_st.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not remove items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTags(BareJID owner, String startsWith, Q crit) throws TigaseDBException {
        ArrayList<String> results = new ArrayList<String>();
        try {
            PreparedStatement get_tags_st;
            PreparedStatement get_tags_count_st;
            ResultSet rs = null;
            int count = 0;
            startsWith = startsWith + "%";
            PreparedStatement preparedStatement = get_tags_count_st = this.data_repo.getPreparedStatement(owner, this.GET_TAGS_FOR_USER_COUNT_QUERY);
            synchronized (preparedStatement) {
                try {
                    get_tags_count_st.setString(1, owner.toString());
                    get_tags_count_st.setString(2, startsWith);
                    rs = get_tags_count_st.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
            String beforeStr = crit.getRsm().getBefore();
            String afterStr = crit.getRsm().getAfter();
            this.calculateOffsetAndPosition(crit, count, beforeStr == null ? null : Integer.valueOf(Integer.parseInt(beforeStr)), afterStr == null ? null : Integer.valueOf(Integer.parseInt(afterStr)));
            PreparedStatement preparedStatement2 = get_tags_st = this.data_repo.getPreparedStatement(owner, this.GET_TAGS_FOR_USER_QUERY);
            synchronized (preparedStatement2) {
                try {
                    int i = 1;
                    get_tags_st.setString(i++, owner.toString());
                    get_tags_st.setString(i++, startsWith);
                    get_tags_st.setInt(i++, crit.getRsm().getMax());
                    get_tags_st.setInt(i++, crit.getRsm().getIndex());
                    rs = get_tags_st.executeQuery();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
            RSM rsm = crit.getRsm();
            rsm.setResults(Integer.valueOf(count), rsm.getIndex());
            if (results != null && !results.isEmpty()) {
                rsm.setFirst(String.valueOf(rsm.getIndex()));
                rsm.setLast(String.valueOf(rsm.getIndex() + (results.size() - 1)));
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not retrieve known tags from database", (Throwable)ex);
        }
        return results;
    }

    public void setItemsQueryParams(PreparedStatement stmt, String ownerJid, Q crit, Boolean groupByType) throws SQLException {
        stmt.setString(1, ownerJid);
        int i = this.setQueryParams(stmt, crit, groupByType, 2);
        stmt.setInt(i++, crit.getRsm().getMax());
        stmt.setInt(i++, crit.getRsm().getIndex());
    }

    public Q newQuery() {
        return (Q)new QueryCriteria();
    }

    protected void initPreparedStatements(DataRepository data_repo) throws SQLException {
        data_repo.initPreparedStatement(this.GET_MESSAGES_QUERY, this.GET_MESSAGES_QUERY);
        data_repo.initPreparedStatement(this.GET_MESSAGES_COUNT_QUERY, this.GET_MESSAGES_COUNT_QUERY);
        data_repo.initPreparedStatement(this.GET_MESSAGE_POSITION_QUERY, this.GET_MESSAGE_POSITION_QUERY);
        data_repo.initPreparedStatement(this.GET_COLLECTIONS_QUERY, this.GET_COLLECTIONS_QUERY);
        data_repo.initPreparedStatement(this.GET_COLLECTIONS_COUNT_QUERY, this.GET_COLLECTIONS_COUNT_QUERY);
        data_repo.initPreparedStatement(this.ADD_MESSAGE_QUERY, this.ADD_MESSAGE_QUERY);
        data_repo.initPreparedStatement(this.ADD_TAG_TO_MESSAGE_QUERY, this.ADD_TAG_TO_MESSAGE_QUERY);
        data_repo.initPreparedStatement(this.REMOVE_MESSAGES_QUERY, this.REMOVE_MESSAGES_QUERY);
        data_repo.initPreparedStatement(this.DELETE_EXPIRED_MESSAGES_QUERY, this.DELETE_EXPIRED_MESSAGES_QUERY);
        data_repo.initPreparedStatement(this.GET_TAGS_FOR_USER_QUERY, this.GET_TAGS_FOR_USER_QUERY);
        data_repo.initPreparedStatement(this.GET_TAGS_FOR_USER_COUNT_QUERY, this.GET_TAGS_FOR_USER_COUNT_QUERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set<String> tags, Map<String, Object> additionalData) {
        try {
            ResultSet rs = null;
            Timestamp mtime = new Timestamp(timestamp.getTime());
            msg.addAttribute("time", String.valueOf(mtime.getTime()));
            String type = msg.getAttributeStaticStr("type");
            String msgStr = msg.toString();
            String body = this.storePlaintextBody ? msg.getChildCData(MSG_BODY_PATH) : null;
            String hash = this.generateHashOfMessageAsString(direction, msg, mtime, additionalData);
            PreparedStatement add_message_st = this.data_repo.getPreparedStatement(owner, this.ADD_MESSAGE_QUERY);
            Long msgId = null;
            PreparedStatement preparedStatement = add_message_st;
            synchronized (preparedStatement) {
                try {
                    int i = 1;
                    add_message_st.setString(i++, owner.toString());
                    add_message_st.setString(i++, buddy.getBareJID().toString());
                    add_message_st.setString(i++, buddy.getResource());
                    this.data_repo.setTimestamp(add_message_st, i++, mtime);
                    add_message_st.setShort(i++, direction.getValue());
                    add_message_st.setString(i++, type);
                    add_message_st.setString(i++, body);
                    add_message_st.setString(i++, msgStr);
                    add_message_st.setString(i++, hash);
                    i = this.addMessageAdditionalInfo(add_message_st, i, additionalData);
                    rs = add_message_st.executeQuery();
                    if (rs.next()) {
                        msgId = rs.getLong(1);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
            if (msgId == null || msgId == 0L) {
                return msgId;
            }
            if (tags != null && !tags.isEmpty()) {
                PreparedStatement add_message_tag_st;
                PreparedStatement preparedStatement2 = add_message_tag_st = this.data_repo.getPreparedStatement(owner, this.ADD_TAG_TO_MESSAGE_QUERY);
                synchronized (preparedStatement2) {
                    for (String tag : tags) {
                        add_message_tag_st.setLong(1, msgId);
                        add_message_tag_st.setString(2, tag);
                        add_message_tag_st.addBatch();
                    }
                    add_message_tag_st.executeBatch();
                }
            }
            return msgId;
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 1366 || ex.getMessage() != null && ex.getMessage().startsWith("Incorrect string value")) {
                log.log(Level.WARNING, "Your MySQL configuration can't handle extended Unicode (for example emoji) correctly. Please refer to <Support for emoji and other icons> section of the server documentation");
            } else {
                log.log(Level.WARNING, "Problem adding new entry to DB: " + msg, ex);
            }
            return null;
        }
    }

    protected int addMessageAdditionalInfo(PreparedStatement stmt, int i, Map<String, Object> additionalData) throws SQLException {
        return i;
    }

    protected Timestamp convertToTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    protected int setCountQueryParams(PreparedStatement stmt, String ownerJid, Q crit, Boolean groupByType) throws SQLException {
        stmt.setString(1, ownerJid);
        return this.setQueryParams(stmt, crit, groupByType, 2);
    }

    protected int setQueryParams(PreparedStatement stmt, Q crit, Boolean groupByType, int i) throws SQLException {
        StringBuilder sb;
        if (crit.getWith() != null) {
            stmt.setString(i++, crit.getWith().getBareJID().toString());
        } else {
            stmt.setObject(i++, null);
        }
        if (crit.getStart() != null) {
            this.data_repo.setTimestamp(stmt, i++, this.convertToTimestamp(crit.getStart()));
        } else {
            stmt.setObject(i++, null);
        }
        if (crit.getEnd() != null) {
            this.data_repo.setTimestamp(stmt, i++, this.convertToTimestamp(crit.getEnd()));
        } else {
            stmt.setObject(i++, null);
        }
        if (((QueryCriteria)crit).getTags().isEmpty()) {
            stmt.setObject(i++, null);
        } else {
            sb = new StringBuilder();
            for (String tag : ((QueryCriteria)crit).getTags()) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append('\'').append(tag.replace("'", "''")).append("'");
            }
            stmt.setString(i++, sb.toString());
        }
        if (((QueryCriteria)crit).getContains().isEmpty()) {
            stmt.setObject(i++, null);
        } else {
            sb = new StringBuilder();
            for (String contain : ((QueryCriteria)crit).getContains()) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append("'%").append(contain.replace("'", "''")).append("%'");
            }
            stmt.setString(i++, sb.toString());
        }
        if (groupByType != null) {
            stmt.setShort(i++, (short)(groupByType != false ? 1 : 0));
        }
        return i;
    }

    protected Item newItemInstance() {
        return new Item();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollectionsItems(Q crit, MessageArchiveRepository.CollectionHandler<Q> collectionHandler) throws SQLException {
        ResultSet selectRs = null;
        BareJID owner = crit.getQuestionerJID().getBareJID();
        PreparedStatement get_collections_st = this.data_repo.getPreparedStatement(owner, this.GET_COLLECTIONS_QUERY);
        int i = 2;
        PreparedStatement preparedStatement = get_collections_st;
        synchronized (preparedStatement) {
            try {
                this.setItemsQueryParams(get_collections_st, owner.toString(), crit, this.groupByType);
                selectRs = get_collections_st.executeQuery();
                while (selectRs.next()) {
                    Timestamp startTs = this.data_repo.getTimestamp(selectRs, 1);
                    String with = selectRs.getString(2);
                    String type = selectRs.getString(3);
                    collectionHandler.collectionFound(crit, with, startTs, type);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, selectRs);
                throw throwable;
            }
            this.data_repo.release(null, selectRs);
        }
        List<Element> collections = ((QueryCriteria)crit).getCollections();
        if (collections != null) {
            int first = crit.getRsm().getIndex();
            crit.getRsm().setFirst(String.valueOf(first));
            crit.getRsm().setLast(String.valueOf(first + collections.size() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCollectionsCount(Q crit) throws SQLException {
        PreparedStatement get_collections_count;
        ResultSet countRs = null;
        Integer count = null;
        BareJID owner = crit.getQuestionerJID().getBareJID();
        PreparedStatement preparedStatement = get_collections_count = this.data_repo.getPreparedStatement(owner, this.GET_COLLECTIONS_COUNT_QUERY);
        synchronized (preparedStatement) {
            try {
                this.setCountQueryParams(get_collections_count, owner.toString(), crit, this.groupByType);
                countRs = get_collections_count.executeQuery();
                if (countRs.next()) {
                    count = countRs.getInt(1);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, countRs);
                throw throwable;
            }
            this.data_repo.release(null, countRs);
        }
        return count;
    }

    private Integer getColletionPosition(String uid, Q query) {
        if (uid == null || uid.isEmpty()) {
            return null;
        }
        return Integer.parseInt(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getItemsItems(Q crit, MAMRepository.ItemHandler<Q, MAMRepository.Item> itemHandler) throws SQLException {
        PreparedStatement get_messages_st;
        ResultSet rs = null;
        ArrayDeque<Item> results = new ArrayDeque<Item>();
        BareJID owner = crit.getQuestionerJID().getBareJID();
        PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, this.GET_MESSAGES_QUERY);
        synchronized (preparedStatement) {
            try {
                this.setItemsQueryParams(get_messages_st, owner.toString(), crit, null);
                rs = get_messages_st.executeQuery();
                while (rs.next()) {
                    Item item = this.newItemInstance();
                    item.read(this.data_repo, rs, crit);
                    results.offer(item);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
        }
        if (!results.isEmpty()) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            Date startTimestamp = crit.getStart();
            Item item = null;
            int idx = crit.getRsm().getIndex();
            int i = 0;
            while ((item = (Item)results.poll()) != null) {
                if (startTimestamp == null) {
                    startTimestamp = item.timestamp;
                }
                parser.parse((SimpleHandler)domHandler, item.messageStr.toCharArray(), 0, item.messageStr.length());
                Queue queue = domHandler.getParsedElements();
                Object msg = null;
                item.messageStr = null;
                item.messageEl = (Element)queue.poll();
                if (!((QueryCriteria)crit).getUseMessageIdInRsm()) {
                    item.id = String.valueOf(idx + i);
                }
                itemHandler.itemFound(crit, (MAMRepository.Item)item);
                queue.clear();
                ++i;
            }
            crit.setStart(startTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getItemsCount(Q crit) throws SQLException {
        PreparedStatement get_messages_st;
        Integer count = null;
        ResultSet rs = null;
        BareJID owner = crit.getQuestionerJID().getBareJID();
        PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, this.GET_MESSAGES_COUNT_QUERY);
        synchronized (preparedStatement) {
            try {
                this.setCountQueryParams(get_messages_st, owner.toString(), crit, null);
                rs = get_messages_st.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getItemPosition(String uid, Q query) throws SQLException, ComponentException {
        PreparedStatement get_message_position_st;
        if (uid == null || uid.isEmpty()) {
            return null;
        }
        if (!((QueryCriteria)query).getUseMessageIdInRsm()) {
            return Integer.parseInt(uid);
        }
        Integer position = null;
        ResultSet rs = null;
        BareJID owner = query.getQuestionerJID().getBareJID();
        PreparedStatement preparedStatement = get_message_position_st = this.data_repo.getPreparedStatement(owner, this.GET_MESSAGE_POSITION_QUERY);
        synchronized (preparedStatement) {
            try {
                int i = this.setCountQueryParams(get_message_position_st, owner.toString(), query, null);
                get_message_position_st.setString(i++, uid);
                rs = get_message_position_st.executeQuery();
                if (rs.next()) {
                    position = rs.getInt(1);
                }
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
            this.data_repo.release(null, rs);
        }
        if (position == null || position < 1) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Item with " + uid + " not found");
        }
        return position - 1;
    }

    @TigaseDeprecated(since="2.1.0", removeIn="3.0.0", note="This method will not be used any more in version 3.0.0")
    @Deprecated
    private String generateHashOfMessageAsString(MessageArchiveRepository.Direction direction, Element msg, Date ts, Map<String, Object> additionalData) {
        byte[] result = this.generateHashOfMessage(direction, msg, ts, additionalData);
        return result != null ? Base64.encode((byte[])result) : null;
    }

    public static class Item<Q extends QueryCriteria>
    implements MessageArchiveRepository.Item {
        MessageArchiveRepository.Direction direction;
        String id;
        Element messageEl;
        String messageStr;
        Date timestamp;
        String with;

        public String getId() {
            return this.id;
        }

        @Override
        public MessageArchiveRepository.Direction getDirection() {
            return this.direction;
        }

        public Element getMessage() {
            return this.messageEl;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getWith() {
            return this.with;
        }

        protected int read(DataRepository repo, ResultSet rs, Q crit) throws SQLException {
            int i = 1;
            this.messageStr = rs.getString(i++);
            this.timestamp = repo.getTimestamp(rs, i++);
            this.direction = MessageArchiveRepository.Direction.getDirection(rs.getShort(i++));
            if (crit.getWith() == null) {
                this.with = rs.getString(i);
            }
            int n = ++i;
            this.id = rs.getString(n);
            return ++i;
        }
    }
}

