/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.util.Map;
import java.util.Optional;
import tigase.archive.RetentionType;
import tigase.archive.StoreMethod;
import tigase.archive.StoreMuc;
import tigase.kernel.beans.Bean;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.vhosts.AbstractVHostItemExtension;
import tigase.vhosts.VHostItemExtensionBackwardCompatible;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemExtensionProvider;
import tigase.xml.Element;

public class MessageArchiveVHostItemExtension
extends AbstractVHostItemExtension<MessageArchiveVHostItemExtension>
implements VHostItemExtensionBackwardCompatible<MessageArchiveVHostItemExtension> {
    public static final String ENABLED_KEY = "xep0136Enabled";
    public static final String DEFAULT_STORE_METHOD_KEY = "xep0136DefaultStoreMethod";
    public static final String REQUIRED_STORE_METHOD_KEY = "xep0136RequiredStoreMethod";
    public static final String RETENTION_TYPE_KEY = "xep0136Retention";
    public static final String RETENTION_PERIOD_KEY = "xep0136RetentionPerion";
    public static final String MUC_SAVE_KEY = "xep0136SaveMuc";
    public static final String ID = "message-archive";
    public static final boolean DEFAULT_ENABLED_VAL = true;
    private boolean enabled = true;
    private Optional<StoreMethod> defaultStoreMethod = Optional.empty();
    private Optional<StoreMethod> requiredStoreMethod = Optional.empty();
    private RetentionType retentionType = RetentionType.userDefined;
    private Integer retentionDays = null;
    private Optional<StoreMuc> saveMuc = Optional.empty();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<StoreMethod> getDefaultStoreMethod() {
        return this.defaultStoreMethod;
    }

    public Optional<StoreMethod> getRequiredStoreMethod() {
        return this.requiredStoreMethod;
    }

    public RetentionType getRetentionType() {
        return this.retentionType;
    }

    public Integer getRetentionDays() {
        return this.retentionDays;
    }

    public Optional<StoreMuc> getSaveMuc() {
        return this.saveMuc;
    }

    public void initFromData(Map<String, Object> data) {
        String tmp;
        Boolean enabled = (Boolean)data.remove(ENABLED_KEY);
        if (enabled != null) {
            this.enabled = enabled;
        }
        if ((tmp = (String)data.remove(DEFAULT_STORE_METHOD_KEY)) != null) {
            this.defaultStoreMethod = Optional.of(StoreMethod.valueof(tmp));
        }
        if ((tmp = (String)data.remove(REQUIRED_STORE_METHOD_KEY)) != null) {
            this.requiredStoreMethod = Optional.of(StoreMethod.valueof(tmp));
        }
        if ((tmp = (String)data.remove(RETENTION_TYPE_KEY)) != null) {
            this.retentionType = RetentionType.valueOf(tmp);
        }
        this.retentionDays = (Integer)data.remove(RETENTION_PERIOD_KEY);
        tmp = (String)data.remove(MUC_SAVE_KEY);
        if (tmp != null) {
            this.saveMuc = Optional.of(StoreMuc.valueof(tmp));
        }
    }

    public String getId() {
        return ID;
    }

    public void initFromElement(Element item) {
        String enabledAttribute = item.getAttributeStaticStr("enabled");
        this.enabled = enabledAttribute == null ? true : Boolean.parseBoolean(enabledAttribute);
        this.defaultStoreMethod = Optional.ofNullable(item.getAttributeStaticStr("default-store-method")).map(StoreMethod::valueof);
        this.requiredStoreMethod = Optional.ofNullable(item.getAttributeStaticStr("required-store-method")).map(StoreMethod::valueof);
        this.retentionType = Optional.ofNullable(item.getAttributeStaticStr("retention-type")).map(RetentionType::valueOf).orElse(RetentionType.userDefined);
        this.retentionDays = Optional.ofNullable(item.getAttributeStaticStr("retention-days")).map(Integer::parseInt).orElse(null);
        this.saveMuc = Optional.ofNullable(item.getAttributeStaticStr("save-muc")).map(StoreMuc::valueof);
    }

    public void initFromCommand(String prefix, Packet packet) throws IllegalArgumentException {
        Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-enabled"))).ifPresent(s -> {
            this.enabled = Boolean.parseBoolean(s);
        });
        this.defaultStoreMethod = Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-default-store-method"))).filter(s -> !s.isEmpty()).map(StoreMethod::valueof);
        this.requiredStoreMethod = Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-required-store-method"))).filter(s -> !s.isEmpty()).map(StoreMethod::valueof);
        this.retentionType = Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-retention-type"))).map(RetentionType::valueOf).orElse(RetentionType.userDefined);
        this.retentionDays = Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-retention-days"))).map(Integer::parseInt).orElse(null);
        this.saveMuc = Optional.ofNullable(Command.getFieldValue((Packet)packet, (String)(prefix + "-save-muc"))).filter(s -> !s.isEmpty()).map(StoreMuc::valueof);
    }

    public String toDebugString() {
        return "enabled: " + this.enabled + ", defaultStore: " + this.defaultStoreMethod.map(StoreMethod::toString).orElse("unset") + ", requiredStore: " + this.requiredStoreMethod.map(StoreMethod::toString).orElse("unset") + ", retentionType: " + (Object)((Object)this.retentionType) + ", saveMuc: " + this.saveMuc;
    }

    public Element toElement() {
        Element el = new Element(this.getId());
        if (!this.enabled) {
            el.setAttribute("enabled", String.valueOf(this.enabled));
        }
        this.defaultStoreMethod.ifPresent(v -> el.setAttribute("default-store-method", v.toString()));
        this.requiredStoreMethod.ifPresent(v -> el.setAttribute("required-store-method", v.toString()));
        if (this.retentionType != RetentionType.userDefined) {
            el.setAttribute("retention-type", this.retentionType.toString());
        }
        if (this.retentionDays != null) {
            el.setAttribute("retention-days", String.valueOf(this.retentionDays));
        }
        this.saveMuc.ifPresent(v -> el.setAttribute("save-muc", v.toString()));
        return el.getAttributes() == null || el.getAttributes().isEmpty() ? null : el;
    }

    public MessageArchiveVHostItemExtension mergeWithDefaults(MessageArchiveVHostItemExtension defaults) {
        MessageArchiveVHostItemExtension merged = new MessageArchiveVHostItemExtension();
        merged.enabled = this.enabled && defaults.isEnabled();
        merged.defaultStoreMethod = this.defaultStoreMethod.isPresent() ? this.defaultStoreMethod : defaults.getDefaultStoreMethod();
        merged.requiredStoreMethod = this.requiredStoreMethod.isPresent() ? this.requiredStoreMethod : defaults.getRequiredStoreMethod();
        switch (this.retentionType) {
            case unlimited: {
                if (defaults.getRetentionType() == RetentionType.unlimited || defaults.getRetentionType() == RetentionType.userDefined) {
                    merged.retentionType = RetentionType.unlimited;
                } else {
                    merged.retentionType = RetentionType.numberOfDays;
                    merged.retentionDays = defaults.getRetentionDays();
                }
            }
            case numberOfDays: {
                merged.retentionType = RetentionType.numberOfDays;
                merged.retentionDays = Math.min(this.retentionDays == null ? Integer.MAX_VALUE : this.retentionDays, defaults.getRetentionDays() == null ? Integer.MAX_VALUE : defaults.getRetentionDays());
            }
            case userDefined: {
                merged.retentionType = RetentionType.userDefined;
            }
        }
        merged.saveMuc = this.saveMuc.isPresent() ? this.saveMuc : defaults.getSaveMuc();
        return merged;
    }

    public void addCommandFields(String prefix, Packet packet, boolean forDefault) {
        Element commandEl = packet.getElemChild("command", "http://jabber.org/protocol/commands");
        DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-enabled"), (String)(this.enabled ? "true" : "false"), (String)"boolean", (String)"Message Archiving enabled");
        DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-default-store-method"), (String)this.defaultStoreMethod.map(Enum::toString).orElse(""), (String)"Message Archiving - default store method", (String[])new String[]{"Default", "False", "Body", "Message", "Stream"}, (String[])new String[]{"", "false", "body", "message", "stream"});
        DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-required-store-method"), (String)this.requiredStoreMethod.map(Enum::toString).orElse(""), (String)"Message Archiving - required store method", (String[])new String[]{"Default", "False", "Body", "Message", "Stream"}, (String[])new String[]{"", "false", "body", "message", "stream"});
        DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-retention-type"), (String)this.retentionType.name(), (String)"Message Archiving - retention type", (String[])new String[]{"User defined", "Unlimited", "Number of days"}, (String[])new String[]{"userDefined", "unlimited", "numberOfDays"});
        DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-retention-days"), (String)(this.retentionDays == null ? "" : String.valueOf(this.retentionDays)), (String)"text-single", (String)"Message Archiving - retention period (in days)");
        DataForm.addFieldValue((Element)commandEl, (String)(prefix + "-save-muc"), (String)this.saveMuc.map(Enum::toString).orElse(""), (String)"Message Archiving - store MUC messages", (String[])new String[]{"Default", StoreMuc.User.name(), StoreMuc.False.name(), StoreMuc.True.name()}, (String[])new String[]{"", StoreMuc.User.toString(), StoreMuc.False.toString(), StoreMuc.True.toString()});
    }

    @Bean(name="message-archive", parent=VHostItemExtensionManager.class, active=true)
    public static class Provider
    implements VHostItemExtensionProvider<MessageArchiveVHostItemExtension> {
        public String getId() {
            return MessageArchiveVHostItemExtension.ID;
        }

        public Class<MessageArchiveVHostItemExtension> getExtensionClazz() {
            return MessageArchiveVHostItemExtension.class;
        }
    }
}

