/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Form;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public abstract class AbstractAdHocCommand
implements AdHocCommand {
    private static final Logger a = Logger.getLogger(AbstractAdHocCommand.class.getCanonicalName());

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element element = request.getCommand().getChild("x", "jabber:x:data");
            if (request.isAction("cancel")) {
                response.cancelSession();
            } else if (element == null) {
                response.getElements().add(this.prepareForm(request, response).getElement());
                response.startSession();
            } else {
                Form form;
                Form form2 = new Form(element);
                if (form2.isType("submit") && (form = this.submitForm(request, response, form2)) != null) {
                    response.getElements().add(form.getElement());
                }
            }
        }
        catch (Exception exception) {
            a.log(Level.FINE, "Exception during execution of adhoc command " + this.getNode(), exception);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, exception.getMessage());
        }
    }

    protected abstract Form prepareForm(AdhHocRequest var1, AdHocResponse var2) throws AdHocCommandException;

    protected abstract Form submitForm(AdhHocRequest var1, AdHocResponse var2, Form var3) throws AdHocCommandException;
}

