/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.util.LinkedList;
import java.util.List;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.spam.SpamProcessor;
import tigase.spam.filters.AbstractSpamFilter;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="presence-subscribe-outgoing", parent=SpamProcessor.class, active=false)
public class PresenceSubscribeOutgoingFilter
extends AbstractSpamFilter {
    protected static final String ID = "presence-subscribe-outgoing";
    @ConfigField(desc="Number of allowed subscription requests per minute")
    private int numberOfAllowedRequestsPerMinute = 5;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public double getSpamProbability() {
        return 0.4;
    }

    @Override
    protected boolean filterPacket(Packet packet, XMPPResourceConnection session) {
        if (packet.getType() == StanzaType.subscribe && packet.getPacketFrom() != null && session.isAuthorized()) {
            try {
                if (packet.getPacketFrom().equals((Object)session.getConnectionId())) {
                    Counter counter = (Counter)session.computeCommonSessionDataIfAbsent(ID, x -> new Counter());
                    return counter.check(this.numberOfAllowedRequestsPerMinute);
                }
            }
            catch (NoConnectionIdException noConnectionIdException) {
                // empty catch block
            }
        }
        return true;
    }

    public static class Counter {
        protected List<Long> timestamps = new LinkedList<Long>();

        public synchronized boolean check(int limit) {
            this.timestamps.add(System.currentTimeMillis());
            this.cleanUp();
            if (this.timestamps.size() > limit) {
                while (this.timestamps.size() > limit) {
                    this.timestamps.remove(0);
                }
                return false;
            }
            return true;
        }

        public synchronized boolean cleanUp() {
            while (!this.timestamps.isEmpty() && System.currentTimeMillis() - this.timestamps.get(0) > 60000L) {
                this.timestamps.remove(0);
            }
            return this.timestamps.isEmpty();
        }
    }
}

