/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.AdvancedConfigPage;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.questions.Question;
import tigase.http.modules.setup.questions.SingleAnswerQuestion;
import tigase.server.xmppsession.SessionManager;
import tigase.util.setup.BeanDefinition;
import tigase.util.setup.SetupHelper;
import tigase.xmpp.XMPPImplIfc;

public class PluginsConfigPage
extends Page
implements AdvancedConfigPage {
    private List<PluginQuestion> plugins = SetupHelper.getAvailableProcessors(SessionManager.class, XMPPImplIfc.class).stream().map(def -> new PluginQuestion((BeanDefinition)def, config)).sorted(PluginQuestion.access$0()).collect(Collectors.toList());

    public PluginsConfigPage(Config config) {
        super("Plugins selection", "plugins.html", Stream.empty());
        this.plugins.forEach(this::addQuestion);
    }

    public List<Question> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    private static class PluginQuestion
    extends SingleAnswerQuestion {
        private static final Comparator<PluginQuestion> byBeanName = (e1, e2) -> e1.getBeanName().compareTo(e2.getBeanName());
        private final Config config;
        private final BeanDefinition def;

        PluginQuestion(BeanDefinition def, Config config) {
            super(def.getName(), () -> config.plugins.contains(def.getName()) ? def.getName() : null, val -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.plugins.add(def.getName());
                } else {
                    config.plugins.remove(def.getName());
                }
            });
            this.def = def;
            this.config = config;
        }

        @Override
        public String getLabel() {
            return null;
        }

        public String getBeanName() {
            return this.def.getName();
        }

        public boolean mayBeChanged() {
            if (!this.mayBeEnabled()) {
                return false;
            }
            return !this.def.getClazz().getCanonicalName().equals("tigase.archive.unified.processors.UnifiedArchivePlugin") || !this.config.optionalComponents.contains("unified-archive");
        }

        public boolean mayBeEnabled() {
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.unified")) {
                return this.config.optionalComponents.contains("unified-archive");
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.")) {
                return this.config.optionalComponents.contains("message-archive") || this.config.optionalComponents.contains("unified-archive");
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.pubsub.")) {
                return this.config.optionalComponents.contains("pubsub");
            }
            return true;
        }

        public String getCause() {
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.unified")) {
                return "Processor requires Tigase Unified Archive Component";
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.")) {
                return "Processor requires Tigase Message Archiving Component or Tigase Unified Component";
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.pubsub.")) {
                return "Processor requires Tigase PubSub Component";
            }
            return null;
        }

        @Override
        public boolean isSelected(String value) {
            if (this.def.getClazz().getCanonicalName().equals("tigase.archive.unified.processors.UnifiedArchivePlugin")) {
                return this.config.optionalComponents.contains("unified-archive");
            }
            return super.isSelected(value);
        }

        static /* synthetic */ Comparator access$0() {
            return byBeanName;
        }
    }
}

