/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.migration;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.DSLBeanConfigurator;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfiguratorAbstract;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.DataSourceBean;
import tigase.db.beans.UserRepositoryMDPoolBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.core.Kernel;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomWithId;
import tigase.muc.repository.IMucDAO;
import tigase.muc.repository.MucDAOOld;
import tigase.util.log.LogFormatter;
import tigase.xmpp.jid.BareJID;

public class Converter {
    private static final Logger log = Logger.getLogger(Converter.class.getCanonicalName());
    private IMucDAO newRepo;
    private MucDAOOld oldRepo;
    private boolean stopOnError;

    public static void initLogger() {
        String initial_config = "tigase.level=ALL\ntigase.db.jdbc.level=INFO\ntigase.xml.level=INFO\ntigase.form.level=INFO\ntigase.kernel.level=INFO\nhandlers=java.util.logging.ConsoleHandler java.util.logging.FileHandler\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=" + LogFormatter.class.getName() + "\njava.util.logging.FileHandler.LEVEL=ALL\njava.util.logging.FileHandler.formatter=" + LogFormatter.class.getName() + "\njava.util.logging.FileHandler.pattern=muc_db_migration.log\ntigase.useParentHandlers=true\n";
        ConfiguratorAbstract.loadLogManagerConfig((String)initial_config);
    }

    public static void main(String[] argv) throws IOException {
        Converter.initLogger();
        if (argv == null || argv.length == 0) {
            System.out.println("\nConverter parameters:\n");
            System.out.println(" -in-repo-class tigase.db.jdbc.DataRepositoryImpl                           -      class implementing UserRepository");
            System.out.println(" -in 'jdbc:xxxx://localhost/tigasedb?user=tigase&password=tigase_pass'      -\t\turi of source database");
            System.out.println(" -out 'jdbc:xxxx://localhost/tigasedb?user=tigase&password=tigase_pass'     -\t\turi of destination database");
            System.out.println(" -stop-on-error                                                             -      whether to stop conversion on first error");
            return;
        }
        Converter converter = new Converter();
        log.info("parsing configuration parameters");
        String repoClass = null;
        String oldRepoUri = null;
        String newRepoUri = null;
        boolean stopOnError = false;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if ("-in".equals(arg)) {
                oldRepoUri = argv[++i];
                continue;
            }
            if ("-out".equals(arg)) {
                newRepoUri = argv[++i];
                continue;
            }
            if ("-in-repo-class".equals(arg)) {
                repoClass = argv[++i];
                continue;
            }
            if (!"-stop-on-error".equals(arg)) continue;
            stopOnError = true;
        }
        log.info("initializing converter");
        try {
            converter.init(repoClass, oldRepoUri, newRepoUri, stopOnError);
            log.info("Starting migration");
            boolean conversionFinishedCorrectly = converter.convert();
            log.info(conversionFinishedCorrectly ? "Migration finished correctly" : "Migration FAILED!");
            System.exit(conversionFinishedCorrectly ? 0 : 1);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Migration failed: " + e, e);
            System.exit(1);
        }
    }

    public boolean convert() throws Exception {
        AtomicLong failedConversionCount = new AtomicLong();
        AtomicLong warningConversionCount = new AtomicLong();
        ArrayList<BareJID> roomsJIDList = this.oldRepo.getRoomsJIDList();
        Room room = null;
        String subject = null;
        Date subjectDate = null;
        String subjectNick = null;
        for (BareJID roomJid : roomsJIDList) {
            try {
                log.log(Level.FINE, "Reading details of room with jid: {0}", new Object[]{roomJid});
                room = (RoomWithId)this.oldRepo.readRoom(roomJid);
                subject = this.oldRepo.getSubject(roomJid);
                subjectDate = this.oldRepo.getSubjectCreationDate(roomJid);
                subjectNick = this.oldRepo.getSubjectCreatorNickname(roomJid);
                if (room == null || room.getConfig() == null) {
                    warningConversionCount.incrementAndGet();
                    log.log(Level.WARNING, "skipping conversion of room with jid " + roomJid + " - room configuration is missing!");
                    this.oldRepo.destroyRoom(roomJid);
                    continue;
                }
                if (this.newRepo.getRoom(roomJid) != null) {
                    warningConversionCount.incrementAndGet();
                    log.log(Level.INFO, "Room with jid " + roomJid + " already exists, skipping conversion!");
                    continue;
                }
                log.log(Level.FINER, "Converting room with jid: {0}. Subject: {1}, SubjectCreationDate: {2}, SubjectCreatorNickname: {3}, Room affiliations: {4}, Room configuration: {5}", new Object[]{roomJid, subject, subjectDate, subjectNick, room.getAffiliations(), room.getConfig().getAsElement()});
                this.newRepo.createRoom(room);
                if (subjectDate != null) {
                    this.newRepo.setSubject(room, subject, subjectNick, subjectDate);
                }
                this.oldRepo.destroyRoom(roomJid);
                log.log(Level.FINE, "Room with jid: {0} converted successfully", new Object[]{roomJid});
            }
            catch (Exception e) {
                failedConversionCount.incrementAndGet();
                String roomDetails = room == null ? "n/a" : ", Room affiliations: " + room.getAffiliations() + ", Room configuration: " + room.getConfig();
                log.log(Level.WARNING, "Error converting room with jid: " + roomJid + ". Subject: " + subject + ", SubjectCreationDate: " + subjectDate + ", SubjectCreatorNickname: " + subjectNick + roomDetails, e);
                if (!this.stopOnError) continue;
                throw new RuntimeException("Repository conversion failed", e);
            }
        }
        log.log(Level.INFO, "Failed converting {0} out of {1} rooms", new Object[]{failedConversionCount.get(), roomsJIDList.size()});
        return failedConversionCount.get() == 0L;
    }

    public void init(String repoClass, String oldRepoUri, String newRepoUri, boolean stopOnError) throws RepositoryException {
        Kernel kernel = new Kernel();
        try {
            kernel.registerBean(DefaultTypesConverter.class).exec();
            kernel.registerBean(DSLBeanConfigurator.class).exec();
            DSLBeanConfigurator configurator = (DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class);
            HashMap props = new HashMap();
            HashMap<String, Serializable> dataSourceProps = new HashMap<String, Serializable>();
            HashMap<String, String> defaultProps = new HashMap<String, String>();
            defaultProps.put("uri", oldRepoUri);
            dataSourceProps.put("default", defaultProps);
            dataSourceProps.put("schema-management", Boolean.valueOf(false));
            AbstractBeanConfigurator.BeanDefinition mucDataSourceProps = new AbstractBeanConfigurator.BeanDefinition();
            mucDataSourceProps.setBeanName("new-repo");
            mucDataSourceProps.put((Object)"uri", (Object)newRepoUri);
            dataSourceProps.put("new-repo", (Serializable)mucDataSourceProps);
            props.put("dataSource", dataSourceProps);
            if (repoClass != null) {
                HashMap userRepo = new HashMap();
                HashMap<String, String> userDefaultProps = new HashMap<String, String>();
                userDefaultProps.put("cls", repoClass);
                userRepo.put("default", userDefaultProps);
                props.put("userRepository", userRepo);
            }
            configurator.setProperties(props);
            kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
            kernel.registerBean(DataSourceBean.class).exportable().exec();
            kernel.registerBean(Room.RoomFactoryImpl.class).exec();
            kernel.registerBean(UserRepositoryMDPoolBean.class).exportable().exec();
            kernel.registerBean("muc-dao-old").asClass(MucDAOOld.class).exec();
            Class daoClass = DataSourceHelper.getDefaultClass(IMucDAO.class, (String)newRepoUri);
            kernel.registerBean(MUCConfig.class).exec();
            kernel.registerBean("muc-dao").asClass(daoClass).exec();
            DataSource ds = ((DataSourceBean)kernel.getInstance("dataSource")).getRepository("new-repo");
            this.oldRepo = (MucDAOOld)kernel.getInstance(MucDAOOld.class);
            this.oldRepo.setIgnoreIncorrectRoomNames(true);
            this.newRepo = (IMucDAO)kernel.getInstance(IMucDAO.class);
            this.newRepo.setDataSource(ds);
            this.stopOnError = stopOnError;
        }
        catch (Exception ex) {
            throw new RepositoryException("could not initialize converter", (Throwable)ex);
        }
    }
}

