/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import tigase.kernel.beans.Bean;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.push.PushNotifications;
import tigase.xmpp.impl.push.PushNotificationsExtension;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="encrypted", parent=PushNotifications.class, active=true)
public class EncryptedPushNotificationExtension
implements PushNotificationsExtension {
    private static final Logger log = Logger.getLogger(EncryptedPushNotificationExtension.class.getCanonicalName());
    public static final String XMLNS = "tigase:push:encrypt:0";
    private static final String AES128GCM_FEATURE = "tigase:push:encrypt:aes-128-gcm";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"tigase:push:encrypt:0"}), new Element("feature", new String[]{"var"}, new String[]{"tigase:push:encrypt:aes-128-gcm"})};
    private final SecureRandom random = new SecureRandom();

    @Override
    public Element[] getDiscoFeatures() {
        return DISCO_FEATURES;
    }

    @Override
    public boolean shouldSendNotification(Packet packet, BareJID userJid, XMPPResourceConnection session) throws XMPPException {
        return false;
    }

    @Override
    public void processEnableElement(Element enableEl, Element settingsEl) {
        Element encryptEl = enableEl.getChild("encrypt", XMLNS);
        if (encryptEl == null) {
            return;
        }
        settingsEl.addChild((XMLNodeIfc)encryptEl);
    }

    @Override
    public void prepareNotificationPayload(Element pushServiceSettings, Packet packet, long msgCount, Element notification) {
        Element encryptEl = pushServiceSettings.getChild("encrypt", XMLNS);
        if (encryptEl == null || packet == null) {
            return;
        }
        String alg = encryptEl.getAttributeStaticStr("alg");
        long maxSizeBytes = Optional.ofNullable(encryptEl.getAttributeStaticStr("max-size")).map(Integer::parseInt).orElse(Integer.MAX_VALUE).intValue();
        String keyStr = encryptEl.getCData();
        if (alg == null || keyStr == null) {
            return;
        }
        int maxSize = (int)(maxSizeBytes * 6L / 8L);
        if (!alg.equalsIgnoreCase("aes-128-gcm")) {
            return;
        }
        Element x = notification.getChild("x", "jabber:x:data");
        if (x != null) {
            notification.removeChild(x);
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("unread", msgCount);
        payload.put("sender", packet.getStanzaFrom().getBareJID());
        if (packet.getElemName() == "message") {
            if (packet.getType() == StanzaType.groupchat) {
                payload.put("type", "groupchat");
                String nickname = packet.getStanzaFrom().getResource();
                if (nickname != null) {
                    payload.put("nickname", nickname);
                }
            } else {
                payload.put("type", "chat");
            }
        }
        String content = EncryptedPushNotificationExtension.valueToString(payload);
        String body = packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH);
        if (body != null) {
            int currentContentLength = content.getBytes(UTF8).length + 64;
            while (maxSize < currentContentLength + body.getBytes(UTF8).length) {
                body = body.substring(0, maxSize - currentContentLength);
            }
            payload.put("message", body);
            content = EncryptedPushNotificationExtension.valueToString(payload);
        }
        try {
            SecretKeySpec key = new SecretKeySpec(Base64.decode((String)keyStr), "AES");
            byte[] iv = new byte[12];
            this.random.nextBytes(iv);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, gcmParameterSpec);
            byte[] data = cipher.doFinal(content.getBytes(UTF8));
            Element encryped = new Element("encrypted", Base64.encode((byte[])data));
            encryped.addAttribute("iv", Base64.encode((byte[])iv));
            encryped.setXMLNS(XMLNS);
            notification.addChild((XMLNodeIfc)encryped);
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Could not encode payload", ex);
        }
    }

    private static String valueToString(Object value) {
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof String | value instanceof BareJID | value instanceof JID) {
            return EncryptedPushNotificationExtension.escapeValue(value.toString());
        }
        if (value instanceof List) {
            return "[" + ((List)value).stream().map(EncryptedPushNotificationExtension::valueToString).collect(Collectors.joining(",")) + "]";
        }
        if (value instanceof Map) {
            return "{" + ((Map)value).entrySet().stream().map(e -> "\"" + e.getKey() + "\" : " + EncryptedPushNotificationExtension.valueToString(e.getValue())).collect(Collectors.joining(",")) + "}";
        }
        return "null";
    }

    private static String escapeValue(String in) {
        return "\"" + in.replace("\"", "\\\"") + "\"";
    }
}

