/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.PresenceAbstract;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.impl.roster.DynamicRoster;
import tigase.xmpp.impl.roster.RepositoryAccessException;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.impl.roster.RosterRetrievingException;
import tigase.xmpp.jid.JID;

@Id(value="presence-state")
@Handles(value={@Handle(path={"presence"}, xmlns="jabber:client"), @Handle(path={"iq", "query"}, xmlns="jabber:iq:roster-load")})
@Bean(name="presence-state", parent=SessionManager.class, active=true)
public class PresenceState
extends PresenceAbstract
implements XMPPStopListenerIfc {
    public static final String DIRECT_PRESENCE = "direct-presences";
    public static final String ENABLE_ROSTER_LAZY_LOADING_KEY = "enable-roster-lazy-loading";
    public static final String EXTENDED_PRESENCE_PROCESSORS_KEY = "extended-presence-processors";
    public static final String OFFLINE_BUD_SENT = "offline-bud-sent";
    public static final String OFFLINE_RES_SENT = "offline-res-sent";
    public static final String OFFLINE_ROSTER_LAST_SEEN_PROP_KEY = "offline-roster-last-seen";
    public static final String PRESENCE_GLOBAL_FORWARD = "presence-global-forward";
    protected static final String ID = "presence-state";
    private static final Logger log = Logger.getLogger(PresenceState.class.getCanonicalName());
    private static final long MAX_DIRECT_PRESENCES_NO = 1000L;
    private static final String[] PRESENCE_C_PATH = new String[]{"presence", "c"};
    private static final Set<StanzaType> TYPES = new HashSet<StanzaType>(Arrays.asList(StanzaType.available, StanzaType.unavailable, StanzaType.probe, StanzaType.error, StanzaType.result, null));
    protected static int HIGH_PRIORITY_PRESENCES_NO = 10;
    @Inject(nullAllowed=true)
    private List<ExtendedPresenceProcessorIfc> extendedPresenceProcessors = new ArrayList<ExtendedPresenceProcessorIfc>();
    @ConfigField(desc="Send last seen infomations for matching clients", alias="offline-roster-last-seen")
    private String[] offlineRosterLastSeen = null;
    @ConfigField(desc="Forward all presences to following JID", alias="presence-global-forward")
    private JID presenceGLobalForward = null;
    @ConfigField(desc="Enable roster lazy loading", alias="enable-roster-lazy-loading")
    private boolean rosterLazyLoading = true;
    private long usersStatusChanges = 0L;

    public static void addDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        LinkedHashSet<JID> direct_presences = (LinkedHashSet<JID>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new LinkedHashSet<JID>(10);
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        if ((long)direct_presences.size() < 1000L) {
            direct_presences.add(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added direct presence jid: {0}", jid);
        }
    }

    protected static void broadcastDirectPresences(StanzaType t, XMPPResourceConnection session, Queue<Packet> results, Element pres) throws NotAuthorizedException, TigaseDBException {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null && t != null && t == StanzaType.unavailable) {
            for (JID buddy : direct_presences) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Updating direct presence for: {0}", buddy);
                }
                Packet pack = PresenceState.sendPresence(t, session.getJID(), buddy, results, pres);
                pack.setPriority(Priority.LOW);
            }
        }
    }

    public static void broadcastOffline(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract roster_util) throws NotAuthorizedException, TigaseDBException {
        if (session.getSessionData(OFFLINE_BUD_SENT) != null) {
            return;
        }
        session.putSessionData(OFFLINE_BUD_SENT, OFFLINE_BUD_SENT);
        Element pres = session.getPresence();
        if (pres != null) {
            PresenceState.sendPresenceBroadcast(StanzaType.unavailable, session, RosterAbstract.FROM_SUBSCRIBED, results, pres, settings, roster_util);
        } else {
            PresenceState.broadcastDirectPresences(StanzaType.unavailable, session, results, pres);
        }
    }

    public static void removeDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Added direct presence jid: {0}", jid);
        }
    }

    public static void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<RosterAbstract.SubscriptionType> subscrs, Queue<Packet> results, Element pres, Map<String, Object> settings, RosterAbstract roster_util) throws NotAuthorizedException, TigaseDBException {
        PresenceState.broadcastDirectPresences(t, session, results, pres);
        RosterAbstract roster = roster_util;
        if (roster == null) {
            roster = RosterFactory.getRosterImplementation(true);
        }
        Object[] buddies = roster.getBuddies(session, subscrs);
        try {
            buddies = DynamicRoster.addBuddies(session, settings, (JID[])buddies, subscrs);
        }
        catch (RepositoryAccessException | RosterRetrievingException xMPPException) {
            // empty catch block
        }
        if (buddies != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, session.getBareJID() + " | Buddies found: " + Arrays.toString(buddies));
            }
            Priority pack_priority = Priority.PRESENCE;
            int pres_cnt = 0;
            for (Object buddy : buddies) {
                if (PresenceState.requiresPresenceSending(roster, (JID)buddy, session, false)) {
                    Packet pack = PresenceState.sendPresence(t, session.getJID(), (JID)buddy, results, pres);
                    if (pres_cnt == HIGH_PRIORITY_PRESENCES_NO) {
                        ++pres_cnt;
                        pack_priority = Priority.LOWEST;
                    }
                    if (pack == null) continue;
                    pack.setPriority(pack_priority);
                    roster.setPresenceSent(session, (JID)buddy, true);
                    continue;
                }
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, session.getBareJID() + " | Not sending presence to buddy: " + buddy);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "No buddies found!!!!");
        }
    }

    protected static void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (session.getSessionData(OFFLINE_RES_SENT) != null) {
            return;
        }
        session.putSessionData(OFFLINE_RES_SENT, OFFLINE_RES_SENT);
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Update presence change to: {0}", conn.getJID());
                }
                if (conn != session && conn.isResourceSet() && !conn.getResource().equals(session.getResource())) {
                    Element pres_update = new Element("presence");
                    pres_update.setAttribute("type", StanzaType.unavailable.toString());
                    pres_update.setXMLNS("jabber:client");
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, "Skipping presence update to: {0}", conn.getJID());
            }
            catch (NoConnectionIdException | NotAuthorizedException xMPPException) {}
        }
    }

    @Override
    public Set<StanzaType> supTypes() {
        return TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is null, ignoring packet: {0}", packet);
            }
            return;
        }
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is not authorized, ignoring packet: {0}", packet);
            }
            return;
        }
        if (packet.getElemName() == "iq") {
            boolean finishProcessing = true;
            switch (packet.getType()) {
                case result: {
                    XMPPResourceConnection xMPPResourceConnection = session;
                    synchronized (xMPPResourceConnection) {
                        Element presEl = session.getPresence();
                        if (presEl != null) {
                            session.removeSessionData("user-presence");
                            presEl.removeAttribute("from");
                            presEl.removeAttribute("to");
                            Packet pres = Packet.packetInstance(presEl, packet.getStanzaFrom(), packet.getStanzaTo());
                            pres.setPacketFrom(packet.getPacketFrom());
                            pres.setPacketTo(packet.getPacketTo());
                            try {
                                this.processOutInitial(pres, session, results, settings, RosterAbstract.PresenceType.out_initial);
                            }
                            catch (NotAuthorizedException e) {
                                log.log(Level.INFO, "Can not access user Roster, user session is not authorized yet: {0}", packet);
                                log.log(Level.FINEST, "presence problem...", e);
                            }
                            catch (TigaseDBException e) {
                                log.log(Level.WARNING, "Error accessing database for presence data: {0}", e);
                            }
                        }
                        break;
                    }
                }
            }
            if (finishProcessing) {
                return;
            }
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                RosterAbstract.PresenceType pres_type = this.roster_util.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.log(Level.INFO, "Invalid presence found: {0}", packet);
                    return;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0} | {1} presence found: {2}", new Object[]{session.getBareJID().toString(), pres_type, packet});
                }
                switch (pres_type) {
                    case out_initial: {
                        this.processOutInitial(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_initial: {
                        this.processInInitial(packet, session, results, settings, pres_type);
                        break;
                    }
                    case in_probe: {
                        if (session.getPresence() == null) {
                            return;
                        }
                        this.processInProbe(packet, session, results, settings, pres_type);
                        break;
                    }
                    case out_probe: {
                        PresenceState.forwardPresence(results, packet, session.getJID());
                        break;
                    }
                    case error: {
                        this.processError(packet, session, results, settings, pres_type);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.log(Level.INFO, "Can not access user Roster, user session is not authorized yet: {0}", packet);
                log.log(Level.FINEST, "presence problem...", e);
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for presence data: {0}", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                if (session.getPresence() != null) {
                    Element pres = session.getPresence();
                    if (!StanzaType.unavailable.toString().equals(pres.getAttributeStaticStr("type"))) {
                        pres.setAttribute("type", StanzaType.unavailable.toString());
                        session.setPresence(pres);
                    }
                    PresenceState.broadcastOffline(session, results, settings, this.roster_util);
                    PresenceState.updateOfflineChange(session, results);
                } else {
                    PresenceState.broadcastDirectPresences(StanzaType.unavailable, session, results, null);
                }
                this.roster_util.logout(session);
            }
            catch (NotAuthorizedException pres) {
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Error accessing database for offline message: ", e);
            }
        }
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.id(), "Users status changes", this.usersStatusChanges, Level.INFO);
    }

    public void rebroadcastPresence(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        if (session.getPresence() == null) {
            return;
        }
        Element presence = session.getPresence().clone();
        for (ExtendedPresenceProcessorIfc processor : this.extendedPresenceProcessors) {
            Element extendContent = processor.extend(presence, session, results);
            if (extendContent == null) continue;
            Element child = presence.getChild(extendContent.getName(), extendContent.getXMLNS());
            if (child != null) {
                presence.removeChild(child);
            }
            presence.addChild((XMLNodeIfc)extendContent);
        }
        PresenceState.sendPresenceBroadcast(StanzaType.available, session, RosterAbstract.FROM_SUBSCRIBED, results, presence, null, PresenceState.getRosterUtil());
        PresenceState.updateUserResources(presence, session, results, false);
    }

    public void resendPendingInRequests(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies = this.roster_util.getBuddies(session, RosterAbstract.PENDING_IN);
        if (buddies != null) {
            for (JID buddy : buddies) {
                Element presence = new Element("presence");
                presence.setAttribute("type", StanzaType.subscribe.toString());
                presence.setXMLNS("jabber:client");
                Packet pres = Packet.packetInstance(presence, buddy, null);
                PresenceState.updatePresenceChange(pres, session, results);
            }
        }
    }

    protected void processError(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        if (session.isUserId(packet.getStanzaTo().getBareJID())) {
            Packet result = packet.copyElementOnly();
            result.setPacketTo(session.getConnectionId());
            result.setPacketFrom(packet.getTo());
            results.offer(result);
        }
    }

    protected void processInInitial(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NoConnectionIdException, NotAuthorizedException, TigaseDBException {
        Element dynItem;
        if (packet.getStanzaFrom() == null) {
            log.log(Level.WARNING, "Initial presence without from attribute set: {0}", packet);
            return;
        }
        String resource = packet.getStanzaTo().getResource();
        if (resource != null && !resource.isEmpty()) {
            XMPPResourceConnection direct = session.getParentSession().getResourceForResource(resource);
            if (direct != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Received direct presence from: {0} to: {1}", new Object[]{packet.getStanzaFrom(), packet.getStanzaTo()});
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(direct.getConnectionId());
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ignoring direct presence from: {0} to: {1}, resource gone.", new Object[]{packet.getStanzaFrom(), packet.getStanzaTo()});
            }
            return;
        }
        boolean online = StanzaType.unavailable != packet.getType();
        this.buddyOnline(session, packet.getStanzaFrom(), results, online);
        if (session.getPresence() == null) {
            return;
        }
        JID presBuddy = packet.getStanzaFrom().copyWithoutResource();
        try {
            dynItem = DynamicRoster.getBuddyItem(session, settings, presBuddy);
        }
        catch (RepositoryAccessException | RosterRetrievingException ex) {
            dynItem = null;
        }
        if (this.roster_util.isSubscribedTo(session, presBuddy) || dynItem != null) {
            RosterElement rel = this.roster_util.getRosterElement(session, presBuddy);
            if (rel != null) {
                rel.setLastSeen(System.currentTimeMillis());
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received initial presence, setting buddy: {0} online status to: {1}", new Object[]{packet.getStanzaFrom(), online});
            }
        }
        PresenceState.updatePresenceChange(packet, session, results);
    }

    protected void processInProbe(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType presenceType) throws NotAuthorizedException, TigaseDBException, PacketErrorTypeException {
        Element dynItem;
        RosterAbstract.SubscriptionType buddy_subscr = null;
        try {
            dynItem = DynamicRoster.getBuddyItem(session, settings, packet.getStanzaFrom());
        }
        catch (RepositoryAccessException | RosterRetrievingException ex) {
            dynItem = null;
        }
        buddy_subscr = dynItem != null ? RosterAbstract.SubscriptionType.both : this.roster_util.getBuddySubscription(session, packet.getStanzaFrom());
        if (buddy_subscr == null) {
            buddy_subscr = RosterAbstract.SubscriptionType.none;
        }
        if (this.roster_util.isSubscribedFrom(buddy_subscr)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received probe, setting buddy: {0} as online.", packet.getStanzaFrom());
            }
            if (packet.getStanzaFrom().getResource() != null) {
                this.roster_util.setOnline(session, packet.getStanzaFrom(), true);
            }
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                try {
                    Element pres = conn.getPresence();
                    if (pres == null) continue;
                    JID to = probeFullJID ? packet.getStanzaFrom() : packet.getStanzaFrom().copyWithoutResource();
                    PresenceState.sendPresence(null, null, to, results, pres);
                    this.roster_util.setPresenceSent(session, packet.getStanzaFrom(), true);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.log(Level.FINEST, "Received probe, sending presence response to: {0}", to);
                }
                catch (TigaseDBException | NotAuthorizedException pres) {}
            }
        } else if (!this.isAllowedForPresenceProbe(session, packet.getStanzaFrom())) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Received probe, users bare JID: {0} is not in the roster. Responding with unsubscribed", packet.getStanzaFrom().getBareJID());
            }
            PresenceState.sendPresence(StanzaType.unsubscribed, session.getBareJID(), packet.getStanzaFrom().getBareJID(), results, null);
        } else {
            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                Element pres = conn.getPresence();
                if (pres == null) continue;
                PresenceState.sendPresence(null, null, packet.getStanzaFrom(), results, pres);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Received probe, sending presence response to: {0}", packet.getStanzaFrom());
            }
        }
    }

    protected void processOutInitial(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings, RosterAbstract.PresenceType type) throws NotAuthorizedException, TigaseDBException {
        if (packet.getStanzaTo() != null) {
            Packet presence = packet.copyElementOnly();
            Element presenceEl = presence.getElement();
            for (ExtendedPresenceProcessorIfc processor : this.extendedPresenceProcessors) {
                Element extendContent = processor.extend(presenceEl, session, results);
                if (extendContent == null) continue;
                presenceEl.addChild((XMLNodeIfc)extendContent);
            }
            results.offer(presence);
            if (packet.getType() == StanzaType.unavailable) {
                PresenceState.removeDirectPresenceJID(packet.getStanzaTo(), session);
            } else {
                PresenceState.addDirectPresenceJID(packet.getStanzaTo(), session);
            }
        } else {
            ++this.usersStatusChanges;
            boolean first = false;
            if (session.getPresence() == null) {
                first = true;
            }
            Packet resultPacket = packet.copyElementOnly();
            resultPacket.initVars(session.getJID(), packet.getStanzaTo());
            Element presenceEl = resultPacket.getElement();
            for (ExtendedPresenceProcessorIfc processor : this.extendedPresenceProcessors) {
                Element extendContent = processor.extend(presenceEl, session, results);
                if (extendContent == null) continue;
                presenceEl.addChild((XMLNodeIfc)extendContent);
            }
            session.setPresence(presenceEl);
            if (!this.rosterLazyLoading || this.roster_util.isRosterLoaded(session)) {
                if (packet.getType() == null || packet.getType() == StanzaType.available) {
                    session.removeSessionData(OFFLINE_BUD_SENT);
                    session.removeSessionData(OFFLINE_RES_SENT);
                    if (first) {
                        try {
                            this.sendRosterOfflinePresence(session, results);
                        }
                        catch (TigaseDBException | NoConnectionIdException | NotAuthorizedException ex) {
                            log.log(Level.INFO, "Experimental code throws exception: ", ex);
                        }
                        this.broadcastProbe(session, results, settings);
                        this.resendPendingInRequests(session, results);
                    } else {
                        PresenceState.sendPresenceBroadcast(StanzaType.available, session, RosterAbstract.FROM_SUBSCRIBED, results, presenceEl, settings, this.roster_util);
                    }
                    PresenceState.updateUserResources(presenceEl, session, results, first);
                } else {
                    this.stopped(session, results, settings);
                }
                JID forwardTo = session.getDomain().getPresenceForward();
                if (forwardTo == null) {
                    forwardTo = this.presenceGLobalForward;
                }
                if (forwardTo != null) {
                    PresenceState.sendPresence(null, session.getJID(), forwardTo, results, presenceEl);
                }
            } else {
                Element iq = new Element("iq", new String[]{"type"}, new String[]{"set"});
                Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:roster-load"});
                iq.addChild((XMLNodeIfc)query);
                Packet loadCmd = Packet.packetInstance(iq, packet.getStanzaFrom(), packet.getStanzaTo());
                loadCmd.setPacketFrom(packet.getPacketFrom());
                loadCmd.setPacketTo(packet.getPacketTo());
                results.add(loadCmd);
            }
        }
    }

    protected void buddyOnline(XMPPResourceConnection session, JID buddy, Queue<Packet> results, boolean online) throws NotAuthorizedException, TigaseDBException {
        Element pres;
        this.roster_util.setOnline(session, buddy, online);
        if (online && skipOffline && !this.roster_util.presenceSent(session, buddy) && this.roster_util.isSubscribedFrom(session, buddy) && (pres = session.getPresence()) != null) {
            PresenceState.sendPresence(null, null, buddy, results, pres);
            this.roster_util.setPresenceSent(session, buddy, true);
        }
    }

    protected void sendRosterOfflinePresence(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        Object[] buddies;
        if (this.offlineRosterLastSeen == null) {
            log.finest("No clients specified in config, skipping...");
            return;
        }
        Element pres = session.getPresence();
        if (pres == null) {
            log.finest("Presence not set yet, skipping...");
            return;
        }
        String node = pres.getAttributeStaticStr(PRESENCE_C_PATH, "node");
        if (node == null) {
            log.finest("Presence node not set, skipping...");
            return;
        }
        boolean validClient = false;
        int i = 0;
        if (this.offlineRosterLastSeen.length > 0 && !this.offlineRosterLastSeen[0].equals("*")) {
            while (i < this.offlineRosterLastSeen.length && !(validClient |= node.contains(this.offlineRosterLastSeen[i++]))) {
            }
            if (!validClient) {
                log.finest("Client does not match, skipping...");
                return;
            }
        }
        if ((buddies = this.roster_util.getBuddies(session, RosterAbstract.TO_SUBSCRIBED)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Buddies found: {0}", Arrays.toString(buddies));
            }
            Priority pack_priority = Priority.PRESENCE;
            int pres_cnt = 0;
            for (Object buddy : buddies) {
                List<Element> children = this.roster_util.getCustomChildren(session, (JID)buddy);
                if (children == null || children.isEmpty()) continue;
                Packet pack = PresenceState.sendPresence(StanzaType.unavailable, (JID)buddy, session.getJID(), results, null);
                if (pres_cnt == HIGH_PRIORITY_PRESENCES_NO) {
                    ++pres_cnt;
                    pack_priority = Priority.LOWEST;
                }
                pack.setPriority(pack_priority);
                pack.setPacketTo(session.getConnectionId());
                for (Element child : children) {
                    pack.getElement().addChild((XMLNodeIfc)child);
                }
            }
        }
    }

    private boolean isAllowedForPresenceProbe(XMPPResourceConnection session, JID jid) {
        if (jid == null) {
            return false;
        }
        return session.getDomain().isTrustedJID(jid);
    }

    public static interface ExtendedPresenceProcessorIfc {
        default public Element extend(Element presence, XMPPResourceConnection session, Queue<Packet> results) {
            return this.extend(session, results);
        }

        public Element extend(XMPPResourceConnection var1, Queue<Packet> var2);
    }
}

