/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.security.SecureRandom;
import java.util.Random;
import tigase.kernel.beans.Bean;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqRegister;

@Bean(name="CaptchaProvider", parent=JabberIqRegister.class, active=true)
public class CaptchaProvider {
    private Random random = new SecureRandom();

    public CaptchaItem generateCaptcha() {
        return new SimpleTextCaptcha(1 + this.random.nextInt(31), 1 + this.random.nextInt(31));
    }

    private class SimpleTextCaptcha
    implements CaptchaItem {
        private final int a;
        private final int b;
        private int errorCounter;

        SimpleTextCaptcha(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public String getCaptchaRequest(XMPPResourceConnection session) {
            return "Solve: " + String.valueOf(this.a) + " + " + String.valueOf(this.b);
        }

        @Override
        public int getErrorCounter() {
            return this.errorCounter;
        }

        @Override
        public void incraseErrorCounter() {
            ++this.errorCounter;
        }

        @Override
        public boolean isResponseValid(XMPPResourceConnection session, String response) {
            if (response == null) {
                return false;
            }
            int v = this.a + this.b;
            return response.trim().equals(String.valueOf(v));
        }
    }

    public static interface CaptchaItem {
        public String getCaptchaRequest(XMPPResourceConnection var1);

        public int getErrorCounter();

        public void incraseErrorCounter();

        public boolean isResponseValid(XMPPResourceConnection var1, String var2);
    }
}

