/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;

public class MaxDailyCounterQueue<E extends Number>
extends ConcurrentLinkedDeque<E> {
    private final int maxQueueLength;
    private LocalDate lastDailyStatsReset = LocalDate.now();
    private String toString = "[]";

    public MaxDailyCounterQueue(int maxQueueLength) {
        this.maxQueueLength = maxQueueLength;
    }

    @Override
    public boolean add(E added) {
        if (this.isNextItem() || this.peekLast() == null) {
            super.add(added);
        } else if (((Comparable)((Object)((Number)this.peekLast()))).compareTo(added) < 0) {
            this.removeLast();
            super.add(added);
        }
        while (this.size() > this.maxQueueLength) {
            super.remove();
        }
        this.toString = super.toString();
        return true;
    }

    public Optional<E> getMaxValue() {
        return this.getMaxValueInRange(this.maxQueueLength);
    }

    public Optional<E> getMaxValueInRange(int range) {
        Number result = null;
        Iterator iterator = this.descendingIterator();
        for (range = Math.min(range, this.maxQueueLength); iterator.hasNext() && range > 0; --range) {
            Number next = (Number)iterator.next();
            if (result != null && ((Comparable)((Object)next)).compareTo(result) <= 0) continue;
            result = next;
        }
        return Optional.ofNullable(result);
    }

    public boolean isLimitSurpassed(E limit) {
        return this.isLimitSurpassed(this.maxQueueLength, limit);
    }

    public boolean isLimitSurpassed(int range, E limit) {
        return this.getMaxValueInRange(range).filter(e -> ((Comparable)((Object)e)).compareTo(limit) > 0).isPresent();
    }

    public boolean isLimitSurpassedAllItems(E limit) {
        return this.isLimitSurpassedAllItems(this.maxQueueLength, limit);
    }

    public boolean isLimitSurpassedAllItems(int range, E limit) {
        boolean result = true;
        range = Math.min(range, this.maxQueueLength);
        Iterator iter = this.descendingIterator();
        while (iter.hasNext() && range > 0) {
            --range;
            Number next = (Number)iter.next();
            if (((Comparable)((Object)next)).compareTo(limit) > 0) continue;
            result &= false;
        }
        return result;
    }

    public ArrayDeque<E> subQueue(int range) {
        ArrayDeque result = new ArrayDeque(range);
        Iterator iter = this.descendingIterator();
        for (range = Math.min(range, this.maxQueueLength); iter.hasNext() && range > 0; --range) {
            result.add(iter.next());
        }
        return result;
    }

    protected boolean isNextItem() {
        LocalDate now = LocalDate.now();
        if (now.getYear() != this.lastDailyStatsReset.getYear() || now.getDayOfYear() != this.lastDailyStatsReset.getDayOfYear()) {
            this.lastDailyStatsReset = LocalDate.now();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

