/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentIOService;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.util.Base64;
import tigase.xml.Element;

public class SASLProcessor
implements ExtProcessor {
    private static final Logger log = Logger.getLogger(SASLProcessor.class.getName());
    private static final String ID = "sasl";
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final Element FEATURES = new Element("mechanisms", new Element[]{new Element("mechanism", "PLAIN")}, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"});

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public List<Element> getStreamFeatures(ComponentIOService serv, ComponentProtocolHandler handler) {
        if (serv.getSessionData().get(ID) != null) {
            return null;
        }
        return Arrays.asList(FEATURES);
    }

    @Override
    public boolean process(Packet p, ComponentIOService serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        if (p.isElement("auth", XMLNS)) {
            String local_password;
            String cdata = p.getElemCData();
            Object[] credentials = this.decodeMessage(cdata);
            log.fine("External credentials: " + Arrays.toString(credentials));
            CompRepoItem repo_item = handler.getCompRepoItem((String)credentials[1]);
            boolean auth_ok = false;
            if (repo_item != null && (local_password = repo_item.getAuthPasswd()).equals(credentials[2])) {
                auth_ok = true;
            }
            if (auth_ok) {
                Element success = new Element("success", new String[]{"xmlns"}, new String[]{XMLNS});
                results.offer(Packet.packetInstance(success, null, null));
                handler.authenticated(serv);
            } else {
                Element failure = new Element("failure", new Element[]{new Element("not-authorized")}, new String[]{"xmlns"}, new String[]{XMLNS});
                handler.authenticationFailed(serv, Packet.packetInstance(failure, null, null));
            }
            serv.getSessionData().put(ID, ID);
            return true;
        }
        if (p.isElement("success", XMLNS)) {
            handler.authenticated(serv);
            serv.getSessionData().put(ID, ID);
            return true;
        }
        if (p.isElement("abort", XMLNS)) {
            serv.stop();
            return true;
        }
        if (p.isElement("failure", XMLNS)) {
            serv.stop();
            return true;
        }
        return false;
    }

    @Override
    public void startProcessing(Packet p, ComponentIOService serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        CompRepoItem comp_item = (CompRepoItem)serv.getSessionData().get("repo-item");
        String domain = comp_item.getDomain();
        String secret = comp_item.getAuthPasswd();
        String challenge = this.encodeMessage(null, domain, secret);
        Element auth = new Element("auth", challenge, new String[]{"xmlns", "mechanism"}, new String[]{XMLNS, "PLAIN"});
        results.offer(Packet.packetInstance(auth, null, null));
    }

    private String[] decodeMessage(String input) {
        int user_idx;
        int auth_idx;
        String[] result = new String[3];
        byte[] challenge = Base64.decode((String)input);
        for (auth_idx = 0; challenge[auth_idx] != 0 && auth_idx < challenge.length; ++auth_idx) {
        }
        String authoriz = new String(challenge, 0, auth_idx);
        for (user_idx = ++auth_idx; challenge[user_idx] != 0 && user_idx < challenge.length; ++user_idx) {
        }
        String user_id = new String(challenge, auth_idx, user_idx - auth_idx);
        String passwd = new String(challenge, ++user_idx, challenge.length - user_idx);
        result[0] = authoriz.length() > 0 ? authoriz : null;
        result[1] = user_id.length() > 0 ? user_id : null;
        result[2] = passwd.length() > 0 ? passwd : null;
        return result;
    }

    private String encodeMessage(String authoriz, String user_id, String password) {
        int authoriz_size = authoriz != null ? authoriz.getBytes().length : 0;
        int user_id_size = user_id != null ? user_id.getBytes().length : 0;
        int password_size = password != null ? password.getBytes().length : 0;
        int size = 2;
        byte[] result = new byte[size += authoriz_size + user_id_size + password_size];
        if (authoriz != null && authoriz_size > 0) {
            System.arraycopy(authoriz.getBytes(), 0, result, 0, authoriz_size);
        }
        result[authoriz_size] = 0;
        if (user_id != null && user_id_size > 0) {
            System.arraycopy(user_id.getBytes(), 0, result, authoriz_size + 1, user_id_size);
        }
        result[authoriz_size + 1 + user_id_size] = 0;
        if (password != null && password_size > 0) {
            System.arraycopy(password.getBytes(), 0, result, authoriz_size + 1 + user_id_size + 1, password_size);
        }
        return Base64.encode((byte[])result);
    }
}

