/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTask;
import tigase.util.StringUtilities;
import tigase.util.datetime.TimestampHelper;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.dns.DNSResolverIfc;
import tigase.util.log.LogFormatter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;

@Bean(name="logger-task", parent=MonitorComponent.class, active=true)
public class LoggerTask
extends AbstractConfigurableTask
implements Initializable {
    public static final Logger log = Logger.getLogger(LoggerTask.class.getName());
    protected static final TimestampHelper dtf = new TimestampHelper();
    private static final String[] decoded = new String[]{"&", "<", ">", "\"", "'"};
    private static final String[] encoded = new String[]{"&amp;", "[", "]", "&quot;", "&apos;"};
    private static final String LOGGER_MONITOR_EVENT_NAME = "tigase.monitor.tasks.LoggerMonitorEvent";
    @Inject
    protected MonitorComponent component;
    @Inject
    protected EventBus eventBus;
    private long lastWarningSent = 0L;
    @ConfigField(desc="Log Level Threshold")
    private Level levelTreshold = Level.WARNING;
    private long logWarings = 0L;
    private int loggerSize = 50;
    private int maxLogBuffer = 1000000;
    private MemoryHandlerFlush memoryHandler = null;
    private MonitorHandler monitorHandler = null;

    @Override
    public Form getCurrentConfiguration() {
        Form f = super.getCurrentConfiguration();
        Field x = Field.fieldListSingle((String)"levelTreshold", (String)this.levelTreshold.getName(), (String)"Log level threshold", (String[])new String[]{Level.SEVERE.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()}, (String[])new String[]{Level.SEVERE.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()});
        f.addField(x);
        return f;
    }

    public Level getLevelTreshold() {
        return this.levelTreshold;
    }

    public void setLevelTreshold(String levelTreshold) {
        boolean reregister = false;
        if (levelTreshold != null) {
            Level v = Level.parse(levelTreshold);
            reregister |= !v.equals(this.levelTreshold);
            this.levelTreshold = v;
        }
        if (reregister) {
            this.registerHandler();
        }
        log.log(Level.FINEST, "Set log level treshold to " + this.levelTreshold);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(LOGGER_MONITOR_EVENT_NAME, "Fired when logger receives with specific level", false);
    }

    public void sendWarningOut(String logBuff) {
        Element event = new Element(LOGGER_MONITOR_EVENT_NAME);
        DNSResolverIfc dnsResolver = DNSResolverFactory.getInstance();
        event.addChild((XMLNodeIfc)new Element("timestamp", "" + dtf.format(new Date())));
        event.addChild((XMLNodeIfc)new Element("hostname", String.valueOf(dnsResolver.getDefaultHost())));
        event.addChild((XMLNodeIfc)new Element("external_hostname", String.valueOf(dnsResolver.getSecondaryHost())));
        event.addChild((XMLNodeIfc)new Element("log", logBuff));
        this.eventBus.fire(event);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field f = form.get("levelTreshold");
        if (f != null) {
            this.setLevelTreshold(f.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void disable() {
        this.removeHandler();
        super.disable();
    }

    @Override
    protected void enable() {
        this.registerHandler();
        super.enable();
    }

    private void registerHandler() {
        this.removeHandler();
        if (this.monitorHandler == null) {
            this.monitorHandler = new MonitorHandler();
            this.monitorHandler.setLevel(Level.ALL);
        }
        this.memoryHandler = new MemoryHandlerFlush(this.monitorHandler, this.loggerSize, this.levelTreshold);
        this.memoryHandler.setLevel(Level.ALL);
        Logger.getLogger("").addHandler(this.memoryHandler);
    }

    private void removeHandler() {
        if (this.memoryHandler != null) {
            Logger.getLogger("").removeHandler(this.memoryHandler);
        }
    }

    private class MonitorHandler
    extends Handler {
        private Formatter formatter = new LogFormatter(false);
        private LinkedList<String> logs = new LinkedList();

        private MonitorHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public synchronized void flush() {
            ++LoggerTask.this.logWarings;
            if (System.currentTimeMillis() - LoggerTask.this.lastWarningSent > 300000L) {
                String logBuff = this.logsToString();
                LoggerTask.this.sendWarningOut(logBuff);
                LoggerTask.this.lastWarningSent = System.currentTimeMillis();
            }
        }

        public synchronized String logsToString() {
            StringBuilder sb = new StringBuilder();
            String logEntry = null;
            while ((logEntry = this.logs.pollLast()) != null && sb.length() < LoggerTask.this.maxLogBuffer) {
                sb.insert(0, logEntry);
            }
            this.logs.clear();
            String result = sb.length() <= LoggerTask.this.maxLogBuffer ? sb.toString() : sb.substring(sb.length() - LoggerTask.this.maxLogBuffer);
            return result;
        }

        @Override
        public synchronized void publish(LogRecord record) {
            String logEntry = XMLUtils.translateAll((String)this.formatter.format(record), (String[])decoded, (String[])encoded);
            String unicodeLiteral = StringUtilities.convertNonPrintableCharactersToLiterals((String)logEntry, (boolean)true);
            this.logs.add(unicodeLiteral);
        }
    }

    private class MemoryHandlerFlush
    extends MemoryHandler {
        MonitorHandler monHandle;

        public MemoryHandlerFlush(MonitorHandler target, int size, Level pushLevel) {
            super(target, size, pushLevel);
            this.monHandle = null;
            this.monHandle = target;
        }

        @Override
        public void push() {
            super.push();
            this.flush();
        }

        public String pushToString() {
            super.push();
            return this.monHandle.logsToString();
        }
    }
}

