/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.SessionManager;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="connections-task", parent=MonitorComponent.class, active=true)
public class ConnectionsTask
extends AbstractConfigurableTimerTask
implements InfoTask,
Initializable {
    protected static final TimestampHelper dtf = new TimestampHelper();
    protected static final Logger log = Logger.getLogger(ConnectionsTask.class.getName());
    private static final String USERS_DISCONNECTEED_EVENT_NAME = "tigase.monitor.tasks.UsersDisconnected";
    @Inject
    protected MonitorComponent component;
    @Inject
    protected EventBus eventBus;
    private int lastOnlineUsers;
    @ConfigField(desc="Percent of disconnected users")
    private int threshold = 80;
    @ConfigField(desc="Minimal amount of disconnected users")
    private int thresholdMinimal = 10;

    public static Element createAlarmEvent(int currentOnlineUsers, int lastOnlineUsers, int thresholdMinimal, int threshold) {
        int delta = currentOnlineUsers - lastOnlineUsers;
        float percent = (lastOnlineUsers == 0 ? 1.0f : (float)delta / (float)lastOnlineUsers) * 100.0f;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Data: lastOnlineUsers=" + lastOnlineUsers + "; currentOnlineUsers=" + currentOnlineUsers + "; delta=" + delta + "; percent=" + percent + "; thresholdMinimal=" + thresholdMinimal + "; threshold=" + threshold);
        }
        if (-1 * delta >= thresholdMinimal && -1.0f * percent >= (float)threshold) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Creating event!");
            }
            Element event = new Element(USERS_DISCONNECTEED_EVENT_NAME);
            event.addChild((XMLNodeIfc)new Element("timestamp", "" + dtf.format(new Date())));
            event.addChild((XMLNodeIfc)new Element("disconnections", "" + -1 * delta));
            event.addChild((XMLNodeIfc)new Element("disconnectionsPercent", "" + -1.0f * percent));
            return event;
        }
        return null;
    }

    @Override
    public Form getCurrentConfiguration() {
        Form x = super.getCurrentConfiguration();
        x.addField(Field.fieldTextSingle((String)"threshold", (String)("" + this.threshold), (String)"Percent of disconnected users"));
        x.addField(Field.fieldTextSingle((String)"thresholdMinimal", (String)("" + this.thresholdMinimal), (String)"Minimal amount of disconnected users"));
        return x;
    }

    @Override
    public Form getTaskInfo() {
        Form x = new Form("", "Task Info", "");
        x.addField(Field.fieldTextSingle((String)"lastUsersOnline", (String)("" + this.lastOnlineUsers), (String)"Last measured online users"));
        return x;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThresholdMinimal() {
        return this.thresholdMinimal;
    }

    public void setThresholdMinimal(int thresholdMinimal) {
        this.thresholdMinimal = thresholdMinimal;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(USERS_DISCONNECTEED_EVENT_NAME, "Fired when too many users disconnected in the same time", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field thresholdNetto;
        Field thresholdPercent = form.get("threshold");
        if (thresholdPercent != null) {
            this.threshold = Integer.parseInt(thresholdPercent.getValue());
        }
        if ((thresholdNetto = form.get("thresholdMinimal")) != null) {
            this.thresholdMinimal = Integer.parseInt(thresholdNetto.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void run() {
        SessionManager sess;
        int currentOnlineUsers;
        Element event;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Running task...");
        }
        if ((event = ConnectionsTask.createAlarmEvent(currentOnlineUsers = (sess = XMPPServer.getComponent(SessionManager.class)).getOpenUsersConnectionsAmount(), this.lastOnlineUsers, this.thresholdMinimal, this.threshold)) != null) {
            event.addChild((XMLNodeIfc)new Element("hostname", this.component.getDefHostName().toString()));
            this.eventBus.fire(event);
        }
        this.lastOnlineUsers = currentOnlineUsers;
    }
}

