/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import tigase.annotations.TigaseDeprecated;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.xmpp.jid.BareJID;

public interface UserRepository
extends Repository {
    public void addDataList(BareJID var1, String var2, String var3, String[] var4) throws UserNotFoundException, TigaseDBException;

    public void addUser(BareJID var1) throws UserExistsException, TigaseDBException;

    public String getData(BareJID var1, String var2, String var3, String var4) throws UserNotFoundException, TigaseDBException;

    public String getData(BareJID var1, String var2, String var3) throws UserNotFoundException, TigaseDBException;

    public String getData(BareJID var1, String var2) throws UserNotFoundException, TigaseDBException;

    default public Map<String, String> getDataMap(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        String[] keys = this.getKeys(user, subnode);
        if (keys != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            for (String key : keys) {
                data.put(key, this.getData(user, subnode, key));
            }
            return data;
        }
        return Collections.emptyMap();
    }

    default public <T> Map<String, T> getDataMap(BareJID user, String subnode, Function<String, T> converter) throws UserNotFoundException, TigaseDBException {
        String[] keys = this.getKeys(user, subnode);
        if (keys != null) {
            HashMap<String, T> data = new HashMap<String, T>();
            for (String key : keys) {
                String value = this.getData(user, subnode, key);
                if (value != null) {
                    data.put(key, converter.apply(value));
                    continue;
                }
                data.put(key, null);
            }
            return data;
        }
        return Collections.emptyMap();
    }

    public String[] getDataList(BareJID var1, String var2, String var3) throws UserNotFoundException, TigaseDBException;

    public String[] getKeys(BareJID var1, String var2) throws UserNotFoundException, TigaseDBException;

    public String[] getKeys(BareJID var1) throws UserNotFoundException, TigaseDBException;

    public String getResourceUri();

    public String[] getSubnodes(BareJID var1, String var2) throws UserNotFoundException, TigaseDBException;

    public String[] getSubnodes(BareJID var1) throws UserNotFoundException, TigaseDBException;

    @Deprecated
    @TigaseDeprecated(since="8.0.0")
    public long getUserUID(BareJID var1) throws TigaseDBException;

    public List<BareJID> getUsers() throws TigaseDBException;

    public long getUsersCount();

    public long getUsersCount(String var1);

    public void removeData(BareJID var1, String var2, String var3) throws UserNotFoundException, TigaseDBException;

    public void removeData(BareJID var1, String var2) throws UserNotFoundException, TigaseDBException;

    public void removeSubnode(BareJID var1, String var2) throws UserNotFoundException, TigaseDBException;

    public void removeUser(BareJID var1) throws UserNotFoundException, TigaseDBException;

    public void setData(BareJID var1, String var2, String var3, String var4) throws UserNotFoundException, TigaseDBException;

    public void setData(BareJID var1, String var2, String var3) throws UserNotFoundException, TigaseDBException;

    public void setDataList(BareJID var1, String var2, String var3, String[] var4) throws UserNotFoundException, TigaseDBException;

    public boolean userExists(BareJID var1);

    public static class UserRemovedEvent {
        public final BareJID jid;

        public UserRemovedEvent(BareJID jid) {
            this.jid = jid;
        }
    }
}

