/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecordIfc;
import tigase.eventbus.FillRoutedEvent;
import tigase.eventbus.RouteEvent;
import tigase.eventbus.component.stores.Subscription;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.ComponentInfo;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.UserSessionEvent;
import tigase.server.xmppsession.UserSessionEventWithProcessorResultWriter;
import tigase.stats.StatisticsList;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="sess-man", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode})
@ClusterModeRequired(active=true)
public class SessionManagerClustered
extends SessionManager
implements ClusteredComponentIfc,
SessionManagerClusteredIfc {
    public static final String CLUSTER_STRATEGY_VAR = "clusterStrategy";
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String STRATEGY_CLASS_PROP_KEY = "sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.DefaultClusteringStrategy";
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final int SYNC_MAX_BATCH_SIZE = 1000;
    private static final Logger log = Logger.getLogger(SessionManagerClustered.class.getName());
    private ClusterControllerIfc clusterController = null;
    private ComponentInfo cmpInfo = null;
    @ConfigField(desc="Component own internal JID")
    private JID my_address;
    @ConfigField(desc="Server domain name")
    private JID my_hostname;
    private int nodesNo = 0;
    @Inject
    private ClusteringStrategyIfc strategy = null;

    public SessionManagerClustered() {
        String[] local_domains = DNSResolverFactory.getInstance().getDefaultHosts();
        String my_domain = local_domains[0];
        try {
            this.my_hostname = JID.jidInstance((String)my_domain);
            this.my_address = JID.jidInstance((String)this.getName(), (String)my_domain, null);
        }
        catch (TigaseStringprepException e) {
            log.log(Level.WARNING, "Creating component source address failed stringprep processing: {0}@{1}", new Object[]{this.getName(), this.my_hostname});
        }
    }

    @Override
    public boolean containsJid(BareJID jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for jid: {0}", jid);
        }
        return super.containsJid(jid) || this.strategy.containsJid(jid);
    }

    @Override
    public synchronized void everySecond() {
        super.everySecond();
        if (this.strategy != null) {
            this.strategy.everySecond();
        }
    }

    @Override
    public synchronized void everyMinute() {
        super.everyMinute();
        if (this.strategy != null) {
            this.strategy.everyMinute();
        }
    }

    @Override
    public synchronized void everyHour() {
        super.everyHour();
        if (this.strategy != null) {
            this.strategy.everyHour();
        }
    }

    @Override
    public boolean fastAddOutPacket(Packet packet) {
        return super.fastAddOutPacket(packet);
    }

    @Override
    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
        if (this.strategy != null) {
            this.strategy.handleLocalPacket(packet, conn);
        }
    }

    @Override
    public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        super.handleLogin(userId, conn);
        this.strategy.handleLocalUserLogin(userId, conn);
    }

    @Override
    public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        try {
            if (conn.isAuthorized() && conn.isResourceSet()) {
                this.strategy.handleLocalUserLogout(userId, conn);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
        super.handleLogout(userId, conn);
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        super.handleResourceBind(conn);
        this.strategy.handleLocalResourceBind(conn);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(CLUSTER_STRATEGY_VAR, (Object)this.strategy);
    }

    @Override
    public void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        if (!this.getComponentId().equals((Object)jid)) {
            this.strategy.nodeConnected(jid);
            this.sendAdminNotification(jid.getDomain(), STATUS.CONNECTED);
        }
    }

    @Override
    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        if (!this.getComponentId().equals((Object)jid)) {
            this.strategy.nodeDisconnected(jid);
            this.sendAdminNotification(jid.getDomain(), STATUS.DISCONNECTED);
        }
    }

    @Override
    public int processingInThreads() {
        return Math.max(this.nodesNo, super.processingInThreads());
    }

    @Override
    public int processingOutThreads() {
        return Math.max(this.nodesNo, super.processingOutThreads());
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Received packet: {0}", packet);
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
        } else {
            XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Ressource connection found: {0}", conn);
            }
            boolean clusterOK = this.strategy.processPacket(packet, conn);
            if (conn == null) {
                if (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Ignoring/dropping packet: {0}", packet);
                    }
                } else if (!clusterOK) {
                    this.processPacket(packet, (XMPPResourceConnection)null);
                }
            } else {
                this.processPacket(packet, conn);
            }
        }
    }

    @Override
    public void processPacket(Packet packet, XMPPResourceConnection conn) {
        super.processPacket(packet, conn);
    }

    @Override
    public void processPresenceUpdate(XMPPSession session, Element packet) {
        super.processPresenceUpdate(session, packet);
    }

    @Override
    public ComponentInfo getComponentInfo() {
        this.cmpInfo = super.getComponentInfo();
        this.cmpInfo.getComponentData().put("ClusteringStrategy", this.strategy != null ? this.strategy.getClass() : null);
        return this.cmpInfo;
    }

    @Override
    public JID[] getConnectionIdsForJid(BareJID jid) {
        Object[] ids = super.getConnectionIdsForJid(jid);
        if (ids == null) {
            ids = this.strategy.getConnectionIdsForJid(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for jid: {0}, results: {1}", new Object[]{jid, Arrays.toString(ids)});
        }
        return ids;
    }

    @Override
    public String getDiscoDescription() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "disco description from SM Clustered");
        }
        String result = super.getDiscoDescription();
        result = result + " clustered, ";
        result = result + this.strategy;
        return result;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (this.strategy != null) {
            this.strategy.getStatistics(list);
        }
    }

    public ClusteringStrategyIfc getStrategy() {
        return this.strategy;
    }

    @Override
    public XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        return super.getXMPPResourceConnection(p);
    }

    @Override
    public ConcurrentHashMap<JID, XMPPResourceConnection> getXMPPResourceConnections() {
        return this.connectionsByFrom;
    }

    @Override
    public ConcurrentHashMap<BareJID, XMPPSession> getXMPPSessions() {
        return this.sessionsByNodeId;
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return this.strategy.hasCompleteJidsInfo();
    }

    @Override
    public boolean hasXMPPResourceConnectionForConnectionJid(JID connJid) {
        return this.connectionsByFrom.containsKey(connJid);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        this.clusterController = cl_controller;
        if (this.strategy != null) {
            this.strategy.setClusterController(this.clusterController);
        }
    }

    @FillRoutedEvent
    protected boolean fillRoutedUserSessionWithProcessorResultWriter(UserSessionEventWithProcessorResultWriter event) {
        event.setPacketWriter(this::addOutPackets);
        return true;
    }

    @FillRoutedEvent
    protected boolean fillRoutedUserSessionEvent(UserSessionEvent event) {
        XMPPSession session = this.getSession(event.getUserJid().getBareJID());
        if (session != null && (event.getUserJid().getResource() == null || session.getResourceForResource(event.getUserJid().getResource()) != null)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "for event {0} setting session to {1}", new Object[]{event, session});
            }
            event.setSession(session);
            return true;
        }
        return false;
    }

    @RouteEvent
    protected Collection<Subscription> routeUserSessionEvent(UserSessionEvent event, Collection<Subscription> subscriptions) {
        if (this.strategy.hasCompleteJidsInfo()) {
            Iterator<Object> it;
            Set<Object> records = this.strategy.getConnectionRecords(event.getUserJid().getBareJID());
            if (records == null) {
                records = Collections.emptySet();
            }
            if (event.getUserJid().getResource() != null) {
                it = records.iterator();
                while (it.hasNext()) {
                    if (((ConnectionRecordIfc)it.next()).getUserJid().equals((Object)event.getUserJid())) continue;
                    it.remove();
                }
            }
            it = subscriptions.iterator();
            while (it.hasNext()) {
                Subscription s = (Subscription)it.next();
                if (!s.isInClusterSubscription()) continue;
                boolean remove = true;
                for (ConnectionRecordIfc rec : records) {
                    if (!rec.getNode().getDomain().equals(s.getJid().getDomain())) continue;
                    remove = false;
                }
                if (!remove) continue;
                it.remove();
            }
        }
        return subscriptions;
    }

    @Override
    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Called for conn: {0}, closeOnly: {1}", new Object[]{conn, closeOnly});
        }
        try {
            if (conn.isAuthorized() && conn.isResourceSet()) {
                BareJID userId = conn.getBareJID();
                this.strategy.handleLocalUserLogout(userId, conn);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
        try {
            super.closeSession(conn, closeOnly);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
    }

    @Override
    protected void xmppStreamMoved(XMPPResourceConnection conn, JID oldConnId, JID newConnId) {
        try {
            this.strategy.handleLocalUserChangedConnId(conn.getBareJID(), conn, oldConnId, newConnId);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
        }
        super.xmppStreamMoved(conn, oldConnId, newConnId);
    }

    private void sendAdminNotification(String node, STATUS stat) {
        String message = String.format("Cluster node %1$s %2$s: %3$s (%4$s)", String.valueOf(node), stat.message, String.valueOf(this.getDefHostName().getDomain()), LocalDateTime.now().toString());
        JID from = this.vHostManager != null ? JID.jidInstance((BareJID)this.vHostManager.getDefVHostItem()) : this.my_address;
        Packet p_msg = Message.getMessage(from, this.my_hostname, StanzaType.chat, message, null, "cluster_status_update", this.newPacketId(null));
        this.sendToAdmins(p_msg);
    }

    private static enum STATUS {
        CONNECTED("connected to"),
        DISCONNECTED("disconnected from");

        String message;

        private STATUS(String message) {
            this.message = message;
        }
    }
}

