/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.SessionAware;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.AuthorizationIdCallback;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.auth.credentials.Credentials;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.db.AuthRepository;
import tigase.db.UserNotFoundException;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

public class PlainCallbackHandler
implements CallbackHandler,
AuthRepositoryAware,
DomainAware,
SessionAware {
    protected String domain;
    protected BareJID jid = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected AuthRepository repo;
    private boolean loggingInForbidden = false;
    private XMPPResourceConnection session;
    private String credentialId;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
            }
            this.handleCallback(callbacks[i]);
        }
    }

    @Override
    public void setAuthRepository(AuthRepository repo) {
        this.repo = repo;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void setSession(XMPPResourceConnection session) {
        this.session = session;
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId = authCallback.getAuthenticationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
        }
        if (this.loggingInForbidden) {
            authCallback.setAuthorized(false);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "User {0} is disabled", this.jid);
            }
            return;
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        authCallback.setAuthorized(true);
        this.session.removeSessionData("authentication-jid");
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof RealmCallback) {
            this.handleRealmCallback((RealmCallback)callback);
        } else if (callback instanceof NameCallback) {
            this.handleNameCallback((NameCallback)callback);
        } else if (callback instanceof AuthorizationIdCallback) {
            this.handleAuthorizationIdCallback((AuthorizationIdCallback)callback);
        } else if (callback instanceof VerifyPasswordCallback) {
            this.handleVerifyPasswordCallback((VerifyPasswordCallback)callback);
        } else if (callback instanceof AuthorizeCallback) {
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        this.credentialId = "default";
        BareJID jid = BareJID.bareJIDInstanceNS((String)nc.getDefaultName());
        if (jid.getLocalpart() == null || !this.domain.equalsIgnoreCase(jid.getDomain())) {
            jid = BareJID.bareJIDInstanceNS((String)nc.getDefaultName(), (String)this.domain);
        }
        this.setJid(jid);
        nc.setName(jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", this.credentialId);
        }
    }

    protected void handleRealmCallback(RealmCallback rc) throws IOException {
        String realm = this.domain;
        if (realm != null) {
            rc.setText(realm);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "RealmCallback: {0}", realm);
        }
    }

    protected void handleVerifyPasswordCallback(VerifyPasswordCallback pc) throws IOException {
        String password = pc.getPassword();
        try {
            boolean verified;
            Credentials credentials = this.repo.getCredentials(this.jid, this.credentialId);
            Credentials.Entry entry = credentials.getEntryForMechanism("PLAIN");
            if (entry == null) {
                entry = credentials.getFirst();
            }
            this.loggingInForbidden = !credentials.canLogin();
            boolean bl = verified = !this.loggingInForbidden && entry != null && entry.verifyPlainPassword(password);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Verification result: {0}, loggingInForbidden: {1}, entry: {2}, credentials: {3}", new Object[]{verified, this.loggingInForbidden, entry, credentials});
            }
            pc.setVerified(verified);
        }
        catch (UserNotFoundException e) {
            this.log.log(Level.FINE, "User not found: " + e);
            pc.setVerified(false);
        }
        catch (Exception e) {
            throw new IOException("Password verification problem.", e);
        }
    }

    private void handleAuthorizationIdCallback(AuthorizationIdCallback callback) throws XmppSaslException {
        if (!AbstractSasl.isAuthzIDIgnored() && callback.getAuthzId() != null && !callback.getAuthzId().equals(this.jid.toString())) {
            try {
                this.credentialId = this.jid.getLocalpart();
                this.setJid(BareJID.bareJIDInstance((String)callback.getAuthzId()));
            }
            catch (TigaseStringprepException ex) {
                this.log.warning("Malformed AuthorizationId: " + ex.getMessage());
                throw new XmppSaslException(XmppSaslException.SaslError.invalid_authzid);
            }
        } else {
            this.credentialId = "default";
            callback.setAuthzId(this.jid.toString());
        }
    }

    private void setJid(BareJID jid) {
        this.jid = jid;
        if (jid != null) {
            this.session.putSessionData("authentication-jid", jid);
        }
    }
}

