/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MucDAOOld
implements Initializable {
    public static final String ROOMS_KEY = "rooms/";
    private static final String CREATION_DATE_KEY = "creation-date";
    private static final String CREATOR_JID_KEY = "creator";
    private static final String LAST_ACCESS_DATE_KEY = "last-access-date";
    private static final String SUBJECT_CREATOR_NICK_KEY = "creator";
    private static final String SUBJECT_DATE_KEY = "date";
    private static final String SUBJECT_KEY = "subject";
    protected Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private MUCConfig mucConfig;
    @Inject
    private UserRepository repository;
    @Inject
    private Room.RoomFactory roomFactory;

    public void createRoom(Room room) throws RepositoryException {
        try {
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + room.getRoomJID(), CREATION_DATE_KEY, String.valueOf(room.getCreationDate().getTime()));
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + room.getRoomJID(), "creator", room.getCreatorJid().toString());
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + room.getRoomJID(), LAST_ACCESS_DATE_KEY, String.valueOf(new Date().getTime()));
            room.getConfig().write(this.repository, this.mucConfig, ROOMS_KEY + room.getRoomJID() + "/config");
            for (BareJID affJid : room.getAffiliations()) {
                Affiliation a = room.getAffiliation(affJid).getAffiliation();
                this.setAffiliation(room.getRoomJID(), affJid, a);
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Room creation error", (Throwable)e);
        }
    }

    public void destroyRoom(BareJID roomJID) throws RepositoryException {
        try {
            this.repository.removeSubnode(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID);
        }
        catch (Exception e) {
            throw new RepositoryException("Room destroing error", (Throwable)e);
        }
    }

    public Date getCreationDate(BareJID roomJID) throws RepositoryException {
        try {
            String creationDate = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID, CREATION_DATE_KEY);
            if (creationDate == null) {
                return null;
            }
            Date r = new Date(Long.valueOf(creationDate));
            return r;
        }
        catch (Exception e) {
            throw new RepositoryException("Creation Date reading error", (Throwable)e);
        }
    }

    public UserRepository getRepository() {
        return this.repository;
    }

    public String getRoomName(String jid) throws RepositoryException {
        try {
            return this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + jid + "/config", "muc#roomconfig_roomname");
        }
        catch (Exception e) {
            throw new RepositoryException("Room name reading error", (Throwable)e);
        }
    }

    public ArrayList<BareJID> getRoomsJIDList() throws RepositoryException {
        ArrayList<BareJID> jids = new ArrayList<BareJID>();
        BareJID serviceName = this.mucConfig.getServiceName();
        try {
            String[] ids = this.repository.getSubnodes(serviceName, ROOMS_KEY);
            if (ids != null) {
                for (String id : ids) {
                    jids.add(BareJID.bareJIDInstance((String)id));
                }
            }
            return jids;
        }
        catch (Exception e) {
            throw new RepositoryException("Room list reading error", (Throwable)e);
        }
    }

    public String getSubject(BareJID roomJID) throws RepositoryException {
        try {
            return this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/subject", SUBJECT_KEY);
        }
        catch (Exception e) {
            throw new RepositoryException("Subject saving error", (Throwable)e);
        }
    }

    public Date getSubjectCreationDate(BareJID roomJID) throws RepositoryException {
        try {
            String tmp = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/subject", SUBJECT_DATE_KEY);
            return tmp == null ? null : new Date(Long.valueOf(tmp));
        }
        catch (Exception e) {
            throw new RepositoryException("Subject change date reading error", (Throwable)e);
        }
    }

    public String getSubjectCreatorNickname(BareJID roomJID) throws RepositoryException {
        try {
            return this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/subject", "creator");
        }
        catch (Exception e) {
            throw new RepositoryException("Subject saving error", (Throwable)e);
        }
    }

    public void initialize() {
        try {
            this.repository.setData(this.mucConfig.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
        }
        catch (UserNotFoundException e) {
            try {
                this.repository.addUser(this.mucConfig.getServiceName());
                this.repository.setData(this.mucConfig.getServiceName(), "last-start", String.valueOf(System.currentTimeMillis()));
            }
            catch (Exception e1) {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "MUC repository initialization problem", e1);
                }
                throw new RuntimeException("Cannot initialize MUC repository", e);
            }
        }
        catch (TigaseDBException e) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, "MUC repository initialization problem", e);
            }
            throw new RuntimeException("Cannot initialize MUC repository", e);
        }
    }

    public Room readRoom(BareJID roomJID) throws RepositoryException {
        try {
            String tmpDate = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID, CREATION_DATE_KEY);
            String creatorJid = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID, "creator");
            if (tmpDate != null && creatorJid != null) {
                JID creatorJID = JID.jidInstance((String)creatorJid);
                Date date = new Date(Long.valueOf(tmpDate));
                RoomConfig rc = new RoomConfig(roomJID);
                rc.read(this.repository, this.mucConfig, ROOMS_KEY + roomJID + "/config");
                RoomWithId<Object> room = this.roomFactory.newInstance(null, rc, date, creatorJID.getBareJID());
                String subject = this.getSubject(roomJID);
                String subjectCreator = this.getSubjectCreatorNickname(roomJID);
                Date subjectChangeDate = this.getSubjectCreationDate(roomJID);
                room.setNewSubject(subject, subjectCreator);
                room.setSubjectChangeDate(subjectChangeDate);
                HashMap<BareJID, RoomAffiliation> affiliations = new HashMap<BareJID, RoomAffiliation>();
                String[] affJids = this.repository.getKeys(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/affiliations");
                if (affJids != null) {
                    for (String jid : affJids) {
                        String t;
                        if (jid == null || jid.isEmpty() || (t = this.repository.getData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/affiliations", jid)) == null) continue;
                        Affiliation affiliation = Affiliation.valueOf(t);
                        affiliations.put(JID.jidInstance((String)jid).getBareJID(), RoomAffiliation.from(affiliation, false, null));
                    }
                }
                room.setAffiliations(affiliations);
                return room;
            }
            return null;
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Room reading error", e);
            }
            throw new RepositoryException("Room reading error", (Throwable)e);
        }
    }

    public void setAffiliation(BareJID roomJID, BareJID jid, Affiliation affiliation) throws RepositoryException {
        try {
            if (affiliation == Affiliation.none) {
                this.repository.removeData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/affiliations", jid.toString());
            } else {
                this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/affiliations", jid.toString(), affiliation.name());
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Affiliation saving error", (Throwable)e);
        }
    }

    public void setSubject(BareJID roomJID, String subject, String creatorNickname, Date changeDate) throws RepositoryException {
        if (changeDate != null) {
            try {
                this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/subject", "creator", creatorNickname);
                this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/subject", SUBJECT_KEY, subject);
                this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID + "/subject", SUBJECT_DATE_KEY, String.valueOf(changeDate.getTime()));
            }
            catch (Exception e) {
                throw new RepositoryException("Subject saving error", (Throwable)e);
            }
        }
    }

    public void updateLastAccessDate(BareJID roomJID) throws RepositoryException {
        try {
            this.repository.setData(this.mucConfig.getServiceName(), ROOMS_KEY + roomJID, LAST_ACCESS_DATE_KEY, String.valueOf(new Date().getTime()));
        }
        catch (Exception e) {
            throw new RepositoryException("Last access date writing error", (Throwable)e);
        }
    }

    public void updateRoomConfig(RoomConfig roomConfig) throws RepositoryException {
        try {
            String roomJID;
            String string = roomJID = roomConfig.getRoomJID() != null ? roomConfig.getRoomJID().toString() : null;
            if (roomJID == null) {
                roomJID = "default_room_config";
            }
            roomConfig.write(this.repository, this.mucConfig, ROOMS_KEY + roomJID + "/config");
        }
        catch (Exception e) {
            throw new RepositoryException("Room config writing error", (Throwable)e);
        }
    }
}

