/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="iqforwarder", active=true)
public class IqStanzaForwarderModule
extends AbstractMucModule {
    public static final String ID = "iqforwarder";
    private static final Criteria SELF_PING_CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"ping", (String)"urn:xmpp:ping"));
    @Inject
    private IMucRepository repository;
    private final Criteria crit = new Criteria(){

        public Criteria add(Criteria criteria) {
            return null;
        }

        public boolean match(Element element) {
            return IqStanzaForwarderModule.this.checkIfProcessed(element);
        }
    };

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return this.crit;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            JID senderJID = packet.getStanzaFrom();
            BareJID roomJID = packet.getStanzaTo().getBareJID();
            String recipientNickname = IqStanzaForwarderModule.getNicknameFromJid(packet.getStanzaTo());
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String senderNickname = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(senderNickname);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Processing IQ stanza, from: {0}, to: {1}, recipientNickname: {2}, senderNickname: {3}, senderRole: {4} ", new Object[]{senderJID, roomJID, recipientNickname, senderNickname, senderRole});
            }
            if (!senderRole.isSendPrivateMessages()) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Role is not allowed to send private messages");
            }
            if (room.getOccupantsJidsByNickname(senderNickname).size() > 1) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Many source resources detected.");
            }
            Collection<JID> recipientJids = room.getOccupantsJidsByNickname(recipientNickname);
            if (recipientJids == null || recipientJids.isEmpty()) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            if (recipientJids.size() > 1) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Many destination resources detected.");
            }
            JID recipientJid = recipientJids.iterator().next();
            Element iq = packet.getElement().clone();
            iq.setAttribute("from", roomJID.toString() + "/" + senderNickname);
            iq.setAttribute("to", recipientJid.toString());
            Packet p = Packet.packetInstance((Element)iq);
            p.setXMLNS("jabber:client");
            this.write(p);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during forwarding IQ", e);
            throw new RuntimeException(e);
        }
    }

    protected boolean checkIfProcessed(Element element) {
        if (element.getName() != "iq") {
            return false;
        }
        try {
            String recipientNickname = IqStanzaForwarderModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to")));
            if (recipientNickname == null) {
                return false;
            }
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                return false;
            }
            String senderNickname = room.getOccupantsNickname(senderJID);
            if (senderNickname == null) {
                return false;
            }
            if (this.isSelfPing(element)) {
                return !recipientNickname.equals(senderNickname);
            }
            return true;
        }
        catch (TigaseStringprepException e) {
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (MUCException e) {
            return false;
        }
    }

    private boolean isSelfPing(Element element) {
        return SELF_PING_CRIT.match(element);
    }
}

