/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.xep0136.modules;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.QueryCriteria;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.modules.AbstractModule;
import tigase.archive.xep0136.Xep0136QueryParser;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;

@Bean(name="listCollections", parent=MessageArchiveComponent.class, active=true)
public class ListCollectionsModule
extends AbstractModule {
    private static final String LIST_ELEM = "list";
    @Inject
    private MessageArchiveRepository.CollectionHandler<QueryCriteria> collectionHandler;
    @Inject
    private Xep0136QueryParser queryParser;

    public String[] getFeatures() {
        return new String[0];
    }

    public Criteria getModuleCriteria() {
        return null;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Element list = packet.getElement().getChild(LIST_ELEM, "urn:xmpp:archive");
        this.listCollections(packet, list);
    }

    public boolean canHandle(Packet packet) {
        return packet.getElement().getChild(LIST_ELEM, "urn:xmpp:archive") != null;
    }

    private void listCollections(Packet packet, Element list) throws ComponentException, TigaseStringprepException {
        try {
            QueryCriteria query = (QueryCriteria)this.msg_repo.newQuery();
            query.setUseMessageIdInRsm(false);
            this.queryParser.parseQuery(query, packet);
            this.msg_repo.queryCollections(query, this.collectionHandler);
            List<Element> chats = query.getCollections();
            Element retList = new Element(LIST_ELEM);
            retList.setXMLNS("urn:xmpp:archive");
            if (chats != null && !chats.isEmpty()) {
                retList.addChildren(chats);
            }
            query.prepareResult(retList);
            this.packetWriter.write(packet.okResult(retList, 0));
        }
        catch (TigaseDBException e) {
            throw new RuntimeException("Error listing collections", e);
        }
    }

    @Bean(name="xep0136CollectionHandler", parent=MessageArchiveComponent.class, active=true)
    public static class Xep0136CollectionHandler<Q extends QueryCriteria>
    implements MessageArchiveRepository.CollectionHandler<Q> {
        private static final SimpleDateFormat TIMESTAMP_FORMATTER1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void collectionFound(Q query, String with, Date start, String type) {
            String formattedStart = null;
            SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMATTER1;
            synchronized (simpleDateFormat) {
                formattedStart = TIMESTAMP_FORMATTER1.format(start);
            }
            Element elem = new Element("chat", new String[]{"with", "start"}, new String[]{with, formattedStart});
            if (type != null && !type.isEmpty()) {
                elem.addAttribute("type", type);
            }
            ((QueryCriteria)query).addCollection(elem);
        }

        static {
            TIMESTAMP_FORMATTER1.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

