/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.xep0136;

import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.MessageArchiveConfig;
import tigase.archive.QueryCriteria;
import tigase.archive.TagsHelper;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.QueryParser;

@Bean(name="xep0136QueryParser", parent=MessageArchiveComponent.class, active=true)
public class Xep0136QueryParser<Q extends QueryCriteria>
implements QueryParser<Q> {
    public static final String ARCHIVE_XMLNS = "urn:xmpp:archive";
    public static final String QUERTY_XMLNS = "http://tigase.org/protocol/archive#query";
    private static final String CONTAINS = "contains";
    private static final String TAG = "tag";
    private static final String NAME = "query";
    private final TimestampHelper timestampHelper = new TimestampHelper();
    @Inject(bean="service")
    private MessageArchiveConfig config;

    public Q parseQuery(Q query, Packet packet) throws ComponentException {
        List children;
        query.setQuestionerJID(packet.getStanzaFrom());
        query.setComponentJID(packet.getStanzaTo());
        Element el = packet.getElement().findChild(element -> element.getXMLNS() == ARCHIVE_XMLNS);
        if (el == null) {
            throw new IllegalArgumentException("Not supported XMLNS of element");
        }
        String withStr = el.getAttributeStaticStr("with");
        if (withStr != null && !withStr.isEmpty()) {
            try {
                query.setWith(JID.jidInstance((String)withStr));
            }
            catch (TigaseStringprepException ex) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'with' attribute", (Throwable)ex);
            }
        }
        String start = el.getAttributeStaticStr("start");
        try {
            query.setStart(this.timestampHelper.parseTimestamp(start));
        }
        catch (ParseException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'start' field", (Throwable)ex);
        }
        String end = el.getAttributeStaticStr("end");
        try {
            query.setEnd(this.timestampHelper.parseTimestamp(end));
        }
        catch (ParseException ex) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Invalid value in 'end' field", (Throwable)ex);
        }
        query.getRsm().fromElement(el);
        Element queryEl = el.getChild(NAME, QUERTY_XMLNS);
        if (queryEl != null && (children = queryEl.getChildren()) != null) {
            HashSet<String> tags = new HashSet<String>();
            for (Element child : children) {
                String cdata = null;
                switch (child.getName()) {
                    case "contains": {
                        cdata = child.getCData();
                        if (cdata == null) break;
                        ((QueryCriteria)query).addContains(cdata);
                        if (!this.config.isTagSupportEnabled()) break;
                        TagsHelper.extractTags(tags, cdata);
                        break;
                    }
                    case "tag": {
                        cdata = child.getCData();
                        if (cdata == null) break;
                        ((QueryCriteria)query).addTag(cdata.trim());
                    }
                }
            }
            for (String tag : tags) {
                ((QueryCriteria)query).addTag(tag);
            }
        }
        return query;
    }

    public Element prepareForm(Element elem) {
        return null;
    }
}

