/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import tigase.archive.db.MessageArchiveRepository;
import tigase.archive.xep0136.Query;
import tigase.db.DataSource;
import tigase.xml.Element;
import tigase.xmpp.rsm.RSM;

public abstract class AbstractMessageArchiveRepository<Q extends Query, DS extends DataSource>
implements MessageArchiveRepository<Q, DS> {
    protected static final String[] MSG_BODY_PATH = new String[]{"message", "body"};
    protected static final String[] MSG_SUBJECT_PATH = new String[]{"message", "subject"};
    private static final SimpleDateFormat TIMESTAMP_FORMATTER1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");

    protected byte[] generateHashOfMessage(MessageArchiveRepository.Direction direction, Element msg, Date ts, Map<String, Object> additionalData) {
        try {
            String body;
            String peer;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String string = peer = direction == MessageArchiveRepository.Direction.incoming ? msg.getAttributeStaticStr("from") : msg.getAttributeStaticStr("to");
            if (peer != null) {
                md.update(peer.getBytes());
            }
            String type = msg.getAttributeStaticStr("type");
            Element subjectEl = msg.getChild("subject");
            String subject = msg.getChildCData(MSG_SUBJECT_PATH);
            String id = msg.getAttributeStaticStr("id");
            if (id != null) {
                if (!"groupchat".equals(type) || subjectEl == null) {
                    md.update(id.getBytes());
                } else {
                    md.update(":".getBytes());
                    md.update(new Long(ts.getTime() / 60000L).toString().getBytes());
                }
            }
            if (type == null || !"groupchat".equals(type)) {
                md.update(new Long(ts.getTime() / 1000L).toString().getBytes());
            }
            if ((body = msg.getChildCData(MSG_BODY_PATH)) != null) {
                md.update(body.getBytes());
            }
            if (subject != null) {
                md.update(subject.getBytes());
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    protected void calculateOffsetAndPosition(Q query, int count, Integer before, Integer after) {
        RSM rsm = query.getRsm();
        int index = rsm.getIndex() == null ? 0 : rsm.getIndex();
        int limit = rsm.getMax();
        if (after != null) {
            index = after + 1;
        } else if (before != null) {
            index = before - rsm.getMax();
            if (index < 0) {
                index = 0;
                limit = before;
            }
        } else if (rsm.hasBefore() && (index = count - rsm.getMax()) < 0) {
            index = 0;
        }
        rsm.setIndex(Integer.valueOf(index));
        rsm.setMax(limit);
        rsm.setCount(Integer.valueOf(count));
    }

    static {
        TIMESTAMP_FORMATTER1.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

