/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.PubSubComponentClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.commands.NodesChangedCommand;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="strategy", parent=PubSubComponentClustered.class, active=true)
public class PartitionedStrategy
extends AbstractStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(PartitionedStrategy.class.getCanonicalName());
    protected final ThreadLocal<ArrayDeque<Element>> nodesModifications = ThreadLocal.withInitial(() -> new ArrayDeque());
    @Inject
    private NodesChangedCommand nodesChangedCommand;

    @Override
    public boolean filterOutPacket(Packet packet) {
        return false;
    }

    public JID getNodeForServiceNode(JID serviceJid, String node) {
        int n = Math.abs((391 + serviceJid.hashCode()) * 23 + node.hashCode());
        return this.getNodeForHashCode(n);
    }

    @Override
    public List<JID> getNodesForPacket(Packet packet) {
        if (packet.getElemName() == "presence") {
            if (this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                return Collections.singletonList(this.getLocalNodeJid());
            }
            return this.getNodesConnectedWithLocal();
        }
        if (packet.getElemName() == "message") {
            return Collections.singletonList(this.getLocalNodeJid());
        }
        if (packet.getElemName() == "iq") {
            Element element;
            JID jID = packet.getStanzaTo();
            List list = packet.getElemChildrenStaticStr(PUBSUB_PATH);
            Element element2 = element = list != null && !list.isEmpty() ? (Element)list.get(0) : null;
            if (element == null) {
                Element element3;
                if (packet.getType() == StanzaType.result && (element3 = packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info")) != null && element3.getAttributeStaticStr("node") != null) {
                    if (this.pubSubComponent != null && packet.getPacketFrom() != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                        if (a.isLoggable(Level.FINEST)) {
                            a.log(Level.FINEST, "IQ packet, forwarded disco#info for CAPS, returning local node, packet: {0}", new Object[]{packet});
                        }
                        return Collections.singletonList(this.getLocalNodeJid());
                    }
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "IQ packet, disco#info for CAPS, returning all nodes, packet: {0}", new Object[]{packet});
                    }
                    return this.getNodesConnectedWithLocal();
                }
                return Collections.singletonList(this.getLocalNodeJid());
            }
            String string = element.getAttributeStaticStr("node");
            if (string == null || this.isNodeConfigure(element)) {
                JID jID2 = this.getNodeForServiceJid(jID);
                return Collections.singletonList(jID2);
            }
            JID jID3 = this.getNodeForServiceNode(jID, string);
            return Collections.singletonList(jID3);
        }
        a.log(Level.SEVERE, "received unknown packet = {0}", packet);
        return null;
    }

    @Override
    public boolean isLocalNode(BareJID serviceJid, String node) {
        return this.getLocalNodeJid().equals((Object)this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), node));
    }

    @Override
    public boolean isOnlineLocally(JID jid) {
        return true;
    }

    @Override
    public void nodeAddedToCollection(BareJID serviceJid, String nodeName, String collection) {
        JID jID = this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        this.nodesModifications.get().offer(new Element("child-node-added", new String[]{"service-jid", "node", "child"}, new String[]{serviceJid.toString(), collection, nodeName}));
    }

    @Override
    public void nodeAddedToRootCollection(BareJID serviceJid, String nodeName) {
        this.nodesModifications.get().offer(new Element("root-node-added", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeRemovedFromCollection(BareJID serviceJid, String nodeName, String collection) {
        JID jID = this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        this.nodesModifications.get().offer(new Element("child-node-removed", new String[]{"service-jid", "node", "child"}, new String[]{serviceJid.toString(), collection, nodeName}));
    }

    @Override
    public void nodeRemovedFromRootCollection(BareJID serviceJid, String nodeName) {
        this.nodesModifications.get().offer(new Element("root-node-removed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeConfigurationChanged(BareJID serviceJid, String nodeName) {
        JID jID;
        JID jID2 = jID = nodeName == null ? this.getNodeForServiceJid(JID.jidInstance((BareJID)serviceJid)) : this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        this.nodesModifications.get().offer(new Element("node-config-changed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeAffiliationsChanged(BareJID serviceJid, String nodeName, Map<BareJID, UsersAffiliation> changedAffiliations) {
        JID jID;
        JID jID2 = jID = nodeName == null ? this.getNodeForServiceJid(JID.jidInstance((BareJID)serviceJid)) : this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        Queue queue = this.nodesModifications.get();
        for (Map.Entry<BareJID, UsersAffiliation> entry : changedAffiliations.entrySet()) {
            queue.offer(new Element("node-affiliation-changed", new String[]{"service-jid", "node", "jid", "aff"}, new String[]{serviceJid.toString(), nodeName, entry.getKey().toString(), entry.getValue().getAffiliation().name()}));
        }
    }

    @Override
    public void nodeSubscriptionsChanged(BareJID serviceJid, String nodeName, Map<BareJID, UsersSubscription> changedSubscriptions) {
        JID jID;
        JID jID2 = jID = nodeName == null ? this.getNodeForServiceJid(JID.jidInstance((BareJID)serviceJid)) : this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        Queue queue = this.nodesModifications.get();
        for (Map.Entry<BareJID, UsersSubscription> entry : changedSubscriptions.entrySet()) {
            UsersSubscription usersSubscription = entry.getValue();
            queue.offer(new Element("node-subscription-changed", new String[]{"service-jid", "node", "jid", "sub", "id"}, new String[]{serviceJid.toString(), nodeName, entry.getKey().toString(), usersSubscription.getSubscription().name(), usersSubscription.getSubid()}));
        }
    }

    public void notifyNodeConfigurationChanges() {
        Queue queue = this.nodesModifications.get();
        List<JID> list = this.a(queue);
        this.nodesModifications.remove();
        Map<String, String> map = this.prepareCommandData(null, null);
        this.cl_controller.sendToNodes("nodes-changed-cmd", map, queue, this.getLocalNodeJid(), null, list.toArray(new JID[list.size()]));
    }

    @Override
    public void packetProcessed() {
        if (!this.nodesModifications.get().isEmpty()) {
            this.notifyNodeConfigurationChanges();
        }
        super.packetProcessed();
    }

    @Override
    public void userRemoved(BareJID serviceJid) {
        this.nodesModifications.get().offer(new Element("user-removed", new String[]{"service-jid"}, new String[]{serviceJid.toString()}));
    }

    private List<JID> a(Queue<Element> queue) {
        ArrayList<JID> arrayList = new ArrayList<JID>();
        for (Element element : queue) {
            String string;
            switch (element.getName()) {
                case "root-node-added": 
                case "root-node-removed": 
                case "node-config-changed": {
                    return this.getNodesConnected();
                }
            }
            JID jID = JID.jidInstanceNS((String)element.getAttributeStaticStr("service-jid"));
            JID jID2 = this.getNodeForServiceNode(jID, string = element.getAttributeStaticStr("node"));
            if (jID2 == null || this.getLocalNodeJid().equals((Object)jID2) || arrayList.contains(jID2)) continue;
            arrayList.add(jID2);
        }
        return arrayList;
    }
}

