/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.cluster.IPubSubRepositoryClustered;
import tigase.pubsub.cluster.PartitionedStrategy;
import tigase.pubsub.cluster.PubSubComponentClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.stats.StatisticsList;
import tigase.xmpp.jid.BareJID;

@Bean(name="pubsubRepository", parent=PubSubComponentClustered.class, active=true)
public class CachedPubSubRepositoryClustered<T>
extends CachedPubSubRepository<T>
implements IPubSubRepositoryClustered<T> {
    private static final Logger a = Logger.getLogger(CachedPubSubRepositoryClustered.class.getCanonicalName());
    private ThreadLocal<Map<CachedPubSubRepository.NodeKey, Node>> b = new ThreadLocal();
    @Inject
    private StrategyIfc strategy;

    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.addToRootCollection(serviceJid, nodeName);
        this.strategy.nodeAddedToRootCollection(serviceJid, nodeName);
    }

    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.removeFromRootCollection(serviceJid, nodeName);
        this.strategy.nodeRemovedFromRootCollection(serviceJid, nodeName);
    }

    @Override
    public IPubSubRepository.RootCollectionSetIfc getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        return super.getRootCollectionSet(serviceJid);
    }

    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.forgetConfiguration(serviceJid, nodeName);
    }

    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        super.deleteNode(serviceJid, nodeName);
        this.strategy.nodeConfigurationChanged(serviceJid, nodeName);
    }

    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        super.update(serviceJid, nodeName, nodeConfig);
        this.strategy.nodeConfigurationChanged(serviceJid, nodeName);
    }

    @Override
    public Node getNodeFromCache(BareJID serviceJid, String nodeName) {
        return super.getNodeFromCache(serviceJid, nodeName);
    }

    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        AbstractNodeConfig abstractNodeConfig;
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Getting node config wrapNodeConfig, serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        if ((abstractNodeConfig = super.getNodeConfig(serviceJid, nodeName)) != null) {
            return this.strategy.wrapNodeConfig(serviceJid, nodeName, abstractNodeConfig);
        }
        return abstractNodeConfig;
    }

    @Override
    public void clearRemoteNodes() {
        Map<CachedPubSubRepository.NodeKey, Node> map = this.b.get();
        if (map != null) {
            map.clear();
        }
    }

    public long getNodesCount(BareJID serviceJID) throws RepositoryException {
        if (serviceJID == null && this.strategy instanceof PartitionedStrategy) {
            return this.getPubSubDAO().getNodesCount(serviceJID);
        }
        return super.getNodesCount(serviceJID);
    }

    @Override
    public void nodeAdded(BareJID serviceJid, String node) {
        this.nodesCount.incrementAndGet();
    }

    @Override
    public void nodeRemoved(BareJID serviceJid, String node) {
        this.nodesCount.decrementAndGet();
    }

    public void getStatistics(String name, StatisticsList stats) {
        if (stats.checkLevel(Level.FINEST) && this.strategy instanceof PartitionedStrategy) {
            try {
                this.nodesCount.set(this.getPubSubDAO().getNodesCount(null));
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        super.getStatistics(name, stats);
    }

    public void onUserRemoved(BareJID userJid) throws RepositoryException {
        this.strategy.userRemoved(userJid);
        super.onUserRemoved(userJid);
    }

    public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        HashMap<BareJID, UsersAffiliation> hashMap = null;
        if (nodeAffiliations.isChanged() && nodeAffiliations instanceof NodeAffiliations) {
            hashMap = new HashMap<BareJID, UsersAffiliation>(((NodeAffiliations)nodeAffiliations).getChanged());
        }
        super.update(serviceJid, nodeName, nodeAffiliations);
        if (hashMap != null) {
            this.strategy.nodeAffiliationsChanged(serviceJid, nodeName, hashMap);
        }
    }

    public void update(BareJID serviceJid, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        HashMap<BareJID, UsersSubscription> hashMap = null;
        if (nodeSubscriptions.isChanged() && nodeSubscriptions instanceof tigase.pubsub.repository.cached.NodeSubscriptions) {
            hashMap = new HashMap<BareJID, UsersSubscription>(((tigase.pubsub.repository.cached.NodeSubscriptions)nodeSubscriptions).getChanged());
        }
        super.update(serviceJid, nodeName, nodeSubscriptions);
        if (hashMap != null) {
            this.strategy.nodeSubscriptionsChanged(serviceJid, nodeName, hashMap);
        }
    }

    @Override
    public void userRemoved(BareJID userJid) {
        super.userRemoved(userJid);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node;
        CachedPubSubRepository.NodeKey nodeKey = this.createKey(serviceJid, nodeName);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Getting node, serviceJid: {0}, nodeName: {1}, key: {2}, isLocalNode(): {3}", new Object[]{serviceJid, nodeName, nodeKey, this.isLocalNode(serviceJid, nodeName)});
        }
        if (this.isLocalNode(serviceJid, nodeName)) {
            node = super.getNode(serviceJid, nodeName);
        } else {
            Map<CachedPubSubRepository.NodeKey, Node> map = this.b.get();
            if (map == null) {
                map = new HashMap<CachedPubSubRepository.NodeKey, Node>();
                this.b.set(map);
            }
            if ((node = map.get(nodeKey)) == null) {
                INodeMeta iNodeMeta = this.dao.getNodeMeta(serviceJid, nodeName);
                if (iNodeMeta == null) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Getting node[1] -- nodeId null! serviceJid: {0}, nodeName: {1}, nodeId: {2}", new Object[]{serviceJid, nodeName, null});
                    }
                    return null;
                }
                AbstractNodeConfig abstractNodeConfig = iNodeMeta.getNodeConfig();
                if (abstractNodeConfig == null) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Getting node[2] -- config null! serviceJid: {0}, nodeName: {1}, cfgData: {2}", new Object[]{serviceJid, nodeName, null});
                    }
                    return null;
                }
                NodeAffiliations nodeAffiliations = new NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, iNodeMeta.getNodeId()));
                tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = this.wrapNodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, iNodeMeta.getNodeId()));
                node = new Node(iNodeMeta.getNodeId(), serviceJid, abstractNodeConfig, nodeAffiliations, nodeSubscriptions, iNodeMeta.getCreator(), iNodeMeta.getCreationTime());
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Getting node[2], serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeAffiliations {4}, nodeSubscriptions: {5}", new Object[]{serviceJid, nodeName, nodeKey, node, nodeAffiliations, nodeSubscriptions});
                }
                map.put(nodeKey, node);
            }
        }
        return node;
    }

    protected boolean isLocalNode(BareJID serviceJid, String nodeName) {
        return this.strategy.isLocalNode(serviceJid, nodeName);
    }

    protected void nodeCollectionChanged(BareJID serviceJid, String nodeName, String oldCollection, String newCollection) {
        super.nodeCollectionChanged(serviceJid, nodeName, oldCollection, newCollection);
        if (oldCollection != null && !"".equals(oldCollection)) {
            this.strategy.nodeRemovedFromCollection(serviceJid, nodeName, oldCollection);
        }
        if (newCollection != null && !"".equals(newCollection)) {
            this.strategy.nodeAddedToCollection(serviceJid, nodeName, newCollection);
        }
    }

    protected tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        return this.strategy.wrapNodeSubscriptions(nodeSubscriptions);
    }
}

