/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.component.exceptions.ComponentException;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class AbstractStrategy
implements Initializable,
UnregisterAware,
StrategyIfc {
    protected static final String NODE_ATTR = "node";
    protected static final String[] PUBSUB_PATH = new String[]{"iq", "pubsub"};
    private static final Logger a = Logger.getLogger(AbstractStrategy.class.getCanonicalName());
    protected final Set<String> nodeConfigureElemNames = new HashSet<String>();
    private final AtomicInteger b = new AtomicInteger();
    protected ClusterControllerIfc cl_controller;
    @Inject
    protected PubSubConfig config;
    @Inject
    protected EventBus eventBus;
    protected JID localNodeJid;
    @Inject(bean="service")
    protected PubSubComponentClusteredIfc pubSubComponent;

    protected AbstractStrategy() {
        this.nodeConfigureElemNames.add("create");
        this.nodeConfigureElemNames.add("configure");
        this.nodeConfigureElemNames.add("default");
        this.nodeConfigureElemNames.add("delete");
    }

    @Override
    public List<JID> getNodesConnected() {
        return this.pubSubComponent.getNodesConnected();
    }

    @Override
    public List<JID> getNodesConnectedWithLocal() {
        return this.pubSubComponent.getNodesConnectedWithLocal();
    }

    @Override
    public JID getLocalNodeJid() {
        return this.localNodeJid;
    }

    protected void setLocalNodeJid(JID jid) {
        this.localNodeJid = jid;
    }

    public JID getNodeForServiceJid(JID serviceJid) {
        int n = serviceJid.hashCode();
        return this.getNodeForHashCode(n);
    }

    @Override
    public void nodeConnected(JID jid) {
    }

    @Override
    public void nodeDisconnected(JID jid) {
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.cl_controller = cl_controller;
    }

    @Override
    public void setConfig(PubSubConfig config) {
        this.config = config;
    }

    @Override
    public void setPubSubComponent(PubSubComponentClusteredIfc pubSubComponent) {
        this.pubSubComponent = pubSubComponent;
        this.setLocalNodeJid(JID.jidInstanceNS((String)pubSubComponent.getName(), (String)pubSubComponent.getDefHostName().getDomain(), null));
    }

    @Override
    public void packetProcessed() {
    }

    @Override
    public boolean sendException(Packet packet, ComponentException ex) {
        return true;
    }

    @Override
    public AbstractNodeConfig wrapNodeConfig(BareJID serviceJid, String nodeName, AbstractNodeConfig config) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Not wrapping nodeConfig");
        }
        return config;
    }

    @Override
    public tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        return new tigase.pubsub.repository.cached.NodeSubscriptions(nodeSubscriptions);
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    protected JID getNodeForHashCode(int hashCode) {
        List<JID> list = this.getNodesConnectedWithLocal();
        return list.get(Math.abs(hashCode % list.size()));
    }

    protected Map<String, String> prepareCommandData(BareJID serviceJid, String nodeName) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (serviceJid != null) {
            hashMap.put("service-jid", serviceJid.toString());
        }
        if (nodeName != null) {
            hashMap.put(NODE_ATTR, nodeName);
            hashMap.put("userId", nodeName);
        } else {
            int n = this.b.incrementAndGet();
            hashMap.put("userId", String.valueOf(n));
        }
        return hashMap;
    }

    protected boolean isNodeConfigure(Element pubsubElem) {
        String string = pubsubElem.getName();
        return this.nodeConfigureElemNames.contains(string);
    }

    private void a(List<JID> list) {
        Object[] objectArray = list.toArray(new JID[list.size()]);
        Arrays.sort(objectArray);
        list.clear();
        list.addAll(Arrays.asList(objectArray));
    }
}

