/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.cluster.AbstractStrategy;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.MUCComponentClustered;
import tigase.muc.cluster.StrategyIfc;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="strategy", parent=MUCComponentClustered.class, active=true)
public class ShardingStrategy
extends AbstractStrategy
implements Room.RoomOccupantListener,
InMemoryMucRepositoryClustered.RoomListener,
StrategyIfc {
    private static final Logger a = Logger.getLogger(ShardingStrategy.class.getCanonicalName());
    private static final String b = "muc-node-shutdown-cmd";
    private static final String c = "muc-sync-response";
    private static final String d = "muc-room-changed-cmd";
    private static final String e = "muc-room-created-cmd";
    private static final String f = "muc-room-destroyed-cmd";
    private static final String g = "muc-room-left-cmd";
    private static final int h = 1000;
    private static final String[] i = new String[]{"muc#roomconfig_roomname", "muc#roomconfig_publicroom", "muc#roomconfig_persistentroom"};
    private final ConcurrentMap<BareJID, Set<JID>> j = new ConcurrentHashMap<BareJID, Set<JID>>();
    private final ConcurrentMap<BareJID, JID> k = new ConcurrentHashMap<BareJID, JID>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDisconnected(JID nodeJid) {
        List<JID> list = this.getNodesConnectedWithLocal();
        int n = list.indexOf(this.localNodeJid);
        Iterator iterator = this.k.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!nodeJid.equals(entry.getValue())) continue;
            iterator.remove();
            BareJID bareJID = (BareJID)entry.getKey();
            this.mucRepository.removeFromAllRooms(bareJID, internalRoom -> !internalRoom.isPersistent);
            Set set = (Set)this.j.remove(bareJID);
            if (bareJID.hashCode() % list.size() != n || set == null) continue;
            Set set2 = set;
            synchronized (set2) {
                for (JID jID : set) {
                    this.sendRemovalFromRoomOnNodeDisconnect(bareJID, jID);
                }
            }
        }
    }

    @Override
    public boolean processPacket(Packet packet) {
        BareJID bareJID = packet.getStanzaTo().getBareJID();
        JID jID = this.getNodeForRoom(bareJID);
        if (this.localNodeJid.equals((Object)jID)) {
            return false;
        }
        if (a.isLoggable(Level.FINER)) {
            a.log(Level.FINER, "room = {0}, forwarding packet to node = {1}", new Object[]{bareJID, jID});
        }
        this.forwardPacketToNode(jID, packet);
        return true;
    }

    @Override
    public void setMucRepository(InMemoryMucRepositoryClustered mucRepository) {
        super.setMucRepository(mucRepository);
        mucRepository.setRoomListener(this);
        mucRepository.setRoomOccupantListener(this);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        List<JID> list = this.getNodesConnected();
        if (this.cl_controller != null && list != null) {
            this.cl_controller.sendToNodes(b, this.localNodeJid, list.toArray(new JID[list.size()]));
        }
    }

    @Override
    public void onLeaveRoom(Room room) {
        this.k.remove(room.getRoomJID());
        this.j.remove(room.getRoomJID());
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("persistent", String.valueOf(room.getConfig().isPersistentRoom()));
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is left", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(g, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
        if (!(modifiedVars.contains("muc#roomconfig_roomname") || modifiedVars.contains("muc#roomconfig_publicroom") || modifiedVars.contains("muc#roomconfig_persistentroom"))) {
            return;
        }
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", roomConfig.getRoomJID().toString());
        for (String string : i) {
            if (!modifiedVars.contains(string)) continue;
            String string2 = roomConfig.getConfigForm().getAsString(string);
            hashMap.put(string, string2);
        }
        this.cl_controller.sendToNodes(d, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomCreated(Room room) {
        this.k.put(room.getRoomJID(), this.localNodeJid);
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("public", String.valueOf(room.getConfig().isRoomconfigPublicroom()));
        hashMap.put("persistent", String.valueOf(room.getConfig().isPersistentRoom()));
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is created", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(e, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    @Override
    public void onRoomDestroyed(Room room, Element destroyElement) {
        this.k.remove(room.getRoomJID());
        Set set = (Set)this.j.remove(room.getRoomJID());
        List<JID> list = this.getNodesConnected();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that room is destroyed", new Object[]{room.getRoomJID(), stringBuilder});
        }
        this.cl_controller.sendToNodes(f, hashMap, this.localNodeJid, list.toArray(new JID[list.size()]));
    }

    public void onOccupantChangedPresence(Room room, JID occupantJid, String nickname, Element presence, boolean newOccupant) {
    }

    protected JID getNodeForRoom(BareJID roomJid) {
        JID jID = (JID)this.k.get(roomJid);
        if (jID == null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, not created on any node", roomJid);
            }
            int n = roomJid.hashCode();
            List<JID> list = this.getNodesConnectedWithLocal();
            jID = list.get(Math.abs(n) % list.size());
            if (a.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder(100);
                for (JID jID2 : list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(jID2.toString());
                }
                a.log(Level.FINEST, "room = {0}, selected node = {1} to handle this room by hash = {2} from {3}", new Object[]{roomJid, jID, n, stringBuilder});
            }
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "room = {0}, selected node = {1} to handle this room", new Object[]{roomJid, jID});
        }
        return jID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean addOccupant(BareJID node, BareJID roomJid, JID occupantJid, String nickname) {
        Set<Object> set;
        HashSet<JID> hashSet = (HashSet<JID>)this.j.get(roomJid);
        if (hashSet == null && (set = (Set)this.j.putIfAbsent(roomJid, hashSet = new HashSet<JID>())) != null) {
            hashSet = set;
        }
        set = hashSet;
        synchronized (set) {
            return hashSet.add(occupantJid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeOccupant(BareJID node, BareJID roomJid, JID occupantJid) {
        Set set = (Set)this.j.get(roomJid);
        if (set == null) {
            return false;
        }
        Set set2 = set;
        synchronized (set2) {
            return set.remove(occupantJid);
        }
    }

    @Bean(name="muc-room-left-cmd", parent=ShardingStrategy.class, active=true)
    public static class RoomLeftCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public RoomLeftCmd() {
            super(ShardingStrategy.g, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            this.strategy.k.remove(bareJID, fromNode);
            this.strategy.j.remove(bareJID);
            boolean bl = "false".equals(data.get("persistent"));
            if (bl) {
                this.strategy.mucRepository.removeFromAllRooms(bareJID);
            }
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was left at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    @Bean(name="muc-room-destroyed-cmd", parent=ShardingStrategy.class, active=true)
    public static class RoomDestroyedCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public RoomDestroyedCmd() {
            super(ShardingStrategy.f, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            this.strategy.k.remove(bareJID, fromNode);
            this.strategy.j.remove(bareJID);
            this.strategy.mucRepository.removeFromAllRooms(bareJID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was destroyed at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    @Bean(name="muc-room-created-cmd", parent=ShardingStrategy.class, active=true)
    public static class RoomCreatedCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public RoomCreatedCmd() {
            super(ShardingStrategy.e, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
            this.strategy.k.put(bareJID, fromNode);
            InMemoryMucRepository.InternalRoom internalRoom = new InMemoryMucRepository.InternalRoom();
            internalRoom.isPublic = !"false".equals(data.get("public"));
            internalRoom.isPersistent = !"false".equals(data.get("persistent"));
            this.strategy.mucRepository.addToAllRooms(bareJID, internalRoom);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was created at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    @Bean(name="muc-room-changed-cmd", parent=ShardingStrategy.class, active=true)
    public static class RoomChangedCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public RoomChangedCmd() {
            super(ShardingStrategy.d, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.remove("room"));
            this.strategy.mucRepository.roomConfigChanged(bareJID, data);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "room = {0}, received notification that room {1} was modified at node {2}", new Object[]{bareJID, bareJID, fromNode});
            }
        }
    }

    @Bean(name="muc-sync-response", parent=ShardingStrategy.class, active=true)
    public static class ResponseSyncCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public ResponseSyncCmd() {
            super(ShardingStrategy.c, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            if (packets != null && !packets.isEmpty()) {
                for (Element element : packets) {
                    List list;
                    if (element.getName() != "room") continue;
                    BareJID bareJID = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("jid"));
                    String string = element.getAttributeStaticStr("name");
                    boolean bl = !"false".equals(element.getAttributeStaticStr("public"));
                    boolean bl2 = !"false".equals(element.getAttributeStaticStr("persistent"));
                    JID jID = this.strategy.k.put(bareJID, fromNode);
                    if (jID != null && !fromNode.equals((Object)jID)) {
                        a.log(Level.SEVERE, "received info about a room {0} on {1} but we had info about this room on node {2}", new Object[]{bareJID, fromNode, jID});
                    }
                    if (jID == null) {
                        list = new InMemoryMucRepository.InternalRoom();
                        ((InMemoryMucRepository.InternalRoom)list).name = string;
                        ((InMemoryMucRepository.InternalRoom)list).isPublic = bl;
                        ((InMemoryMucRepository.InternalRoom)list).isPersistent = bl2;
                        this.strategy.mucRepository.addToAllRooms(bareJID, (InMemoryMucRepository.InternalRoom)list);
                    }
                    if ((list = element.getChildren()) == null || list.isEmpty()) continue;
                    for (Element element2 : list) {
                        JID jID2 = JID.jidInstanceNS((String)element2.getCData());
                        String string2 = element2.getAttributeStaticStr("nickname");
                        this.strategy.addOccupant(fromNode.getBareJID(), bareJID, jID2, string2);
                    }
                }
            }
        }
    }

    @Bean(name="muc-sync-request", parent=ShardingStrategy.class, active=true)
    public static class RequestSyncCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public RequestSyncCmd() {
            super("muc-sync-request", Priority.HIGH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            LinkedList<Element> linkedList = new LinkedList<Element>();
            for (Map.Entry entry : this.strategy.k.entrySet()) {
                Element element;
                block9: {
                    if (!this.strategy.localNodeJid.equals(entry.getValue())) continue;
                    element = new Element("room", new String[]{"jid"}, new String[]{((BareJID)entry.getKey()).toString()});
                    try {
                        Set set;
                        Room room = this.strategy.mucRepository.getRoom((BareJID)entry.getKey());
                        if (room != null) {
                            Optional.ofNullable(room.getConfig()).map(RoomConfig::getRoomName).ifPresent(string -> element.setAttribute("name", string));
                            element.setAttribute("name", room.getConfig().getRoomName());
                            element.setAttribute("public", String.valueOf(room.getConfig().isRoomconfigPublicroom()));
                            element.setAttribute("persistent", String.valueOf(room.getConfig().isPersistentRoom()));
                        }
                        if ((set = (Set)this.strategy.j.get(entry.getKey())) == null || set.isEmpty()) break block9;
                        Set set2 = set;
                        synchronized (set2) {
                            for (JID jID : set) {
                                String string2 = room.getOccupantsNickname(jID);
                                if (string2 == null) continue;
                                Element element2 = new Element("occupant", jID.toString());
                                element2.addAttribute("nickname", string2);
                                element.addChild((XMLNodeIfc)element2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "exception during cluster nodes synchronization", exception);
                    }
                }
                linkedList.add(element);
                if (linkedList.size() <= 1000) continue;
                this.strategy.cl_controller.sendToNodes(ShardingStrategy.c, linkedList, this.strategy.localNodeJid, null, new JID[]{fromNode});
                linkedList = new LinkedList();
            }
            if (!linkedList.isEmpty()) {
                this.strategy.cl_controller.sendToNodes(ShardingStrategy.c, linkedList, this.strategy.localNodeJid, null, new JID[]{fromNode});
            }
        }
    }

    @Bean(name="muc-node-shutdown-cmd", parent=ShardingStrategy.class, active=true)
    public static class NodeShutdownCmd
    extends CommandListenerAbstract {
        @Inject
        private ShardingStrategy strategy;

        public NodeShutdownCmd() {
            super(ShardingStrategy.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            Iterator iterator = this.strategy.k.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!fromNode.equals(entry.getValue())) continue;
                iterator.remove();
                this.strategy.j.remove(entry.getKey());
            }
        }
    }
}

